/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import ddtrot.dd.trace.bootstrap.instrumentation.api.Baggage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public final class DDBaggage
implements Baggage {
    private static final Baggage EMPTY = new DDBaggage(Collections.emptyMap());
    private final Map<String, String> items;

    private DDBaggage(Map<String, String> items) {
        this.items = items;
    }

    public static Baggage empty() {
        return EMPTY;
    }

    public static Baggage.Builder builder() {
        return new DDBaggageBuilder(Collections.emptyMap());
    }

    @Override
    public String get(String key) {
        return this.items.get(key);
    }

    @Override
    public void forEach(BiConsumer<String, String> consumer) {
        this.items.forEach(consumer);
    }

    @Override
    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.items);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DDBaggage that = (DDBaggage)o;
        return this.items.equals(that.items);
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    @Override
    public Baggage.Builder toBuilder() {
        return new DDBaggageBuilder(this.items);
    }

    private static class DDBaggageBuilder
    implements Baggage.Builder {
        private final Map<String, String> items;

        DDBaggageBuilder(Map<String, String> items) {
            this.items = new HashMap<String, String>(items);
        }

        @Override
        public Baggage.Builder put(String key, String value) {
            this.items.put(key, value);
            return this;
        }

        @Override
        public Baggage.Builder remove(String key) {
            this.items.remove(key);
            return this;
        }

        @Override
        public Baggage build() {
            return this.items.isEmpty() ? DDBaggage.empty() : new DDBaggage(new HashMap<String, String>(this.items));
        }
    }
}

