/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.rest.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.ValidationException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.sf.mmm.util.exception.api.NlsRuntimeException;
import net.sf.mmm.util.exception.api.NlsThrowable;
import net.sf.mmm.util.exception.api.SecurityErrorUserException;
import net.sf.mmm.util.exception.api.TechnicalErrorUserException;
import net.sf.mmm.util.exception.api.ValidationErrorUserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RestServiceExceptionFacade
implements ExceptionMapper<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(RestServiceExceptionFacade.class);
    private final List<Class<? extends Throwable>> securityExceptions = new ArrayList<Class<? extends Throwable>>();
    private final Class<? extends Throwable> transactionSystemException;
    private final Class<? extends Throwable> rollbackException;
    private ObjectMapper mapper;
    private boolean exposeInternalErrorDetails;

    public RestServiceExceptionFacade() {
        this.registerToplevelSecurityExceptions();
        this.transactionSystemException = this.loadException("org.springframework.transaction.TransactionSystemException");
        this.rollbackException = this.loadException("javax.persistence.RollbackException");
    }

    protected void registerToplevelSecurityException(Class<? extends Throwable> securityException) {
        this.securityExceptions.add(securityException);
    }

    protected void registerToplevelSecurityExceptions() {
        this.securityExceptions.add(SecurityException.class);
        this.securityExceptions.add(SecurityErrorUserException.class);
        this.registerToplevelSecurityExceptions("org.springframework.security.access.AccessDeniedException");
        this.registerToplevelSecurityExceptions("org.springframework.security.authentication.AuthenticationServiceException");
        this.registerToplevelSecurityExceptions("org.springframework.security.authentication.AuthenticationCredentialsNotFoundException");
        this.registerToplevelSecurityExceptions("org.springframework.security.authentication.BadCredentialsException");
        this.registerToplevelSecurityExceptions("org.springframework.security.authentication.AccountExpiredException");
    }

    protected void registerToplevelSecurityExceptions(String className) {
        Class<? extends Throwable> securityException = this.loadException(className);
        if (securityException != null) {
            this.registerToplevelSecurityException(securityException);
        }
    }

    private Class<? extends Throwable> loadException(String className) {
        try {
            Class<?> exception = Class.forName(className);
            return exception;
        }
        catch (ClassNotFoundException e) {
            LOG.info("Exception {} was not found on classpath and can not be handled by this {}.", (Object)className, (Object)this.getClass().getSimpleName());
        }
        catch (Exception e) {
            LOG.error("Exception {} is invalid and can not be handled by this {}.", new Object[]{className, this.getClass().getSimpleName(), e});
        }
        return null;
    }

    public Response toResponse(Throwable exception) {
        if (exception instanceof WebApplicationException) {
            return this.createResponse((WebApplicationException)exception);
        }
        if (exception instanceof NlsRuntimeException) {
            return this.toResponse(exception, exception);
        }
        Throwable error = exception;
        Throwable catched = exception;
        error = this.getRollbackCause(exception);
        if (error == null) {
            error = this.unwrapNlsUserError(exception);
        }
        if (error == null) {
            error = exception;
        }
        return this.toResponse(error, catched);
    }

    private NlsRuntimeException unwrapNlsUserError(Throwable exception) {
        NlsRuntimeException nlsError;
        Throwable cause = exception.getCause();
        if (cause instanceof NlsRuntimeException && (nlsError = (NlsRuntimeException)cause).isForUser()) {
            return nlsError;
        }
        return null;
    }

    private Throwable getRollbackCause(Throwable exception) {
        Throwable cause;
        Class<?> exceptionClass = exception.getClass();
        if (exceptionClass == this.transactionSystemException && (cause = exception.getCause()) != null && (exceptionClass = cause.getClass()) == this.rollbackException) {
            return cause.getCause();
        }
        return null;
    }

    protected Response toResponse(Throwable exception, Throwable catched) {
        if (exception instanceof ValidationException) {
            return this.handleValidationException(exception, catched);
        }
        if (exception instanceof ValidationErrorUserException) {
            return this.createResponse(exception, (ValidationErrorUserException)exception, null);
        }
        Class<?> exceptionClass = exception.getClass();
        for (Class<? extends Throwable> securityError : this.securityExceptions) {
            if (!securityError.isAssignableFrom(exceptionClass)) continue;
            return this.handleSecurityError(exception, catched);
        }
        return this.handleGenericError(exception, catched);
    }

    protected Response createResponse(Throwable exception, ValidationErrorUserException error, Map<String, List<String>> errorsMap) {
        LOG.warn("Service failed due to validation failure.", (Throwable)error);
        if (exception == error) {
            return this.createResponse(Response.Status.BAD_REQUEST, (NlsRuntimeException)error, errorsMap);
        }
        return this.createResponse(Response.Status.BAD_REQUEST, (NlsRuntimeException)error, exception.getMessage(), errorsMap);
    }

    protected Response handleGenericError(Throwable exception, Throwable catched) {
        NlsRuntimeException userError;
        boolean logged = false;
        if (exception instanceof NlsThrowable) {
            NlsThrowable nlsError = (NlsThrowable)exception;
            if (!nlsError.isTechnical()) {
                LOG.warn("Service failed due to business error: {}", (Object)nlsError.getMessage());
                logged = true;
            }
            userError = TechnicalErrorUserException.getOrCreateUserException((Throwable)exception);
        } else {
            userError = TechnicalErrorUserException.getOrCreateUserException((Throwable)catched);
        }
        if (!logged) {
            LOG.error("Service failed on server", (Throwable)userError);
        }
        return this.createResponse(userError);
    }

    protected Response handleSecurityError(Throwable exception, Throwable catched) {
        Object error = exception == catched && exception instanceof NlsRuntimeException ? (NlsRuntimeException)exception : new SecurityErrorUserException(catched);
        LOG.warn("Service failed due to security error", (Throwable)error);
        String code = null;
        String message = this.exposeInternalErrorDetails ? this.getExposedErrorDetails((Throwable)error) : "forbidden";
        return this.createResponse(Response.Status.FORBIDDEN, message, code, error.getUuid(), null);
    }

    protected Response handleValidationException(Throwable exception, Throwable catched) {
        Throwable t = catched;
        HashMap<String, List<String>> errorsMap = null;
        if (exception instanceof ConstraintViolationException) {
            ConstraintViolationException constraintViolationException = (ConstraintViolationException)exception;
            Set violations = constraintViolationException.getConstraintViolations();
            errorsMap = new HashMap<String, List<String>>();
            for (ConstraintViolation violation : violations) {
                Iterator it = violation.getPropertyPath().iterator();
                String fieldName = null;
                while (it.hasNext()) {
                    fieldName = ((Path.Node)it.next()).toString();
                }
                ArrayList<String> errorsList = (ArrayList<String>)errorsMap.get(fieldName);
                if (errorsList == null) {
                    errorsList = new ArrayList<String>();
                    errorsMap.put(fieldName, errorsList);
                }
                errorsList.add(violation.getMessage());
            }
            t = new ValidationException(((Object)errorsMap).toString(), catched);
        }
        ValidationErrorUserException error = new ValidationErrorUserException(t);
        return this.createResponse(t, error, errorsMap);
    }

    protected String getExposedErrorDetails(Throwable error) {
        StringBuilder buffer = new StringBuilder();
        for (Throwable e = error; e != null; e = e.getCause()) {
            if (buffer.length() > 0) {
                buffer.append(System.lineSeparator());
            }
            buffer.append(e.getClass().getSimpleName());
            buffer.append(": ");
            buffer.append(e.getLocalizedMessage());
        }
        return buffer.toString();
    }

    protected Response createResponse(NlsRuntimeException error) {
        Response.Status status = error.isTechnical() ? Response.Status.INTERNAL_SERVER_ERROR : Response.Status.BAD_REQUEST;
        return this.createResponse(status, error, null);
    }

    protected Response createResponse(Response.Status status, NlsRuntimeException error, Map<String, List<String>> errorsMap) {
        String message = this.exposeInternalErrorDetails ? this.getExposedErrorDetails((Throwable)error) : error.getLocalizedMessage();
        return this.createResponse(status, error, message, errorsMap);
    }

    protected Response createResponse(Response.Status status, NlsRuntimeException error, String message, Map<String, List<String>> errorsMap) {
        return this.createResponse(status, error, message, error.getCode(), errorsMap);
    }

    protected Response createResponse(Response.Status status, NlsRuntimeException error, String message, String code, Map<String, List<String>> errorsMap) {
        return this.createResponse(status, message, code, error.getUuid(), errorsMap);
    }

    protected Response createResponse(Response.Status status, String message, String code, UUID uuid, Map<String, List<String>> errorsMap) {
        String json = this.createJsonErrorResponseMessage(message, code, uuid, errorsMap);
        return Response.status((Response.Status)status).entity((Object)json).build();
    }

    protected String createJsonErrorResponseMessage(String message, String code, UUID uuid, Map<String, List<String>> errorsMap) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        if (message != null) {
            jsonMap.put("message", message);
        }
        if (code != null) {
            jsonMap.put("code", code);
        }
        if (uuid != null) {
            jsonMap.put("uuid", uuid.toString());
        }
        if (errorsMap != null) {
            jsonMap.put("errors", errorsMap);
        }
        String responseMessage = "";
        try {
            responseMessage = this.mapper.writeValueAsString(jsonMap);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception facade failed to create JSON.", (Throwable)e);
            responseMessage = "{}";
        }
        return responseMessage;
    }

    protected Response createResponse(WebApplicationException exception) {
        Response response = exception.getResponse();
        int statusCode = response.getStatus();
        Response.Status status = Response.Status.fromStatusCode((int)statusCode);
        if (exception instanceof ServerErrorException) {
            TechnicalErrorUserException error = new TechnicalErrorUserException((Throwable)exception);
            LOG.error("Service failed on server", (Throwable)error);
            return this.createResponse(status, (NlsRuntimeException)error, null);
        }
        UUID uuid = UUID.randomUUID();
        if (exception instanceof ClientErrorException) {
            LOG.warn("Service failed due to unexpected request. UUDI: {}, reason: {} ", (Object)uuid, (Object)exception.getMessage());
        } else {
            LOG.warn("Service caused redirect or other error. UUID: {}, reason: {}", (Object)uuid, (Object)exception.getMessage());
        }
        return this.createResponse(status, exception.getMessage(), String.valueOf(statusCode), uuid, null);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Inject
    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void setExposeInternalErrorDetails(boolean exposeInternalErrorDetails) {
        this.exposeInternalErrorDetails = exposeInternalErrorDetails;
        if (exposeInternalErrorDetails) {
            String message = "****** Exposing of internal error details is enabled! This violates OWASP A6 (Sensitive Data Exposure) and shall only be used for testing/debugging and never in production. ******";
            LOG.warn(message);
            System.err.println(message);
        }
    }

    public boolean isExposeInternalErrorDetails() {
        return this.exposeInternalErrorDetails;
    }
}

