/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseCoreConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipsePluginConfig;
import com.diffplug.spotless.extra.eclipse.wtp.EclipseCssFormatterStepImpl;
import com.diffplug.spotless.extra.eclipse.wtp.EclipseJsFormatterStepImpl;
import com.diffplug.spotless.extra.eclipse.wtp.EclipseXmlFormatterStepImpl;
import com.diffplug.spotless.extra.eclipse.wtp.html.JsRegionProcessor;
import com.diffplug.spotless.extra.eclipse.wtp.html.StructuredDocumentProcessor;
import com.diffplug.spotless.extra.eclipse.wtp.sse.CleanupStep;
import com.diffplug.spotless.extra.eclipse.wtp.sse.PluginPreferences;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.cleanup.HTMLCleanupProcessorImpl;
import org.eclipse.wst.html.core.internal.encoding.HTMLDocumentLoader;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.html.core.internal.preferences.HTMLCorePreferenceInitializer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.sse.core.internal.cleanup.AbstractStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.osgi.framework.BundleActivator;

public class EclipseHtmlFormatterStepImpl
extends CleanupStep {
    private final String htmlFormatterIndent;
    private final CodeFormatter jsFormatter;

    public EclipseHtmlFormatterStepImpl(Properties properties) throws Exception {
        super(new CleanupProcessor(), new FrameworkConfig(properties));
        PluginPreferences.assertNoChanges(HTMLCorePlugin.getDefault(), properties);
        this.htmlFormatterIndent = ((CleanupProcessor)this.processorAccessor).getIndent();
        this.jsFormatter = ToolFactory.createCodeFormatter(JavaScriptCore.getOptions(), 1);
    }

    @Override
    public String format(String raw) throws Exception {
        raw = super.format(raw);
        IStructuredDocument document = (IStructuredDocument)new HTMLDocumentLoader().createNewStructuredDocument();
        document.setPreferredLineDelimiter("\n");
        document.set(raw);
        StructuredDocumentProcessor<CodeFormatter> jsProcessor = new StructuredDocumentProcessor<CodeFormatter>(document, "org.eclipse.wst.html.SCRIPT", JsRegionProcessor.createFactory(this.htmlFormatterIndent));
        jsProcessor.apply(this.jsFormatter);
        return document.get();
    }

    private static class FrameworkConfig
    extends CleanupStep.FrameworkConfig {
        private final List<SpotlessEclipseConfig> dependentConfigs;
        private final Properties properties;

        public FrameworkConfig(Properties properties) {
            this.dependentConfigs = Arrays.asList(new EclipseCssFormatterStepImpl.FrameworkConfig(properties), new EclipseJsFormatterStepImpl.FrameworkConfig(properties), new EclipseXmlFormatterStepImpl.FrameworkConfig(properties));
            this.properties = properties;
        }

        public void registerBundles(SpotlessEclipseCoreConfig config) {
            EclipseJsFormatterStepImpl.FrameworkConfig.registerNonHeadlessBundles(config);
        }

        @Override
        public void activatePlugins(SpotlessEclipsePluginConfig config) {
            super.activatePlugins(config);
            EclipseCssFormatterStepImpl.FrameworkConfig.activateCssPlugins(config);
            EclipseJsFormatterStepImpl.FrameworkConfig.activateJsPlugins(config);
            boolean allowExternalURI = false;
            EclipseXmlFormatterStepImpl.FrameworkConfig.activateXmlPlugins(config, allowExternalURI);
            config.add((BundleActivator)new HTMLCorePlugin());
        }

        public void customize() {
            this.dependentConfigs.stream().forEach(c -> c.customize());
            PluginPreferences.configure(HTMLCorePlugin.getDefault(), new HTMLCorePreferenceInitializer(), this.properties);
        }
    }

    private static class CleanupProcessor
    extends HTMLCleanupProcessorImpl
    implements CleanupStep.ProcessorAccessor {
        private HTMLFormatProcessorImpl processor = new HTMLFormatProcessorImpl();

        CleanupProcessor() {
        }

        @Override
        public String getTypeId() {
            return this.getContentType();
        }

        @Override
        public void refreshPreferences() {
            this.refreshCleanupPreferences();
            this.processor = new HTMLFormatProcessorImpl();
            this.processor.refreshFormatPreferences = false;
        }

        @Override
        public AbstractStructuredCleanupProcessor get() {
            return this;
        }

        @Override
        protected IStructuredFormatProcessor getFormatProcessor() {
            return this.processor;
        }

        String getIndent() {
            return this.processor.getFormatPreferences().getIndent();
        }
    }
}

