/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class StructuredDocumentProcessor<T> {
    private final String type;
    private final BiFunction<IStructuredDocument, ITypedRegion, ? extends RegionProcessor<T>> factory;
    private final IStructuredDocument document;
    private final int numberOfRegions;

    public StructuredDocumentProcessor(IStructuredDocument document, String type, BiFunction<IStructuredDocument, ITypedRegion, ? extends RegionProcessor<T>> factory) {
        this.type = type;
        this.factory = factory;
        this.document = document;
        this.numberOfRegions = this.getRegions().size();
    }

    public void apply(T formatter) {
        for (int currentRegionId = 0; currentRegionId < this.numberOfRegions; ++currentRegionId) {
            this.applyOnRegion(currentRegionId, formatter);
        }
    }

    private List<ITypedRegion> getRegions() {
        try {
            return Arrays.asList(this.document.computePartitioning(0, this.document.getLength())).stream().filter(reg -> this.type == reg.getType()).collect(Collectors.toList());
        }
        catch (BadLocationException e) {
            return new ArrayList<ITypedRegion>(0);
        }
    }

    private void applyOnRegion(int number, T formatter) {
        RegionProcessor<T> adapter = this.getRegionProcessor(number);
        try {
            adapter.applyFirst(formatter);
            adapter = this.getRegionProcessor(number);
            adapter.applySecond(formatter);
        }
        catch (BadLocationException | MalformedTreeException e) {
            throw new IllegalArgumentException(String.format("%s formatting failed between lines %d and %d. Most likely the syntax is not recognized.", this.type, adapter.getFirstLine(), adapter.getLastLine()), e);
        }
    }

    private RegionProcessor<T> getRegionProcessor(int number) {
        List<ITypedRegion> regions = this.getRegions();
        if (this.numberOfRegions != regions.size()) {
            throw new IllegalArgumentException(String.format("During first '%s' formatting step, the number of detected regions changed from '%d' to '%d'", this.type, this.numberOfRegions, regions.size()));
        }
        ITypedRegion region = regions.get(number);
        return this.factory.apply(this.document, region);
    }

    public static abstract class RegionProcessor<T> {
        protected final IStructuredDocument document;
        protected final ITypedRegion region;
        protected final int indentationLevel;
        protected final int firstLine;
        protected final int lastLine;

        protected RegionProcessor(IStructuredDocument document, ITypedRegion region, String htmlIndent) {
            this.document = document;
            this.region = region;
            this.indentationLevel = RegionProcessor.computeIndent(document, region, htmlIndent);
            this.firstLine = document.getLineOfOffset(region.getOffset());
            this.lastLine = document.getLineOfOffset(region.getOffset() + region.getLength());
        }

        public int getFirstLine() {
            return this.firstLine;
        }

        public int getLastLine() {
            return this.lastLine;
        }

        private static int computeIndent(IStructuredDocument document, ITypedRegion region, String htmlIndent) {
            int indent = 0;
            try {
                int lineNumber = document.getLineOfOffset(region.getOffset());
                document.getNumberOfLines();
                int lineOffset = document.getLineOffset(lineNumber);
                String lineStart = document.get(lineOffset, region.getOffset() - lineOffset);
                while (lineStart.length() > htmlIndent.length() && lineStart.startsWith(htmlIndent)) {
                    ++indent;
                    lineStart = lineStart.substring(htmlIndent.length());
                }
            }
            catch (BadLocationException e) {
                indent = 0;
            }
            return indent;
        }

        protected int fixDelimiter(MultiTextEdit modifications, int offset, boolean addAfter) throws BadLocationException {
            int delimiterLength = "\n".length();
            String delimiter = this.document.get(offset, delimiterLength);
            if (!"\n".equals(delimiter)) {
                if (addAfter) {
                    ++offset;
                }
                modifications.addChild((TextEdit)new InsertEdit(offset, "\n"));
                return "\n".length();
            }
            return 0;
        }

        protected void fixTagIndent(MultiTextEdit modifications, int offset, String indentString) throws BadLocationException {
            int lineNumber = this.document.getLineOfOffset(offset);
            if (lineNumber >= this.document.getNumberOfLines()) {
                return;
            }
            int lineStart = this.document.getLineOffset(lineNumber);
            int lineEnd = this.document.getLineOffset(lineNumber + 1);
            String lineContent = this.document.get(lineStart, lineEnd - lineStart);
            StringBuilder currentIndent = new StringBuilder();
            lineContent.chars().filter(c -> {
                if (c == 32 || c == 9) {
                    currentIndent.append(c);
                    return false;
                }
                return true;
            }).findFirst();
            if (!indentString.equals(currentIndent.toString())) {
                ReplaceEdit replaceIndent = new ReplaceEdit(lineStart, currentIndent.length(), indentString);
                replaceIndent.apply((IDocument)this.document);
            }
        }

        protected abstract void applyFirst(T var1) throws MalformedTreeException, BadLocationException;

        protected abstract void applySecond(T var1) throws MalformedTreeException, BadLocationException;
    }
}

