/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.encoding;

import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.css.core.internal.contenttype.CSSResourceEncodingDetector;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.document.IDocumentCharsetDetector;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class CSSDocumentCharsetDetector
extends CSSResourceEncodingDetector
implements IDocumentCharsetDetector {
    public String getEncodingName(IStructuredDocument structuredDocument) {
        String result = null;
        IStructuredDocumentRegionList nodes = structuredDocument.getRegionList();
        if (nodes.getLength() > 0) {
            ITextRegionCollection node = null;
            int i = 0;
            while (i < nodes.getLength()) {
                node = nodes.item(i);
                if (this.getType((IStructuredDocumentRegion)node) != "S") break;
                ++i;
            }
            Iterator<ITextRegion> regions = node.getRegions().iterator();
            ITextRegion region = this.getNextRegionOfType("CHARSET", regions);
            if (region != null) {
                ITextRegion valueRegion = this.getNextRegionOfType("STRING", regions);
                if (valueRegion == null) {
                    regions = node.getRegions().iterator();
                    region = this.getNextRegionOfType("CHARSET", regions);
                    if (region != null && (valueRegion = this.getNextRegionOfType("UNKNOWN", regions)) != null) {
                        result = node.getText(valueRegion);
                    }
                } else {
                    result = node.getText(valueRegion);
                }
                result = StringUtils.stripNonLetterDigits(result);
            }
        }
        return result;
    }

    public String getEncodingName(IDocument document) {
        String enc = null;
        if (document instanceof IStructuredDocument) {
            enc = this.getEncodingName((IStructuredDocument)document);
        }
        return enc;
    }

    private String getType(IStructuredDocumentRegion node) {
        if (node == null) {
            return null;
        }
        ITextRegionList regions = node.getRegions();
        if (regions == null || regions.size() == 0) {
            return null;
        }
        ITextRegion region = regions.get(0);
        String result = region.getType();
        return result;
    }

    private ITextRegion getNextRegionOfType(String type, Iterator regions) {
        if (type == null) {
            return null;
        }
        if (regions == null) {
            return null;
        }
        ITextRegion result = null;
        while (regions.hasNext()) {
            ITextRegion region = (ITextRegion)regions.next();
            if (region.getType() != type) continue;
            result = region;
            break;
        }
        return result;
    }

    @Override
    public void set(IDocument document) {
        this.set(new DocumentReader(document, 0));
    }
}

