/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.wst.css.core.internal.formatter.AttrFormatter;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceGenerator;
import org.eclipse.wst.css.core.internal.formatter.CharsetRuleFormatter;
import org.eclipse.wst.css.core.internal.formatter.CounterFormatter;
import org.eclipse.wst.css.core.internal.formatter.FontFaceRuleFormatter;
import org.eclipse.wst.css.core.internal.formatter.ImportRuleFormatter;
import org.eclipse.wst.css.core.internal.formatter.MediaListFormatter;
import org.eclipse.wst.css.core.internal.formatter.MediaRuleFormatter;
import org.eclipse.wst.css.core.internal.formatter.PageRuleFormatter;
import org.eclipse.wst.css.core.internal.formatter.PrimitiveValueFormatter;
import org.eclipse.wst.css.core.internal.formatter.RGBFormatter;
import org.eclipse.wst.css.core.internal.formatter.RectFormatter;
import org.eclipse.wst.css.core.internal.formatter.StyleDeclItemFormatter;
import org.eclipse.wst.css.core.internal.formatter.StyleDeclarationFormatter;
import org.eclipse.wst.css.core.internal.formatter.StyleRuleFormatter;
import org.eclipse.wst.css.core.internal.formatter.StyleSheetFormatter;
import org.eclipse.wst.css.core.internal.formatter.UnknownRuleFormatter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;

public class CSSSourceFormatterFactory {
    private static CSSSourceFormatterFactory fInstance;

    private CSSSourceFormatterFactory() {
    }

    public CSSSourceGenerator getSourceFormatter(INodeNotifier target) {
        ICSSNode node = (ICSSNode)((Object)target);
        short type = node.getNodeType();
        switch (type) {
            case 2: {
                return CharsetRuleFormatter.getInstance();
            }
            case 5: {
                return FontFaceRuleFormatter.getInstance();
            }
            case 3: {
                return ImportRuleFormatter.getInstance();
            }
            case 12: {
                return MediaListFormatter.getInstance();
            }
            case 4: {
                return MediaRuleFormatter.getInstance();
            }
            case 11: {
                ICSSPrimitiveValue value = (ICSSPrimitiveValue)node;
                if (value.getPrimitiveType() == 23) {
                    return CounterFormatter.getInstance();
                }
                if (value.getPrimitiveType() == 24) {
                    return RectFormatter.getInstance();
                }
                if (value.getPrimitiveType() == 25) {
                    return RGBFormatter.getInstance();
                }
                return PrimitiveValueFormatter.getInstance();
            }
            case 6: {
                return PageRuleFormatter.getInstance();
            }
            case 8: {
                return StyleDeclarationFormatter.getInstance();
            }
            case 9: {
                return StyleDeclItemFormatter.getInstance();
            }
            case 1: {
                return StyleRuleFormatter.getInstance();
            }
            case 7: {
                return StyleSheetFormatter.getInstance();
            }
            case -1: {
                return AttrFormatter.getInstance();
            }
        }
        return UnknownRuleFormatter.getInstance();
    }

    public static synchronized CSSSourceFormatterFactory getInstance() {
        if (fInstance == null) {
            fInstance = new CSSSourceFormatterFactory();
        }
        return fInstance;
    }
}

