/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.CMGroupNode;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public abstract class CMNode
extends DTDNode {
    public static final String ANY = DTDCoreMessages._UI_LABEL_CM_NODE_ANY;
    public static final String CHILDREN = DTDCoreMessages._UI_LABEL_CM_NODE_CHILD_CONTENT;
    public static final String EMPTY = DTDCoreMessages._UI_LABEL_CM_NODE_EMPTY;
    public static final String MIXED = DTDCoreMessages._UI_LABEL_CM_NODE_MIX_CONTENT;
    public static final String PCDATA = DTDCoreMessages._UI_LABEL_CM_NODE_PCDATA;
    boolean rootElementContent;

    public CMNode(DTDFile file, IStructuredDocumentRegion flatNode) {
        super(file, flatNode);
    }

    public abstract String getType();

    public boolean isRootElementContent() {
        return this.rootElementContent;
    }

    public void setChildrenContent(String newChild) {
        if (this.isRootElementContent()) {
            if (!newChild.equals("")) {
                this.beginRecording(this, DTDCoreMessages._UI_LABEL_CM_NODE_SET_CHILD_CONTENT);
                this.replaceText(this, this.getStartOffset(), this.getNodeLength(), "(" + newChild + ")");
                this.endRecording(this);
                return;
            }
            if (!this.getType().equals(CHILDREN)) {
                this.beginRecording(this, DTDCoreMessages._UI_LABEL_CM_NODE_SET_CHILD_CONTENT);
                if (this instanceof CMBasicNode) {
                    this.replaceText(this, this.getStartOffset(), this.getNodeLength(), "(newChild)");
                } else {
                    CMGroupNode group = (CMGroupNode)this;
                    CMNode firstChild = (CMNode)group.getFirstChild();
                    if (firstChild != null && PCDATA.equals(firstChild.getType())) {
                        group.delete(firstChild);
                    }
                }
                this.endRecording(this);
            }
        }
    }

    public void setContent(String content) {
        if (this.isRootElementContent()) {
            this.beginRecording(this, String.valueOf(DTDCoreMessages._UI_LABEL_CM_NODE_SET) + " " + content + " " + DTDCoreMessages._UI_LABEL_CM_NODE_CONTENT);
            this.replaceText(this, this.getStartOffset(), this.getNodeLength(), content);
            this.endRecording(this);
        }
    }

    public void setMixedContent() {
        if (this.isRootElementContent() && !this.getType().equals(MIXED)) {
            this.beginRecording(this, DTDCoreMessages._UI_LABEL_CM_NODE_SET_MIX_CONTENT);
            if (this instanceof CMBasicNode) {
                this.replaceText(this, this.getStartOffset(), this.getNodeLength(), "(#PCDATA | newChild)*");
            } else {
                CMGroupNode group = (CMGroupNode)this;
                group.setConnector('|');
                group.setOccurrence('*');
                CMNode firstChild = (CMNode)group.getFirstChild();
                if (!firstChild.getType().equals(PCDATA)) {
                    group.insertChildNode("#PCDATA", 0);
                }
            }
            this.endRecording(this);
        }
    }

    public void setRootElementContent(boolean v) {
        this.rootElementContent = v;
    }
}

