/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import java.util.List;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.core.internal.NamedTopLevelNode;
import org.eclipse.wst.dtd.core.internal.text.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class ParameterEntityReference
extends NamedTopLevelNode {
    private Entity cachedEntity = null;

    public ParameterEntityReference(DTDFile file, IStructuredDocumentRegion flatNode) {
        super(file, flatNode, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.COMMENT");
    }

    public Entity getEntityObject() {
        if (this.cachedEntity != null && !this.cachedEntity.getName().equals(this.getReferencedEntity())) {
            this.cachedEntity = null;
        }
        if (this.cachedEntity == null) {
            List nodes = this.getDTDFile().getNodes();
            int i = 0;
            while (i < nodes.size()) {
                Entity entity;
                DTDNode node = (DTDNode)nodes.get(i);
                if (node instanceof Entity && (entity = (Entity)node).isParameterEntity() && entity.getName().equals(this.getReferencedEntity())) {
                    this.cachedEntity = entity;
                }
                ++i;
            }
        }
        return this.cachedEntity;
    }

    @Override
    public String getImagePath() {
        return "icons/full/obj16/entity_reference.gif";
    }

    @Override
    public String getName() {
        return this.getStructuredDTDDocumentRegion().getText();
    }

    public String getReferencedEntity() {
        String text = this.getName();
        return this.getName().substring(1, text.length() - 1);
    }

    private void getStartAndEndOffsetForText(StartEndPair pair) {
        RegionIterator iter = this.iterator();
        ITextRegion commentStartTag = this.getStartTag(iter);
        ITextRegion endCommentTag = this.getNextRegion(iter, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.COMMENT_END");
        pair.endOffset = this.getStructuredDTDDocumentRegion().getEndOffset();
        if (commentStartTag != null) {
            pair.startOffset = this.getStructuredDTDDocumentRegion().getEndOffset(commentStartTag);
        }
        if (endCommentTag != null) {
            pair.endOffset = this.getStructuredDTDDocumentRegion().getEndOffset(endCommentTag);
        }
    }

    public String getText() {
        String text = this.getStructuredDTDDocumentRegion().getText();
        int flatNodeStart = this.getStructuredDTDDocumentRegion().getStartOffset();
        StartEndPair pair = new StartEndPair();
        this.getStartAndEndOffsetForText(pair);
        return text.substring(pair.startOffset - flatNodeStart, pair.endOffset - flatNodeStart);
    }

    public void setReferencedEntity(Object requestor, String name) {
        this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getStartOffset(), this.getStructuredDTDDocumentRegion().getLength(), "%" + name + ";");
    }

    public void setReferencedEntity(String name) {
        this.beginRecording(this, DTDCoreMessages._UI_LABEL_PARM_ENTITY_REF_CHG_ENTITY_REF);
        this.setReferencedEntity(this, name);
        this.endRecording(this);
    }

    public void setText(String newText) {
        this.beginRecording(this, DTDCoreMessages._UI_LABEL_PARM_ENTITY_REF_COMMENT_CHG);
        StartEndPair pair = new StartEndPair();
        this.getStartAndEndOffsetForText(pair);
        this.replaceText(this, pair.startOffset, pair.endOffset - pair.startOffset, newText);
        this.endRecording(this);
    }

    public class StartEndPair {
        public int startOffset;
        public int endOffset;
    }
}

