/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.document;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class HTMLDocumentTypeAdapterFactory
implements INodeAdapterFactory {
    private static HTMLDocumentTypeAdapterFactory factory;
    private static final CasePreferenceListener listener;

    static {
        listener = new CasePreferenceListener();
    }

    public static synchronized HTMLDocumentTypeAdapterFactory getInstance() {
        if (factory == null) {
            factory = new HTMLDocumentTypeAdapterFactory();
        }
        return factory;
    }

    @Override
    public INodeAdapter adapt(INodeNotifier notifier) {
        DocumentTypeAdapter result = null;
        if (notifier instanceof IDOMDocument) {
            DocumentTypeAdapter oldAdapter = (DocumentTypeAdapter)notifier.getExistingAdapter(DocumentTypeAdapter.class);
            if (oldAdapter != null) {
                result = oldAdapter;
            } else {
                result = new HTMLDocumentTypeAdapter((IDOMDocument)notifier, this);
                notifier.addAdapter(result);
            }
        }
        return result;
    }

    public int getAttrNameCase() {
        return listener.getAttrNameCase();
    }

    public int getTagNameCase() {
        return listener.getTagNameCase();
    }

    @Override
    public boolean isFactoryForType(Object type) {
        return type == DocumentTypeAdapter.class;
    }

    @Override
    public void release() {
    }

    @Override
    public INodeAdapterFactory copy() {
        return HTMLDocumentTypeAdapterFactory.getInstance();
    }

    private static class CasePreferenceListener
    implements Preferences.IPropertyChangeListener {
        private Preferences preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
        private int tagNameCase = 2;
        private int attrNameCase = 2;

        CasePreferenceListener() {
            if (this.preferences != null) {
                this.updateCases();
                this.preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
            }
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event == null) {
                return;
            }
            String property = event.getProperty();
            if (property == null) {
                return;
            }
            if (property.equals("tagNameCase") || property.equals("attrNameCase")) {
                this.updateCases();
            }
        }

        public int getTagNameCase() {
            return this.tagNameCase;
        }

        public int getAttrNameCase() {
            return this.attrNameCase;
        }

        private void updateCases() {
            this.tagNameCase = 2;
            this.attrNameCase = 2;
            if (this.preferences == null) {
                return;
            }
            this.tagNameCase = this.getCase("tagNameCase");
            this.attrNameCase = this.getCase("attrNameCase");
        }

        private int getCase(String property) {
            int result = 2;
            if (this.preferences != null && this.preferences.getInt(property) == 2) {
                result = 1;
            }
            return result;
        }
    }
}

