/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.modelquery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class HMQUtil {
    private static final List<CMContent> nullVector = new ArrayList<CMContent>();

    private HMQUtil() {
    }

    public static Collection<CMContent> getInclusions(Element target) {
        if (target == null) {
            return nullVector;
        }
        Collection<CMContent> inclusions = HMQUtil.gatherInclusions(HMQUtil.getAncestorDeclarations(target));
        HashMap<String, CMContent> availables = new HashMap<String, CMContent>();
        for (CMContent inclusion : inclusions) {
            switch (inclusion.getNodeType()) {
                case 7: {
                    HMQUtil.extractDeclarations(availables, (CMGroup)inclusion);
                    break;
                }
                case 5: {
                    HMQUtil.addInclusion(availables, (CMElementDeclaration)inclusion);
                }
            }
        }
        return availables.values();
    }

    private static Collection<CMContent> getAncestorDeclarations(Element target) {
        ArrayList<CMContent> ancestors = new ArrayList<CMContent>();
        Document doc = target.getOwnerDocument();
        ModelQuery query = ModelQueryUtil.getModelQuery(doc);
        CMElementDeclaration decl = query.getCMElementDeclaration(target);
        ancestors.add(decl);
        Element parent = HMQUtil.getParent(target);
        while (parent != null) {
            decl = query.getCMElementDeclaration(parent);
            if (decl != null) {
                ancestors.add(decl);
            }
            parent = HMQUtil.getParent(parent);
        }
        return ancestors;
    }

    private static void addInclusion(Map<String, CMContent> availables, CMElementDeclaration decl) {
        String name = decl.getElementName();
        if (availables.containsKey(name)) {
            return;
        }
        availables.put(name, decl);
    }

    private static Collection<CMContent> gatherInclusions(Collection<CMContent> ancestors) {
        ArrayList<CMContent> inclusions = new ArrayList<CMContent>();
        for (CMElementDeclaration cMElementDeclaration : ancestors) {
            CMContent inclusion;
            if (!cMElementDeclaration.supports("inclusion") || (inclusion = (CMContent)cMElementDeclaration.getProperty("inclusion")) == null) continue;
            inclusions.add(inclusion);
        }
        return inclusions;
    }

    private static Element getParent(Node target) {
        Node parent = target.getParentNode();
        while (parent != null) {
            if (parent.getNodeType() == 1) {
                return (Element)parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    private static void extractDeclarations(Map<String, CMContent> availables, CMGroup group) {
        CMNodeList content = group.getChildNodes();
        int i = 0;
        while (i < content.getLength()) {
            CMNode cmn = content.item(i);
            if (cmn != null && cmn.getNodeType() == 5) {
                HMQUtil.addInclusion(availables, (CMElementDeclaration)cmn);
            }
            ++i;
        }
    }
}

