/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;

public class LocalVariableIndex
extends ASTVisitor {
    private int fTopIndex;

    public static int perform(BodyDeclaration declaration) {
        Assert.isTrue((declaration != null ? 1 : 0) != 0);
        switch (declaration.getNodeType()) {
            case 31: {
                return LocalVariableIndex.internalPerform((FunctionDeclaration)declaration);
            }
            case 28: {
                return LocalVariableIndex.internalPerform((Initializer)declaration);
            }
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    private static int internalPerform(FunctionDeclaration method) {
        FunctionDeclaration target = method;
        while (ASTNodes.getParent((ASTNode)target, 31) != null) {
            target = (FunctionDeclaration)ASTNodes.getParent((ASTNode)target, 31);
        }
        return LocalVariableIndex.doPerform(target);
    }

    private static int internalPerform(Initializer initializer) {
        return LocalVariableIndex.doPerform(initializer);
    }

    private static int doPerform(BodyDeclaration node) {
        LocalVariableIndex counter = new LocalVariableIndex();
        node.accept(counter);
        return counter.fTopIndex;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        this.handleVariableBinding(node.resolveBinding());
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        this.handleVariableBinding(node.resolveBinding());
        return true;
    }

    private void handleVariableBinding(IVariableBinding binding) {
        if (binding == null) {
            return;
        }
        this.fTopIndex = Math.max(this.fTopIndex, binding.getVariableId());
    }
}

