/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public class ConvertAnonymousToNestedRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_STATIC = "static";
    private static final String KEY_TYPE_NAME = "type_name";
    private static final String KEY_PARAM_NAME_EXT = "param_name_ext";
    private static final String KEY_PARAM_NAME_CONST = "param_name_const";
    private static final String KEY_FIELD_NAME_EXT = "field_name_ext";
    private int fSelectionStart;
    private int fSelectionLength;
    private IJavaScriptUnit fCu;
    private int fVisibility;
    private boolean fDeclareFinal = true;
    private boolean fDeclareStatic;
    private String fClassName = "";
    private JavaScriptUnit fCompilationUnitNode;
    private AnonymousClassDeclaration fAnonymousInnerClassNode;
    private Set fClassNamesUsed;
    private boolean fSelfInitializing = false;
    private LinkedProposalModel fLinkedProposalModel;

    public ConvertAnonymousToNestedRefactoring(IJavaScriptUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((unit == null || unit.exists() ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fAnonymousInnerClassNode = null;
        this.fCompilationUnitNode = null;
    }

    public ConvertAnonymousToNestedRefactoring(AnonymousClassDeclaration declaration) {
        Assert.isTrue((declaration != null ? 1 : 0) != 0);
        ASTNode astRoot = declaration.getRoot();
        Assert.isTrue((boolean)(astRoot instanceof JavaScriptUnit));
        this.fCompilationUnitNode = (JavaScriptUnit)astRoot;
        IJavaScriptElement javaElement = this.fCompilationUnitNode.getJavaElement();
        Assert.isTrue((boolean)(javaElement instanceof IJavaScriptUnit));
        this.fCu = (IJavaScriptUnit)javaElement;
        this.fSelectionStart = declaration.getStartPosition();
        this.fSelectionLength = declaration.getLength();
    }

    public void setLinkedProposalModel(LinkedProposalModel linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    public int[] getAvailableVisibilities() {
        if (this.isLocalInnerType()) {
            return new int[1];
        }
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public boolean isLocalInnerType() {
        return ASTNodes.getParent(ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class), 1) != null;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        Assert.isTrue((visibility == 2 || visibility == 0 || visibility == 4 || visibility == 1 ? 1 : 0) != 0);
        this.fVisibility = visibility;
    }

    public void setClassName(String className) {
        Assert.isNotNull((Object)className);
        this.fClassName = className;
    }

    public boolean canEnableSettingFinal() {
        return true;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public boolean getDeclareStatic() {
        return this.fDeclareStatic;
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setDeclareStatic(boolean declareStatic) {
        this.fDeclareStatic = declareStatic;
    }

    public String getName() {
        return RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name;
    }

    private boolean useThisForFieldAccess() {
        return StubUtility.useThisForFieldAccess(this.fCu.getJavaScriptProject());
    }

    private boolean doAddComments() {
        return StubUtility.doAddComments(this.fCu.getJavaScriptProject());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new IJavaScriptUnit[]{this.fCu}), this.getValidationContext());
        if (result.hasFatalError()) {
            return result;
        }
        this.initAST(pm);
        if (this.fAnonymousInnerClassNode == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_place_caret);
        }
        if (!this.fSelfInitializing) {
            this.initializeDefaults();
        }
        if (this.getSuperConstructorBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_compile_errors);
        }
        if (this.getSuperTypeBinding().isLocal()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_extends_local_class);
        }
        return new RefactoringStatus();
    }

    private void initializeDefaults() {
        this.fVisibility = this.isLocalInnerType() ? 0 : 2;
        this.fDeclareStatic = this.mustInnerClassBeStatic();
    }

    private void initAST(IProgressMonitor pm) {
        if (this.fCompilationUnitNode == null) {
            this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider(this.fCu, true, pm);
        }
        if (this.fAnonymousInnerClassNode == null) {
            this.fAnonymousInnerClassNode = ConvertAnonymousToNestedRefactoring.getAnonymousInnerClass(NodeFinder.perform(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength));
        }
        if (this.fAnonymousInnerClassNode != null) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class);
            if (declaration instanceof TypeDeclaration) {
                TypeDeclaration[] nested = ((TypeDeclaration)declaration).getTypes();
                this.fClassNamesUsed = new HashSet(nested.length);
                int index = 0;
                while (index < nested.length) {
                    this.fClassNamesUsed.add(nested[index].getName().getIdentifier());
                    ++index;
                }
            } else {
                this.fClassNamesUsed = Collections.EMPTY_SET;
            }
        }
    }

    private static AnonymousClassDeclaration getAnonymousInnerClass(ASTNode node) {
        AnonymousClassDeclaration anon;
        if (node == null) {
            return null;
        }
        if (node instanceof AnonymousClassDeclaration) {
            return (AnonymousClassDeclaration)node;
        }
        if (node instanceof ClassInstanceCreation && (anon = ((ClassInstanceCreation)node).getAnonymousClassDeclaration()) != null) {
            return anon;
        }
        if ((node = ASTNodes.getNormalizedNode(node)).getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY && (anon = ((ClassInstanceCreation)node.getParent()).getAnonymousClassDeclaration()) != null) {
            return anon;
        }
        return (AnonymousClassDeclaration)ASTNodes.getParent(node, AnonymousClassDeclaration.class);
    }

    public RefactoringStatus validateInput() {
        RefactoringStatus result = Checks.checkTypeName(this.fClassName);
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fClassNamesUsed.contains(this.fClassName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_type_exists);
        }
        IFunctionBinding superConstructorBinding = this.getSuperConstructorBinding();
        if (superConstructorBinding == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_compile_errors);
        }
        if (this.fClassName.equals(superConstructorBinding.getDeclaringClass().getName())) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_another_name);
        }
        if (this.classNameHidesEnclosingType()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name_hides);
        }
        return result;
    }

    private boolean accessesAnonymousFields() {
        List anonymousInnerFieldTypes = this.getAllEnclosingAnonymousTypesField();
        List accessedField = this.getAllAccessedFields();
        for (IVariableBinding variableBinding : anonymousInnerFieldTypes) {
            for (IVariableBinding variableBinding2 : accessedField) {
                if (!Bindings.equals(variableBinding, variableBinding2)) continue;
                return true;
            }
        }
        return false;
    }

    private List getAllAccessedFields() {
        final ArrayList accessedFields = new ArrayList();
        ASTVisitor visitor = new ASTVisitor(){

            @Override
            public boolean visit(FieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                if (binding != null) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            @Override
            public boolean visit(QualifiedName node) {
                IVariableBinding variable;
                IBinding binding = node.resolveBinding();
                if (binding != null && binding instanceof IVariableBinding && (variable = (IVariableBinding)binding).isField()) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            @Override
            public boolean visit(SimpleName node) {
                IVariableBinding variable;
                IBinding binding = node.resolveBinding();
                if (binding != null && binding instanceof IVariableBinding && (variable = (IVariableBinding)binding).isField()) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            @Override
            public boolean visit(SuperFieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                if (binding != null) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }
        };
        this.fAnonymousInnerClassNode.accept(visitor);
        return accessedFields;
    }

    private List getAllEnclosingAnonymousTypesField() {
        ArrayList<IVariableBinding> ans = new ArrayList<IVariableBinding>();
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class);
        AnonymousClassDeclaration anonymous = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, 1);
        while (anonymous != null) {
            if (!ASTNodes.isParent(anonymous, declaration)) break;
            ITypeBinding binding = anonymous.resolveBinding();
            if (binding != null) {
                ans.addAll(Arrays.asList(binding.getDeclaredFields()));
            }
            anonymous = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)anonymous, 1);
        }
        return ans;
    }

    private boolean classNameHidesEnclosingType() {
        ITypeBinding type = ((AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class)).resolveBinding();
        while (type != null) {
            if (this.fClassName.equals(type.getName())) {
                return true;
            }
            type = type.getDeclaringClass();
        }
        return false;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            RefactoringStatus status = this.validateInput();
            if (this.accessesAnonymousFields()) {
                status.merge(RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_anonymous_field_access));
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public CompilationUnitChange createCompilationUnitChange(IProgressMonitor pm) throws CoreException {
        CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.fCu, this.fCompilationUnitNode);
        this.addNestedClass(rewrite, null);
        this.modifyConstructorCall(rewrite, null);
        return rewrite.createChange(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name, false, pm);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        CompilationUnitChange result = this.createCompilationUnitChange(pm);
        result.setDescriptor((ChangeDescriptor)this.createRefactoringDescriptor());
        return result;
    }

    private RefactoringChangeDescriptor createRefactoringDescriptor() {
        ITypeBinding binding = this.fAnonymousInnerClassNode.resolveBinding();
        Object[] labels = new String[]{BindingLabelProvider.getBindingLabel(binding, 2235681801344L), BindingLabelProvider.getBindingLabel(binding.getDeclaringMethod(), 2235681801344L)};
        HashMap<String, String> arguments = new HashMap<String, String>();
        String projectName = this.fCu.getJavaScriptProject().getElementName();
        String description = RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_descriptor_description_short;
        String header = Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_descriptor_description, labels);
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(projectName, this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_original_pattern, BindingLabelProvider.getBindingLabel(binding, 2235681801344L)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_class_name_pattern, this.fClassName));
        String visibility = JdtFlags.getVisibilityString(this.fVisibility);
        if (visibility.length() == 0) {
            visibility = RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_default_visibility;
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_visibility_pattern, visibility));
        if (this.fDeclareFinal && this.fDeclareStatic) {
            comment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_final_static);
        } else if (this.fDeclareFinal) {
            comment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_final);
        } else if (this.fDeclareStatic) {
            comment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_static);
        }
        JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.convert.anonymous", projectName, description, comment.asString(), arguments, 786434);
        arguments.put("input", descriptor.elementToHandle(this.fCu));
        arguments.put("name", this.fClassName);
        arguments.put("selection", String.valueOf(Integer.valueOf(this.fSelectionStart).toString()) + ' ' + Integer.valueOf(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fDeclareFinal).toString());
        arguments.put(ATTRIBUTE_STATIC, Boolean.valueOf(this.fDeclareStatic).toString());
        arguments.put(ATTRIBUTE_VISIBILITY, Integer.valueOf(this.fVisibility).toString());
        return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
    }

    private void modifyConstructorCall(CompilationUnitRewrite rewrite, ITypeBinding[] parameters) {
        rewrite.getASTRewrite().replace(this.fAnonymousInnerClassNode.getParent(), this.createNewClassInstanceCreation(rewrite, parameters), null);
    }

    private ASTNode createNewClassInstanceCreation(CompilationUnitRewrite rewrite, ITypeBinding[] parameters) {
        AST ast = this.fAnonymousInnerClassNode.getAST();
        ClassInstanceCreation newClassCreation = ast.newClassInstanceCreation();
        newClassCreation.setAnonymousClassDeclaration(null);
        SimpleType type = null;
        SimpleName newNameNode = ast.newSimpleName(this.fClassName);
        if (parameters.length <= 0) {
            type = ast.newSimpleType(newNameNode);
        }
        newClassCreation.setType(type);
        this.copyArguments(rewrite, newClassCreation);
        this.addArgumentsForLocalsUsedInInnerClass(rewrite, newClassCreation);
        this.addLinkedPosition(KEY_TYPE_NAME, newNameNode, rewrite.getASTRewrite(), true);
        return newClassCreation;
    }

    private void addArgumentsForLocalsUsedInInnerClass(CompilationUnitRewrite rewrite, ClassInstanceCreation newClassCreation) {
        IVariableBinding[] usedLocals = this.getUsedLocalVariables();
        int i = 0;
        while (i < usedLocals.length) {
            AST ast = this.fAnonymousInnerClassNode.getAST();
            IVariableBinding binding = usedLocals[i];
            SimpleName name = ast.newSimpleName(binding.getName());
            newClassCreation.arguments().add(name);
            ++i;
        }
    }

    private void copyArguments(CompilationUnitRewrite rewrite, ClassInstanceCreation newClassCreation) {
        Iterator iter = ((ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent()).arguments().iterator();
        while (iter.hasNext()) {
            newClassCreation.arguments().add(rewrite.getASTRewrite().createCopyTarget((Expression)iter.next()));
        }
    }

    private void addNestedClass(CompilationUnitRewrite rewrite, ITypeBinding[] typeParameters) throws CoreException {
        AbstractTypeDeclaration declarations = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class);
        int index = ConvertAnonymousToNestedRefactoring.findIndexOfFistNestedClass(declarations.bodyDeclarations());
        if (index == -1) {
            index = 0;
        }
        rewrite.getASTRewrite().getListRewrite(declarations, declarations.getBodyDeclarationsProperty()).insertAt(this.createNewNestedClass(rewrite), index, null);
    }

    private static int findIndexOfFistNestedClass(List bodyDeclarations) {
        int i = 0;
        int n = bodyDeclarations.size();
        while (i < n) {
            BodyDeclaration each = (BodyDeclaration)bodyDeclarations.get(i);
            if (ConvertAnonymousToNestedRefactoring.isNestedType(each)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isNestedType(BodyDeclaration each) {
        if (!(each instanceof AbstractTypeDeclaration)) {
            return false;
        }
        return each.getParent() instanceof AbstractTypeDeclaration;
    }

    private AbstractTypeDeclaration createNewNestedClass(CompilationUnitRewrite rewrite) throws CoreException {
        String string;
        AST ast = this.fAnonymousInnerClassNode.getAST();
        TypeDeclaration newDeclaration = ast.newTypeDeclaration();
        newDeclaration.setJavadoc(null);
        newDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.createModifiersForNestedClass()));
        newDeclaration.setName(ast.newSimpleName(this.fClassName));
        this.setSuperType(newDeclaration);
        IJavaScriptProject project = this.fCu.getJavaScriptProject();
        IVariableBinding[] bindings = this.getUsedLocalVariables();
        ArrayList<String> fieldNames = new ArrayList<String>();
        int i = 0;
        while (i < bindings.length) {
            String name = StubUtility.removePrefixAndSuffixForVariable(project, bindings[i]);
            String[] fieldNameProposals = StubUtility.getVariableNameSuggestions(2, project, name, 0, fieldNames, true);
            fieldNames.add(fieldNameProposals[0]);
            if (this.fLinkedProposalModel != null) {
                LinkedProposalPositionGroup positionGroup = this.fLinkedProposalModel.getPositionGroup(KEY_FIELD_NAME_EXT + i, true);
                int k = 0;
                while (k < fieldNameProposals.length) {
                    positionGroup.addProposal(fieldNameProposals[k], null, fieldNameProposals.length - k);
                    ++k;
                }
            }
            ++i;
        }
        String[] allFieldNames = fieldNames.toArray(new String[fieldNames.size()]);
        List newBodyDeclarations = newDeclaration.bodyDeclarations();
        this.createFieldsForAccessedLocals(rewrite, bindings, allFieldNames, newBodyDeclarations);
        FunctionDeclaration newConstructorDecl = this.createNewConstructor(rewrite, bindings, allFieldNames);
        if (newConstructorDecl != null) {
            newBodyDeclarations.add(newConstructorDecl);
        }
        this.updateAndMoveBodyDeclarations(rewrite, bindings, allFieldNames, newBodyDeclarations, newConstructorDecl);
        if (this.doAddComments() && (string = CodeGeneration.getTypeComment(rewrite.getCu(), this.fClassName, StubUtility.getLineDelimiterUsed(this.fCu))) != null) {
            JSdoc javadoc = (JSdoc)rewrite.getASTRewrite().createStringPlaceholder(string, 29);
            newDeclaration.setJavadoc(javadoc);
        }
        if (this.fLinkedProposalModel != null) {
            this.addLinkedPosition(KEY_TYPE_NAME, newDeclaration.getName(), rewrite.getASTRewrite(), false);
            ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.fLinkedProposalModel, rewrite.getASTRewrite(), newDeclaration.modifiers(), false);
        }
        return newDeclaration;
    }

    private void updateAndMoveBodyDeclarations(CompilationUnitRewrite rewriter, IVariableBinding[] bindings, String[] fieldNames, List newBodyDeclarations, FunctionDeclaration newConstructorDecl) throws JavaScriptModelException {
        ASTRewrite astRewrite = rewriter.getASTRewrite();
        AST ast = astRewrite.getAST();
        boolean useThisAccess = this.useThisForFieldAccess();
        int fieldInsertIndex = newConstructorDecl != null ? newBodyDeclarations.lastIndexOf(newConstructorDecl) : newBodyDeclarations.size();
        for (BodyDeclaration body : this.fAnonymousInnerClassNode.bodyDeclarations()) {
            int i = 0;
            while (i < bindings.length) {
                SimpleName[] names = LinkedNodeFinder.findByBinding(body, bindings[i]);
                String fieldName = fieldNames[i];
                int k = 0;
                while (k < names.length) {
                    SimpleName newNode = ast.newSimpleName(fieldName);
                    if (useThisAccess) {
                        FieldAccess access = ast.newFieldAccess();
                        access.setExpression(ast.newThisExpression());
                        access.setName(newNode);
                        astRewrite.replace(names[k], access, null);
                    } else {
                        astRewrite.replace(names[k], newNode, null);
                    }
                    this.addLinkedPosition(KEY_FIELD_NAME_EXT + i, newNode, astRewrite, false);
                    ++k;
                }
                ++i;
            }
            if (body instanceof Initializer || body instanceof FieldDeclaration) {
                newBodyDeclarations.add(fieldInsertIndex++, astRewrite.createMoveTarget(body));
                continue;
            }
            newBodyDeclarations.add(astRewrite.createMoveTarget(body));
        }
        if (newConstructorDecl != null) {
            List bodyStatements = newConstructorDecl.getBody().statements();
            List fieldsToInitializeInConstructor = this.getFieldsToInitializeInConstructor();
            for (VariableDeclarationFragment fragment : fieldsToInitializeInConstructor) {
                Expression initializer = fragment.getInitializer();
                Expression replacement = (Expression)astRewrite.get(fragment, VariableDeclarationFragment.INITIALIZER_PROPERTY);
                if (replacement == initializer) {
                    replacement = (Expression)astRewrite.createMoveTarget(initializer);
                }
                astRewrite.remove(initializer, null);
                SimpleName fieldNameNode = ast.newSimpleName(fragment.getName().getIdentifier());
                bodyStatements.add(this.newFieldAssignment(ast, fieldNameNode, replacement, useThisAccess));
            }
        }
    }

    private void createFieldsForAccessedLocals(CompilationUnitRewrite rewrite, IVariableBinding[] varBindings, String[] fieldNames, List newBodyDeclarations) {
        ImportRewrite importRewrite = rewrite.getImportRewrite();
        ASTRewrite astRewrite = rewrite.getASTRewrite();
        AST ast = astRewrite.getAST();
        int i = 0;
        while (i < varBindings.length) {
            VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
            fragment.setExtraDimensions(0);
            fragment.setInitializer(null);
            fragment.setName(ast.newSimpleName(fieldNames[i]));
            FieldDeclaration field = ast.newFieldDeclaration(fragment);
            ITypeBinding varType = varBindings[i].getType();
            field.setType(importRewrite.addImport(varType, ast));
            field.modifiers().addAll(ASTNodeFactory.newModifiers(ast, 18));
            if (this.doAddComments()) {
                try {
                    String string = CodeGeneration.getFieldComment(rewrite.getCu(), varType.getName(), fieldNames[i], StubUtility.getLineDelimiterUsed(this.fCu));
                    if (string != null) {
                        JSdoc javadoc = (JSdoc)astRewrite.createStringPlaceholder(string, 29);
                        field.setJavadoc(javadoc);
                    }
                }
                catch (CoreException exception) {
                    JavaScriptPlugin.log(exception);
                }
            }
            newBodyDeclarations.add(field);
            this.addLinkedPosition(KEY_FIELD_NAME_EXT + i, fragment.getName(), astRewrite, false);
            ++i;
        }
    }

    private void addLinkedPosition(String key, ASTNode nodeToTrack, ASTRewrite rewrite, boolean isFirst) {
        if (this.fLinkedProposalModel != null) {
            this.fLinkedProposalModel.getPositionGroup(key, true).addPosition(rewrite.track(nodeToTrack), isFirst);
        }
    }

    private IVariableBinding[] getUsedLocalVariables() {
        HashSet result = new HashSet(0);
        this.collectRefrencedVariables(this.fAnonymousInnerClassNode, result);
        ArrayList<IVariableBinding> usedLocals = new ArrayList<IVariableBinding>();
        for (IVariableBinding next : result) {
            if (!this.isBindingToTemp(next)) continue;
            usedLocals.add(next);
        }
        return usedLocals.toArray(new IVariableBinding[usedLocals.size()]);
    }

    private void collectRefrencedVariables(ASTNode root, final Set result) {
        root.accept(new ASTVisitor(){

            @Override
            public boolean visit(SimpleName node) {
                IBinding binding = node.resolveBinding();
                if (binding instanceof IVariableBinding) {
                    result.add(binding);
                }
                return true;
            }
        });
    }

    private boolean isBindingToTemp(IVariableBinding variable) {
        if (variable.isField()) {
            return false;
        }
        if (!Modifier.isFinal(variable.getModifiers())) {
            return false;
        }
        ASTNode declaringNode = this.fCompilationUnitNode.findDeclaringNode(variable);
        if (declaringNode == null) {
            return false;
        }
        return !ASTNodes.isParent(declaringNode, this.fAnonymousInnerClassNode);
    }

    private FunctionDeclaration createNewConstructor(CompilationUnitRewrite rewrite, IVariableBinding[] bindings, String[] fieldNames) throws JavaScriptModelException {
        int k;
        LinkedProposalPositionGroup positionGroup;
        IFunctionBinding constructorBinding;
        ClassInstanceCreation instanceCreation = (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
        if (instanceCreation.arguments().isEmpty() && bindings.length == 0) {
            return null;
        }
        IJavaScriptProject project = this.fCu.getJavaScriptProject();
        AST ast = rewrite.getAST();
        ImportRewrite importRewrite = rewrite.getImportRewrite();
        ASTRewrite astRewrite = rewrite.getASTRewrite();
        FunctionDeclaration newConstructor = ast.newFunctionDeclaration();
        newConstructor.setConstructor(true);
        newConstructor.setExtraDimensions(0);
        newConstructor.setJavadoc(null);
        newConstructor.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.fVisibility));
        newConstructor.setName(ast.newSimpleName(this.fClassName));
        this.addLinkedPosition(KEY_TYPE_NAME, newConstructor.getName(), astRewrite, false);
        newConstructor.setBody(ast.newBlock());
        List newStatements = newConstructor.getBody().statements();
        List newParameters = newConstructor.parameters();
        ArrayList<String> newParameterNames = new ArrayList<String>();
        if (!instanceCreation.arguments().isEmpty() && (constructorBinding = this.getSuperConstructorBinding()) != null) {
            SuperConstructorInvocation superConstructorInvocation = ast.newSuperConstructorInvocation();
            ITypeBinding[] parameterTypes = constructorBinding.getParameterTypes();
            String[][] parameterNames = StubUtility.suggestArgumentNamesWithProposals(project, constructorBinding);
            int i = 0;
            while (i < parameterNames.length) {
                String[] nameProposals = parameterNames[i];
                String paramName = nameProposals[0];
                SingleVariableDeclaration param = this.newParameterDeclaration(ast, importRewrite, paramName, parameterTypes[i]);
                newParameters.add(param);
                newParameterNames.add(paramName);
                SimpleName newSIArgument = ast.newSimpleName(paramName);
                superConstructorInvocation.arguments().add(newSIArgument);
                if (this.fLinkedProposalModel != null) {
                    positionGroup = this.fLinkedProposalModel.getPositionGroup(KEY_PARAM_NAME_CONST + String.valueOf(i), true);
                    positionGroup.addPosition(astRewrite.track(param.getName()), false);
                    positionGroup.addPosition(astRewrite.track(newSIArgument), false);
                    k = 0;
                    while (k < nameProposals.length) {
                        positionGroup.addProposal(nameProposals[k], null, nameProposals.length - k);
                        ++k;
                    }
                }
                ++i;
            }
            newStatements.add(superConstructorInvocation);
        }
        boolean useThisAccess = this.useThisForFieldAccess();
        int i = 0;
        while (i < bindings.length) {
            String baseName = StubUtility.removePrefixAndSuffixForVariable(project, bindings[i]);
            String[] paramNameProposals = StubUtility.getVariableNameSuggestions(4, project, baseName, 0, newParameterNames, true);
            String paramName = paramNameProposals[0];
            SingleVariableDeclaration param = this.newParameterDeclaration(ast, importRewrite, paramName, bindings[i].getType());
            newParameters.add(param);
            newParameterNames.add(paramName);
            String fieldName = fieldNames[i];
            SimpleName fieldNameNode = ast.newSimpleName(fieldName);
            SimpleName paramNameNode = ast.newSimpleName(paramName);
            newStatements.add(this.newFieldAssignment(ast, fieldNameNode, paramNameNode, useThisAccess || newParameterNames.contains(fieldName)));
            if (this.fLinkedProposalModel != null) {
                positionGroup = this.fLinkedProposalModel.getPositionGroup(KEY_PARAM_NAME_EXT + String.valueOf(i), true);
                positionGroup.addPosition(astRewrite.track(param.getName()), false);
                positionGroup.addPosition(astRewrite.track(paramNameNode), false);
                k = 0;
                while (k < paramNameProposals.length) {
                    positionGroup.addProposal(paramNameProposals[k], null, paramNameProposals.length - k);
                    ++k;
                }
                this.fLinkedProposalModel.getPositionGroup(KEY_FIELD_NAME_EXT + i, true).addPosition(astRewrite.track(fieldNameNode), false);
            }
            ++i;
        }
        if (this.doAddComments()) {
            try {
                String[] allParamNames = newParameterNames.toArray(new String[newParameterNames.size()]);
                String string = CodeGeneration.getMethodComment(this.fCu, this.fClassName, this.fClassName, allParamNames, new String[0], null, null, StubUtility.getLineDelimiterUsed(this.fCu));
                if (string != null) {
                    JSdoc javadoc = (JSdoc)astRewrite.createStringPlaceholder(string, 29);
                    newConstructor.setJavadoc(javadoc);
                }
            }
            catch (CoreException exception) {
                JavaScriptPlugin.log(exception);
            }
        }
        return newConstructor;
    }

    private Statement newFieldAssignment(AST ast, SimpleName fieldNameNode, Expression initializer, boolean useThisAccess) {
        Assignment assignment = ast.newAssignment();
        if (useThisAccess) {
            FieldAccess access = ast.newFieldAccess();
            access.setExpression(ast.newThisExpression());
            access.setName(fieldNameNode);
            assignment.setLeftHandSide(access);
        } else {
            assignment.setLeftHandSide(fieldNameNode);
        }
        assignment.setOperator(Assignment.Operator.ASSIGN);
        assignment.setRightHandSide(initializer);
        return ast.newExpressionStatement(assignment);
    }

    private List getFieldsToInitializeInConstructor() {
        ArrayList<VariableDeclarationFragment> result = new ArrayList<VariableDeclarationFragment>(0);
        for (Object element : this.fAnonymousInnerClassNode.bodyDeclarations()) {
            if (!(element instanceof FieldDeclaration)) continue;
            List fragments = ((FieldDeclaration)element).fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                if (!this.isToBeInitializerInConstructor(fragment, result)) continue;
                result.add(fragment);
            }
        }
        return result;
    }

    private boolean isToBeInitializerInConstructor(VariableDeclarationFragment fragment, List fieldsToInitialize) {
        return fragment.getInitializer() != null && this.areLocalsUsedIn(fragment.getInitializer(), fieldsToInitialize);
    }

    private boolean areLocalsUsedIn(Expression fieldInitializer, List fieldsToInitialize) {
        HashSet localsUsed = new HashSet(0);
        this.collectRefrencedVariables(fieldInitializer, localsUsed);
        ITypeBinding anonType = this.fAnonymousInnerClassNode.resolveBinding();
        for (IVariableBinding curr : localsUsed) {
            if (this.isBindingToTemp(curr)) {
                return true;
            }
            if (!curr.isField() || curr.getDeclaringClass() != anonType || !fieldsToInitialize.contains(this.fCompilationUnitNode.findDeclaringNode(curr))) continue;
            return true;
        }
        return false;
    }

    private IFunctionBinding getSuperConstructorBinding() {
        IFunctionBinding anonConstr = ((ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent()).resolveConstructorBinding();
        if (anonConstr == null) {
            return null;
        }
        ITypeBinding superClass = anonConstr.getDeclaringClass().getSuperclass();
        IFunctionBinding[] superMethods = superClass.getDeclaredMethods();
        int i = 0;
        while (i < superMethods.length) {
            IFunctionBinding superMethod = superMethods[i];
            if (superMethod.isConstructor() && ConvertAnonymousToNestedRefactoring.parameterTypesMatch(superMethod, anonConstr)) {
                return superMethod;
            }
            ++i;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static boolean parameterTypesMatch(IFunctionBinding m1, IFunctionBinding m2) {
        ITypeBinding[] m2Params;
        ITypeBinding[] m1Params = m1.getParameterTypes();
        if (m1Params.length != (m2Params = m2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < m2Params.length) {
            if (!m1Params[i].equals(m2Params[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private SingleVariableDeclaration newParameterDeclaration(AST ast, ImportRewrite importRewrite, String paramName, ITypeBinding paramType) {
        SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
        param.setExtraDimensions(0);
        param.setInitializer(null);
        param.setType(importRewrite.addImport(paramType, ast));
        param.setName(ast.newSimpleName(paramName));
        return param;
    }

    private void setSuperType(TypeDeclaration declaration) throws JavaScriptModelException {
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
        ITypeBinding binding = classInstanceCreation.resolveTypeBinding();
        if (binding == null) {
            return;
        }
        Type newType = (Type)ASTNode.copySubtree(this.fAnonymousInnerClassNode.getAST(), classInstanceCreation.getType());
        if (binding.getSuperclass().getQualifiedName().equals("java.lang.Object")) {
            return;
        }
        declaration.setSuperclassType(newType);
    }

    private ITypeBinding getSuperTypeBinding() {
        ITypeBinding types = this.fAnonymousInnerClassNode.resolveBinding();
        return types.getSuperclass();
    }

    private int createModifiersForNestedClass() {
        int flags = this.fVisibility;
        if (this.fDeclareFinal) {
            flags |= 0x10;
        }
        if (this.mustInnerClassBeStatic() || this.fDeclareStatic) {
            flags |= 8;
        }
        return flags;
    }

    public boolean mustInnerClassBeStatic() {
        ITypeBinding typeBinding = ((AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class)).resolveBinding();
        ASTNode current = this.fAnonymousInnerClassNode.getParent();
        boolean ans = false;
        while (current != null) {
            switch (current.getNodeType()) {
                case 1: {
                    AnonymousClassDeclaration enclosingAnonymousClassDeclaration = (AnonymousClassDeclaration)current;
                    ITypeBinding binding = enclosingAnonymousClassDeclaration.resolveBinding();
                    if (binding == null || !Bindings.isSuperType(typeBinding, binding.getSuperclass())) break;
                    return false;
                }
                case 23: {
                    FieldDeclaration enclosingFieldDeclaration = (FieldDeclaration)current;
                    if (!Modifier.isStatic(enclosingFieldDeclaration.getModifiers())) break;
                    ans = true;
                    break;
                }
                case 31: {
                    FunctionDeclaration enclosingMethodDeclaration = (FunctionDeclaration)current;
                    if (!Modifier.isStatic(enclosingMethodDeclaration.getModifiers())) break;
                    ans = true;
                    break;
                }
                case 55: {
                    return ans;
                }
            }
            current = current.getParent();
        }
        return ans;
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String declareStatic;
        this.fSelfInitializing = true;
        if (arguments instanceof JavaRefactoringArguments) {
            int length;
            int offset;
            String selection;
            IJavaScriptElement element;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 5) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.convert.anonymous");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (IJavaScriptUnit)element;
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.fClassName = name;
            String visibility = extended.getAttribute(ATTRIBUTE_VISIBILITY);
            if (visibility != null && !"".equals(visibility)) {
                int flag = 0;
                try {
                    flag = Integer.parseInt(visibility);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
                }
                this.fVisibility = flag;
            }
            if ((selection = extended.getAttribute("selection")) != null) {
                offset = -1;
                length = -1;
                StringTokenizer tokenizer = new StringTokenizer(selection);
                if (tokenizer.hasMoreTokens()) {
                    offset = Integer.valueOf(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    length = Integer.valueOf(tokenizer.nextToken());
                }
                if (offset < 0 || length < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = offset;
            this.fSelectionLength = length;
            declareStatic = extended.getAttribute(ATTRIBUTE_STATIC);
            if (declareStatic == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_STATIC));
            }
            this.fDeclareStatic = Boolean.valueOf(declareStatic);
            String declareFinal = extended.getAttribute(ATTRIBUTE_FINAL);
            if (declareFinal == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fDeclareFinal = Boolean.valueOf(declareStatic);
        return new RefactoringStatus();
    }

    public static class TypeVariableFinder
    extends ASTVisitor {
        private final List fFound = new ArrayList();

        @Override
        public final boolean visit(SimpleName node) {
            Assert.isNotNull((Object)node);
            node.resolveTypeBinding();
            return true;
        }

        public final ITypeBinding[] getResult() {
            ITypeBinding[] result = new ITypeBinding[this.fFound.size()];
            this.fFound.toArray(result);
            return result;
        }
    }
}

