/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.surround;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.AbstractExceptionAnalyzer;

public class ExceptionAnalyzer
extends AbstractExceptionAnalyzer {
    private Selection fSelection;

    private ExceptionAnalyzer(Selection selection) {
        Assert.isNotNull((Object)selection);
        this.fSelection = selection;
    }

    public static ITypeBinding[] perform(BodyDeclaration enclosingNode, Selection selection) {
        ExceptionAnalyzer analyzer = new ExceptionAnalyzer(selection);
        enclosingNode.accept(analyzer);
        List exceptions = analyzer.getCurrentExceptions();
        if (enclosingNode.getNodeType() == 31) {
            List thrownExceptions = ((FunctionDeclaration)enclosingNode).thrownExceptions();
            Iterator thrown = thrownExceptions.iterator();
            while (thrown.hasNext()) {
                ITypeBinding thrownException = ((Name)thrown.next()).resolveTypeBinding();
                if (thrownException == null) continue;
                Iterator excep = exceptions.iterator();
                while (excep.hasNext()) {
                    ITypeBinding exception = (ITypeBinding)excep.next();
                    if (!exception.isAssignmentCompatible(thrownException)) continue;
                    excep.remove();
                }
            }
        }
        Collections.sort(exceptions, new ExceptionComparator());
        return exceptions.toArray(new ITypeBinding[exceptions.size()]);
    }

    @Override
    public boolean visit(ThrowStatement node) {
        ITypeBinding exception = node.getExpression().resolveTypeBinding();
        if (!this.isSelected(node) || exception == null || Bindings.isRuntimeException(exception)) {
            return true;
        }
        this.addException(exception);
        return true;
    }

    @Override
    public boolean visit(FunctionInvocation node) {
        if (!this.isSelected(node)) {
            return false;
        }
        return this.handleExceptions(node.resolveMethodBinding(), node.getAST());
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        if (!this.isSelected(node)) {
            return false;
        }
        return this.handleExceptions(node.resolveMethodBinding(), node.getAST());
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        if (!this.isSelected(node)) {
            return false;
        }
        return this.handleExceptions(node.resolveConstructorBinding(), node.getAST());
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        if (!this.isSelected(node)) {
            return false;
        }
        return this.handleExceptions(node.resolveConstructorBinding(), node.getAST());
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        if (!this.isSelected(node)) {
            return false;
        }
        return this.handleExceptions(node.resolveConstructorBinding(), node.getAST());
    }

    private boolean handleExceptions(IFunctionBinding binding, AST ast) {
        return true;
    }

    private boolean isSelected(ASTNode node) {
        return this.fSelection.getVisitSelectionMode(node) == 2;
    }

    private static class ExceptionComparator
    implements Comparator {
        private ExceptionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int d2;
            int d1 = this.getDepth((ITypeBinding)o1);
            if (d1 < (d2 = this.getDepth((ITypeBinding)o2))) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
            return 0;
        }

        private int getDepth(ITypeBinding binding) {
            int result = 0;
            while (binding != null) {
                binding = binding.getSuperclass();
                ++result;
            }
            return result;
        }
    }
}

