/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.GenericType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.NullType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.PrimitiveType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.RawType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.StandardType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.UnboundWildcardType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.VoidType;

public class TypeEnvironment {
    public final PrimitiveType INT = new PrimitiveType(this, 0, BindingKey.createTypeBindingKey("int"));
    public final PrimitiveType CHAR = new PrimitiveType(this, 1, BindingKey.createTypeBindingKey("char"));
    public final PrimitiveType BOOLEAN = new PrimitiveType(this, 2, BindingKey.createTypeBindingKey("boolean"));
    public final PrimitiveType SHORT = new PrimitiveType(this, 3, BindingKey.createTypeBindingKey("short"));
    public final PrimitiveType LONG = new PrimitiveType(this, 4, BindingKey.createTypeBindingKey("long"));
    public final PrimitiveType FLOAT = new PrimitiveType(this, 5, BindingKey.createTypeBindingKey("float"));
    public final PrimitiveType DOUBLE = new PrimitiveType(this, 6, BindingKey.createTypeBindingKey("double"));
    public final PrimitiveType BYTE = new PrimitiveType(this, 7, BindingKey.createTypeBindingKey("byte"));
    public final NullType NULL = new NullType(this);
    public final VoidType VOID = new VoidType(this);
    final PrimitiveType[] PRIMITIVE_TYPES = new PrimitiveType[]{this.INT, this.CHAR, this.BOOLEAN, this.SHORT, this.LONG, this.FLOAT, this.DOUBLE, this.BYTE};
    private static final String[] BOXED_PRIMITIVE_NAMES = new String[]{"java.lang.Integer", "java.lang.Character", "java.lang.Boolean", "java.lang.Short", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Byte"};
    private TType OBJECT_TYPE = null;
    private Map[] fArrayTypes = new Map[]{new HashMap()};
    private Map fStandardTypes = new HashMap();
    private Map fGenericTypes = new HashMap();
    private Map fParameterizedTypes = new HashMap();
    private Map fRawTypes = new HashMap();
    private Map fCaptureTypes = new HashMap();
    private UnboundWildcardType fUnboundWildcardType = null;
    private static final int MAX_ENTRIES = 1024;
    private Map fSubTypeCache = new LinkedHashMap(50, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1024;
        }
    };
    private Map fSubTypes;

    public static ITypeBinding[] createTypeBindings(TType[] types, IJavaScriptProject project) {
        final HashMap<String, TType> mapping = new HashMap<String, TType>();
        ArrayList<String> keys = new ArrayList<String>();
        int i = 0;
        while (i < types.length) {
            TType type = types[i];
            String bindingKey = type.getBindingKey();
            mapping.put(bindingKey, type);
            keys.add(bindingKey);
            ++i;
        }
        ASTParser parser = ASTParser.newParser(3);
        parser.setProject(project);
        parser.setResolveBindings(true);
        parser.createASTs(new IJavaScriptUnit[0], keys.toArray(new String[keys.size()]), new ASTRequestor(){

            @Override
            public void acceptBinding(String bindingKey, IBinding binding) {
                mapping.put(bindingKey, binding);
            }
        }, null);
        ITypeBinding[] result = new ITypeBinding[types.length];
        int i2 = 0;
        while (i2 < types.length) {
            TType type = types[i2];
            String bindingKey = type.getBindingKey();
            Object value = mapping.get(bindingKey);
            if (value instanceof ITypeBinding) {
                result[i2] = (ITypeBinding)value;
            }
            ++i2;
        }
        return result;
    }

    public TypeEnvironment() {
        this(false);
    }

    public TypeEnvironment(boolean rememberSubtypes) {
        if (rememberSubtypes) {
            this.fSubTypes = new HashMap();
        }
    }

    Map getSubTypeCache() {
        return this.fSubTypeCache;
    }

    public TType create(ITypeBinding binding) {
        if (binding.isPrimitive()) {
            return this.createPrimitiveType(binding);
        }
        if (binding.isArray()) {
            return this.createArrayType(binding);
        }
        if ("null".equals(binding.getName())) {
            return this.NULL;
        }
        return this.createStandardType(binding);
    }

    public TType[] create(ITypeBinding[] bindings) {
        TType[] result = new TType[bindings.length];
        int i = 0;
        while (i < bindings.length) {
            result[i] = this.create(bindings[i]);
            ++i;
        }
        return result;
    }

    public TType getJavaLangObject() {
        return this.OBJECT_TYPE;
    }

    void initializeJavaLangObject(ITypeBinding object) {
        if (this.OBJECT_TYPE != null) {
            return;
        }
        StandardType objectType = this.createStandardType(object);
        Assert.isTrue((boolean)((TType)objectType).isJavaLangObject());
    }

    PrimitiveType createUnBoxed(StandardType type) {
        String name = type.getPlainPrettySignature();
        int i = 0;
        while (i < BOXED_PRIMITIVE_NAMES.length) {
            if (BOXED_PRIMITIVE_NAMES[i].equals(name)) {
                return this.PRIMITIVE_TYPES[i];
            }
            ++i;
        }
        return null;
    }

    StandardType createBoxed(PrimitiveType type, IJavaScriptProject focus) {
        String fullyQualifiedName = BOXED_PRIMITIVE_NAMES[type.getId()];
        try {
            IType javaElementType = focus.findType(fullyQualifiedName);
            StandardType result = (StandardType)this.fStandardTypes.get(javaElementType);
            if (result != null) {
                return result;
            }
            ASTParser parser = ASTParser.newParser(3);
            parser.setProject(focus);
            IBinding[] bindings = parser.createBindings(new IJavaScriptElement[]{javaElementType}, null);
            return this.createStandardType((ITypeBinding)bindings[0]);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    Map getSubTypes() {
        return this.fSubTypes;
    }

    private void cacheSubType(TType supertype, TType result) {
        ArrayList<TType> subtypes;
        if (this.fSubTypes == null) {
            return;
        }
        if (supertype == null) {
            supertype = this.OBJECT_TYPE;
        }
        if ((subtypes = (ArrayList<TType>)this.fSubTypes.get(supertype)) == null) {
            subtypes = new ArrayList<TType>(5);
            this.fSubTypes.put(supertype, subtypes);
        } else {
            Assert.isTrue((!subtypes.contains(result) ? 1 : 0) != 0);
        }
        subtypes.add(result);
    }

    private void cacheSubTypes(TType[] interfaces, TType result) {
        int i = 0;
        while (i < interfaces.length) {
            this.cacheSubType(interfaces[i], result);
            ++i;
        }
    }

    private TType createPrimitiveType(ITypeBinding binding) {
        String name = binding.getName();
        String[] names = PrimitiveType.NAMES;
        int i = 0;
        while (i < names.length) {
            if (name.equals(names[i])) {
                return this.PRIMITIVE_TYPES[i];
            }
            ++i;
        }
        Assert.isTrue((boolean)false, (String)("Primitive type " + name + "unkown"));
        return null;
    }

    private ArrayType createArrayType(ITypeBinding binding) {
        int index = binding.getDimensions() - 1;
        TType elementType = this.create(binding.getElementType());
        Map arrayTypes = this.getArrayTypesMap(index);
        ArrayType result = (ArrayType)arrayTypes.get(elementType);
        if (result != null) {
            return result;
        }
        result = new ArrayType(this);
        arrayTypes.put(elementType, result);
        result.initialize(binding, elementType);
        return result;
    }

    public ArrayType createArrayType(TType elementType, int dimensions) {
        Assert.isTrue((!elementType.isArrayType() ? 1 : 0) != 0);
        Assert.isTrue((!elementType.isAnonymous() ? 1 : 0) != 0);
        Assert.isTrue((dimensions > 0 ? 1 : 0) != 0);
        int index = dimensions - 1;
        Map arrayTypes = this.getArrayTypesMap(index);
        ArrayType result = (ArrayType)arrayTypes.get(elementType);
        if (result != null) {
            return result;
        }
        result = new ArrayType(this, BindingKey.createArrayTypeBindingKey(elementType.getBindingKey(), dimensions));
        arrayTypes.put(elementType, result);
        result.initialize(elementType, dimensions);
        return result;
    }

    private Map getArrayTypesMap(int index) {
        HashMap arrayTypes;
        int oldLength = this.fArrayTypes.length;
        if (index >= oldLength) {
            Map[] newArray = new Map[index + 1];
            System.arraycopy(this.fArrayTypes, 0, newArray, 0, oldLength);
            this.fArrayTypes = newArray;
        }
        if ((arrayTypes = this.fArrayTypes[index]) == null) {
            this.fArrayTypes[index] = arrayTypes = new HashMap();
        }
        return arrayTypes;
    }

    private StandardType createStandardType(ITypeBinding binding) {
        IJavaScriptElement javaElement = binding.getJavaElement();
        StandardType result = (StandardType)this.fStandardTypes.get(javaElement);
        if (result != null) {
            return result;
        }
        result = new StandardType(this);
        this.fStandardTypes.put(javaElement, result);
        result.initialize(binding, (IType)javaElement);
        if (this.OBJECT_TYPE == null && result.isJavaLangObject()) {
            this.OBJECT_TYPE = result;
        }
        return result;
    }

    private GenericType createGenericType(ITypeBinding binding) {
        IJavaScriptElement javaElement = binding.getJavaElement();
        GenericType result = (GenericType)this.fGenericTypes.get(javaElement);
        if (result != null) {
            return result;
        }
        result = new GenericType(this);
        this.fGenericTypes.put(javaElement, result);
        result.initialize(binding, (IType)javaElement);
        this.cacheSubType(result.getSuperclass(), result);
        this.cacheSubTypes(result.getInterfaces(), result);
        return result;
    }

    private RawType createRawType(ITypeBinding binding) {
        IJavaScriptElement javaElement = binding.getJavaElement();
        RawType result = (RawType)this.fRawTypes.get(javaElement);
        if (result != null) {
            return result;
        }
        result = new RawType(this);
        this.fRawTypes.put(javaElement, result);
        result.initialize(binding, (IType)javaElement);
        this.cacheSubType(result.getSuperclass(), result);
        this.cacheSubTypes(result.getInterfaces(), result);
        return result;
    }

    private TType createUnboundWildcardType(ITypeBinding binding) {
        if (this.fUnboundWildcardType == null) {
            this.fUnboundWildcardType = new UnboundWildcardType(this);
            this.fUnboundWildcardType.initialize(binding);
        }
        return this.fUnboundWildcardType;
    }

    private CaptureType createCaptureType(ITypeBinding binding) {
        String bindingKey;
        IJavaScriptProject javaProject = binding.getDeclaringClass().getJavaElement().getJavaScriptProject();
        ProjectKeyPair pair = new ProjectKeyPair(javaProject, bindingKey = binding.getKey());
        CaptureType result = (CaptureType)this.fCaptureTypes.get(pair);
        if (result != null) {
            return result;
        }
        result = new CaptureType(this);
        this.fCaptureTypes.put(pair, result);
        result.initialize(binding, javaProject);
        return result;
    }

    private static class ProjectKeyPair {
        private final IJavaScriptProject fProject;
        private final String fBindingKey;

        public ProjectKeyPair(IJavaScriptProject project, String bindingKey) {
            this.fProject = project;
            this.fBindingKey = bindingKey;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectKeyPair)) {
                return false;
            }
            ProjectKeyPair otherPair = (ProjectKeyPair)other;
            return this.fProject.equals(otherPair.fProject) && this.fBindingKey.equals(otherPair.fBindingKey);
        }

        public int hashCode() {
            return this.fProject.hashCode() + this.fBindingKey.hashCode();
        }
    }
}

