/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;

public abstract class AbstractExceptionAnalyzer
extends ASTVisitor {
    private List fCurrentExceptions;
    private Stack fTryStack = new Stack();

    protected AbstractExceptionAnalyzer() {
        this.fCurrentExceptions = new ArrayList(1);
        this.fTryStack.push(this.fCurrentExceptions);
    }

    @Override
    public abstract boolean visit(ThrowStatement var1);

    @Override
    public abstract boolean visit(FunctionInvocation var1);

    @Override
    public abstract boolean visit(ClassInstanceCreation var1);

    @Override
    public boolean visit(TypeDeclaration node) {
        return !node.isLocalTypeDeclaration();
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    @Override
    public boolean visit(TryStatement node) {
        this.fCurrentExceptions = new ArrayList(1);
        this.fTryStack.push(this.fCurrentExceptions);
        node.getBody().accept(this);
        List catchClauses = node.catchClauses();
        if (!catchClauses.isEmpty()) {
            this.handleCatchArguments(catchClauses);
        }
        List current = (List)this.fTryStack.pop();
        this.fCurrentExceptions = (List)this.fTryStack.peek();
        Iterator iter = current.iterator();
        while (iter.hasNext()) {
            this.addException((ITypeBinding)iter.next());
        }
        iter = catchClauses.iterator();
        while (iter.hasNext()) {
            ((CatchClause)iter.next()).accept(this);
        }
        if (node.getFinally() != null) {
            node.getFinally().accept(this);
        }
        return false;
    }

    protected void addExceptions(ITypeBinding[] exceptions) {
        if (exceptions == null) {
            return;
        }
        int i = 0;
        while (i < exceptions.length) {
            this.addException(exceptions[i]);
            ++i;
        }
    }

    protected void addException(ITypeBinding exception) {
        if (!this.fCurrentExceptions.contains(exception)) {
            this.fCurrentExceptions.add(exception);
        }
    }

    protected List getCurrentExceptions() {
        return this.fCurrentExceptions;
    }

    private void handleCatchArguments(List catchClauses) {
        for (CatchClause clause : catchClauses) {
            ITypeBinding catchTypeBinding = clause.getException().getType().resolveBinding();
            if (catchTypeBinding == null) continue;
            for (ITypeBinding throwTypeBinding : new ArrayList(this.fCurrentExceptions)) {
                if (!this.catches(catchTypeBinding, throwTypeBinding)) continue;
                this.fCurrentExceptions.remove(throwTypeBinding);
            }
        }
    }

    private boolean catches(ITypeBinding catchTypeBinding, ITypeBinding throwTypeBinding) {
        while (throwTypeBinding != null) {
            if (throwTypeBinding == catchTypeBinding) {
                return true;
            }
            throwTypeBinding = throwTypeBinding.getSuperclass();
        }
        return false;
    }
}

