/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;

abstract class LogicalPackagesProvider
implements IPropertyChangeListener,
IElementChangedListener {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected Map fMapToLogicalPackage;
    protected Map fMapToPackageFragments;
    protected boolean fCompoundState;
    protected StructuredViewer fViewer;
    protected boolean fInputIsProject;

    public LogicalPackagesProvider(StructuredViewer viewer) {
        this.fViewer = viewer;
        this.fCompoundState = this.isInCompoundState();
        this.fInputIsProject = true;
        this.fMapToLogicalPackage = new HashMap();
        this.fMapToPackageFragments = new HashMap();
        JavaScriptPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void addFragmentsToMap(IPackageFragment[] packageFragments) {
        int i = 0;
        while (i < packageFragments.length) {
            IPackageFragment fragment = packageFragments[i];
            String key = this.getKey(fragment);
            this.fMapToPackageFragments.put(key, fragment);
            ++i;
        }
    }

    protected String getKey(IPackageFragment fragment) {
        return String.valueOf(fragment.getElementName()) + fragment.getJavaScriptProject().getElementName();
    }

    public LogicalPackage findLogicalPackage(IPackageFragment fragment) {
        Assert.isNotNull((Object)fragment);
        if (this.isInCompoundState()) {
            return (LogicalPackage)((Object)this.fMapToLogicalPackage.get(this.getKey(fragment)));
        }
        return null;
    }

    protected Object[] combineSamePackagesIntoLogialPackages(IPackageFragment[] packageFragments) {
        if (!this.fCompoundState) {
            return packageFragments;
        }
        ArrayList<Object> newChildren = new ArrayList<Object>();
        int i = 0;
        while (i < packageFragments.length) {
            IPackageFragment fragment = packageFragments[i];
            if (fragment != null) {
                LogicalPackage lp = this.findLogicalPackage(fragment);
                if (lp != null) {
                    if (lp.belongs(fragment)) {
                        lp.add(fragment);
                    }
                    if (!newChildren.contains((Object)lp)) {
                        newChildren.add((Object)lp);
                    }
                } else {
                    String key = this.getKey(fragment);
                    IPackageFragment frag = (IPackageFragment)this.fMapToPackageFragments.get(key);
                    if (frag != null && !fragment.equals(frag)) {
                        lp = new LogicalPackage(frag);
                        lp.add(fragment);
                        newChildren.remove(frag);
                        newChildren.add((Object)lp);
                        this.fMapToLogicalPackage.put(key, lp);
                        this.fMapToPackageFragments.remove(frag);
                    } else {
                        this.fMapToPackageFragments.put(key, fragment);
                        newChildren.add(fragment);
                    }
                }
            }
            ++i;
        }
        return newChildren.toArray();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fCompoundState == this.isInCompoundState()) {
            return;
        }
        this.fCompoundState = this.isInCompoundState();
        if (!this.isInCompoundState()) {
            this.fMapToLogicalPackage.clear();
            this.fMapToPackageFragments.clear();
        }
        if (this.fViewer instanceof TreeViewer) {
            TreeViewer viewer = (TreeViewer)this.fViewer;
            Object[] expandedObjects = viewer.getExpandedElements();
            viewer.refresh();
            viewer.setExpandedElements(expandedObjects);
        } else {
            this.fViewer.refresh();
        }
    }

    protected boolean isInCompoundState() {
        return true;
    }

    public void dispose() {
        JavaScriptPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fMapToLogicalPackage = null;
        this.fMapToPackageFragments = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            JavaScriptCore.addElementChangedListener(this);
        } else {
            JavaScriptCore.removeElementChangedListener(this);
        }
        this.fInputIsProject = newInput instanceof IJavaScriptProject;
        if (viewer instanceof StructuredViewer) {
            this.fViewer = (StructuredViewer)viewer;
        }
    }

    protected abstract void processDelta(IJavaScriptElementDelta var1) throws JavaScriptModelException;

    protected boolean isClassPathChange(IJavaScriptElementDelta delta) {
        if (delta.getElement().getElementType() != 3) {
            return false;
        }
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    @Override
    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log((Throwable)((Object)e));
        }
    }
}

