/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaElementHyperlink;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;

public class JavaElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks, JavaScriptUnit ast) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof JavaEditor)) {
            return null;
        }
        IAction openAction = textEditor.getAction("OpenEditor");
        if (openAction == null) {
            return null;
        }
        int offset = region.getOffset();
        IJavaScriptElement input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, false);
        if (input == null) {
            return null;
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IRegion wordRegion = JavaWordFinder.findWord(document, offset);
        if (wordRegion == null) {
            return null;
        }
        if (ast == null) {
            ast = JavaScriptPlugin.getDefault().getASTProvider().getAST(input, ASTProvider.WAIT_NO, null);
        }
        if (ast != null) {
            int start = wordRegion.getOffset();
            int end = start + wordRegion.getLength();
            HyperlinkCandidateVisitor visitor = new HyperlinkCandidateVisitor(start, end);
            try {
                ast.accept(visitor);
            }
            catch (HyperlinkCandidateVisitor.HyperlinkCandidateFoundException hyperlinkCandidateFoundException) {}
            if (visitor.fFoundCandidate) {
                return new IHyperlink[]{new JavaElementHyperlink(wordRegion, openAction)};
            }
        }
        return null;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof JavaEditor)) {
            return null;
        }
        IAction openAction = textEditor.getAction("OpenEditor");
        if (openAction == null) {
            return null;
        }
        int offset = region.getOffset();
        IJavaScriptElement input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, false);
        if (input == null) {
            return null;
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IRegion wordRegion = JavaWordFinder.findWord(document, offset);
        if (wordRegion == null) {
            return null;
        }
        JavaScriptUnit ast = JavaScriptPlugin.getDefault().getASTProvider().getAST(input, ASTProvider.WAIT_NO, null);
        if (ast != null) {
            int start = wordRegion.getOffset();
            int end = start + wordRegion.getLength();
            HyperlinkCandidateVisitor visitor = new HyperlinkCandidateVisitor(start, end);
            try {
                ast.accept(visitor);
            }
            catch (HyperlinkCandidateVisitor.HyperlinkCandidateFoundException hyperlinkCandidateFoundException) {}
            if (visitor.fFoundCandidate) {
                return new IHyperlink[]{new JavaElementHyperlink(wordRegion, openAction)};
            }
        }
        return null;
    }

    private class HyperlinkCandidateVisitor
    extends ASTVisitor {
        protected boolean fFoundCandidate = false;
        private int fStartOffset;
        private int fEndOffset;

        protected HyperlinkCandidateVisitor(int start, int end) {
            this.fStartOffset = start;
            this.fEndOffset = end;
        }

        @Override
        public void preVisit(ASTNode node) {
            switch (node.getNodeType()) {
                case 40: 
                case 42: {
                    this.isCandidate(node);
                }
            }
        }

        private void isCandidate(ASTNode n) {
            if (!this.fFoundCandidate) {
                int start = n.getStartPosition();
                int end = start + n.getLength();
                if (start >= this.fStartOffset && end <= this.fEndOffset) {
                    this.fFoundCandidate = true;
                    throw new HyperlinkCandidateFoundException();
                }
            }
        }

        private class HyperlinkCandidateFoundException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            private HyperlinkCandidateFoundException() {
            }
        }
    }
}

