/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeManager;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeWorkingCopy;
import org.eclipse.wst.jsdt.internal.ui.preferences.AddRuntimeInstallWizard;
import org.eclipse.wst.jsdt.internal.ui.preferences.EditRuntimeInstallWizard;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.RuntimeDetailsDialog;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class InstalledJSRuntimesBlock
implements ISelectionProvider {
    private Composite fControl;
    private List<IJSRuntimeInstall> fRuntimeInstalls = new ArrayList<IJSRuntimeInstall>();
    private CheckboxTableViewer fRuntimeList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private Button fCopyButton;
    private int fSortColumn = 0;
    private ListenerList<ISelectionChangedListener> fSelectionListeners = new ListenerList();
    private ISelection fPrevSelection = new StructuredSelection();
    private Table fTable;
    private static String fgLastUsedID;
    private IJSRuntimeType currentRuntimeType;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.fRuntimeList.getCheckedElements());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            Object runtime = ((IStructuredSelection)selection).getFirstElement();
            if (runtime == null) {
                this.fRuntimeList.setCheckedElements(new Object[0]);
            } else {
                this.fRuntimeList.setCheckedElements(new Object[]{runtime});
                this.fRuntimeList.reveal(runtime);
            }
            this.fRuntimeList.refresh(true);
            this.fireSelectionChanged();
        }
    }

    public void createControl(Composite ancestor) {
        Composite parent;
        Font font = ancestor.getFont();
        this.fControl = parent = SWTFactory.createComposite((Composite)ancestor, (Font)font, (int)2, (int)1, (int)1808);
        SWTFactory.createLabel((Composite)parent, (String)PreferencesMessages.InstalledJSRuntimesBlock_InstalledRuntimes_Label, (int)2);
        this.fTable = new Table(parent, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 350;
        this.fTable.setLayoutData((Object)gd);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column = new TableColumn(this.fTable, 0);
        column.setText(PreferencesMessages.InstalledJSRuntimesBlock_NameColumn_Label);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledJSRuntimesBlock.this.sortByName();
                InstalledJSRuntimesBlock.this.fRuntimeList.refresh(true);
            }
        });
        int defaultwidth = 176;
        column.setWidth(defaultwidth);
        column = new TableColumn(this.fTable, 0);
        column.setText(PreferencesMessages.InstalledJSRuntimesBlock_LocationColumn_Label);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledJSRuntimesBlock.this.sortByLocation();
                InstalledJSRuntimesBlock.this.fRuntimeList.refresh(true);
            }
        });
        column.setWidth(defaultwidth);
        this.fRuntimeList = new CheckboxTableViewer(this.fTable);
        this.fRuntimeList.setLabelProvider((IBaseLabelProvider)new RuntimeInstallsLabelProvider());
        this.fRuntimeList.setContentProvider((IContentProvider)new RuntimeInstallsContentProvider());
        this.fRuntimeList.setUseHashlookup(true);
        this.sortByName();
        this.fRuntimeList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                InstalledJSRuntimesBlock.this.enableButtons();
            }
        });
        this.fRuntimeList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    InstalledJSRuntimesBlock.this.setCheckedRuntimeInstall((IJSRuntimeInstall)event.getElement());
                } else {
                    InstalledJSRuntimesBlock.this.setCheckedRuntimeInstall(null);
                }
            }
        });
        this.fRuntimeList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!InstalledJSRuntimesBlock.this.fRuntimeList.getSelection().isEmpty()) {
                    InstalledJSRuntimesBlock.this.editRuntime();
                }
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && InstalledJSRuntimesBlock.this.fRemoveButton.isEnabled()) {
                    InstalledJSRuntimesBlock.this.removeRuntimes();
                }
            }
        });
        Composite buttons = SWTFactory.createComposite((Composite)parent, (Font)font, (int)1, (int)1, (int)2, (int)0, (int)0);
        this.fAddButton = SWTFactory.createPushButton((Composite)buttons, (String)PreferencesMessages.InstalledJSRuntimesBlock_AddButton_Label, null);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledJSRuntimesBlock.this.addRuntime();
            }
        });
        this.fEditButton = SWTFactory.createPushButton((Composite)buttons, (String)PreferencesMessages.InstalledJSRuntimesBlock_EditButton_Label, null);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledJSRuntimesBlock.this.editRuntime();
            }
        });
        this.fCopyButton = SWTFactory.createPushButton((Composite)buttons, (String)PreferencesMessages.InstalledJSRuntimesBlock_DuplicateButton_Label, null);
        this.fCopyButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledJSRuntimesBlock.this.copyRuntime();
            }
        });
        this.fRemoveButton = SWTFactory.createPushButton((Composite)buttons, (String)PreferencesMessages.InstalledJSRuntimesBlock_RemoveButton_Label, null);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledJSRuntimesBlock.this.removeRuntimes();
            }
        });
        SWTFactory.createVerticalSpacer((Composite)parent, (int)1);
        this.enableButtons();
        this.fAddButton.setEnabled(JSRuntimeManager.getJSRuntimeTypes().size() > 0);
    }

    protected void copyRuntime() {
        IStructuredSelection selection = (IStructuredSelection)this.fRuntimeList.getSelection();
        Iterator it = selection.iterator();
        ArrayList<JSRuntimeWorkingCopy> newEntries = new ArrayList<JSRuntimeWorkingCopy>();
        while (it.hasNext()) {
            IJSRuntimeInstall selectedRuntime = (IJSRuntimeInstall)it.next();
            JSRuntimeWorkingCopy standin = new JSRuntimeWorkingCopy(selectedRuntime, this.createUniqueId(selectedRuntime.getRuntimeType()));
            standin.setName(this.generateName(selectedRuntime.getName()));
            EditRuntimeInstallWizard wizard = new EditRuntimeInstallWizard(standin, this.currentRuntimeType, this.fRuntimeInstalls.toArray(new IJSRuntimeInstall[this.fRuntimeInstalls.size()]));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            int dialogResult = dialog.open();
            if (dialogResult == 0) {
                JSRuntimeWorkingCopy result = wizard.getResult();
                if (result == null) continue;
                newEntries.add(result);
                continue;
            }
            if (dialogResult == 1) break;
        }
        if (newEntries.size() > 0) {
            this.fRuntimeInstalls.addAll(newEntries);
            this.fRuntimeList.refresh();
            this.fRuntimeList.setSelection((ISelection)new StructuredSelection(newEntries.toArray()));
        } else {
            this.fRuntimeList.setSelection((ISelection)selection);
        }
        this.fRuntimeList.refresh(true);
    }

    public String generateName(String name) {
        if (!this.isDuplicateName(name)) {
            return name;
        }
        if (name.matches(".*\\(\\d*\\)")) {
            int start = name.lastIndexOf(40);
            int end = name.lastIndexOf(41);
            String stringInt = name.substring(start + 1, end);
            int numericValue = Integer.parseInt(stringInt);
            String newName = String.valueOf(name.substring(0, start + 1)) + (numericValue + 1) + ")";
            return this.generateName(newName);
        }
        return this.generateName(String.valueOf(name) + " (1)");
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.fSelectionListeners) {
            listener.selectionChanged(event);
        }
    }

    private void sortByName() {
        this.fRuntimeList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IJSRuntimeInstall && e2 instanceof IJSRuntimeInstall) {
                    IJSRuntimeInstall left = (IJSRuntimeInstall)e1;
                    IJSRuntimeInstall right = (IJSRuntimeInstall)e2;
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 1;
    }

    private void sortByLocation() {
        this.fRuntimeList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IJSRuntimeInstall && e2 instanceof IJSRuntimeInstall) {
                    IJSRuntimeInstall left = (IJSRuntimeInstall)e1;
                    IJSRuntimeInstall right = (IJSRuntimeInstall)e2;
                    return left.getInstallLocation().getAbsolutePath().compareToIgnoreCase(right.getInstallLocation().getAbsolutePath());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 2;
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fRuntimeList.getSelection();
        int selectionCount = selection.size();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fCopyButton.setEnabled(selectionCount > 0);
        if (selectionCount > 0 && selectionCount <= this.fRuntimeList.getTable().getItemCount()) {
            for (IJSRuntimeInstall install : selection) {
                if (!JSRuntimeManager.isContributedRuntimeInstall(install.getId())) continue;
                this.fRemoveButton.setEnabled(false);
                return;
            }
            this.fRemoveButton.setEnabled(true);
        } else {
            this.fRemoveButton.setEnabled(false);
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setRuntimeInstalls(IJSRuntimeInstall[] runtimes) {
        this.fRuntimeInstalls.clear();
        int i = 0;
        while (i < runtimes.length) {
            this.fRuntimeInstalls.add(runtimes[i]);
            ++i;
        }
        this.fRuntimeList.setInput(this.fRuntimeInstalls);
        this.fRuntimeList.refresh();
    }

    public IJSRuntimeInstall[] getRuntimeInstalls() {
        return this.fRuntimeInstalls.toArray(new IJSRuntimeInstall[this.fRuntimeInstalls.size()]);
    }

    private void addRuntime() {
        JSRuntimeWorkingCopy result;
        AddRuntimeInstallWizard wizard = new AddRuntimeInstallWizard(this.currentRuntimeType, this.fRuntimeInstalls.toArray(new IJSRuntimeInstall[this.fRuntimeInstalls.size()]));
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (result = wizard.getResult()) != null) {
            this.fRuntimeInstalls.add(result);
            this.fRuntimeList.refresh();
            this.fRuntimeList.setSelection((ISelection)new StructuredSelection((Object)result));
            this.fRuntimeList.refresh(true);
        }
    }

    public boolean isDuplicateName(String name) {
        int i = 0;
        while (i < this.fRuntimeInstalls.size()) {
            IJSRuntimeInstall runtime = this.fRuntimeInstalls.get(i);
            if (runtime.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void editRuntime() {
        IStructuredSelection selection = (IStructuredSelection)this.fRuntimeList.getSelection();
        JSRuntimeWorkingCopy runtime = (JSRuntimeWorkingCopy)selection.getFirstElement();
        if (runtime == null) {
            return;
        }
        if (JSRuntimeManager.isContributedRuntimeInstall(runtime.getId())) {
            RuntimeDetailsDialog dialog = new RuntimeDetailsDialog(this.getShell(), runtime);
            dialog.open();
        } else {
            JSRuntimeWorkingCopy result;
            EditRuntimeInstallWizard wizard = new EditRuntimeInstallWizard(runtime, this.currentRuntimeType, this.fRuntimeInstalls.toArray(new IJSRuntimeInstall[this.fRuntimeInstalls.size()]));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0 && (result = wizard.getResult()) != null) {
                int index = this.fRuntimeInstalls.indexOf(runtime);
                this.fRuntimeInstalls.remove(index);
                this.fRuntimeInstalls.add(index, result);
                this.fRuntimeList.setSelection((ISelection)new StructuredSelection((Object)result));
                this.fRuntimeList.refresh(true);
            }
        }
    }

    private void removeRuntimes() {
        IStructuredSelection selection = (IStructuredSelection)this.fRuntimeList.getSelection();
        IJSRuntimeInstall[] runtimes = new IJSRuntimeInstall[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            runtimes[i] = (IJSRuntimeInstall)iter.next();
            ++i;
        }
        this.removeRuntimes(runtimes);
    }

    public void removeRuntimes(IJSRuntimeInstall[] runtimes) {
        int i = 0;
        while (i < runtimes.length) {
            this.fRuntimeInstalls.remove(runtimes[i]);
            ++i;
        }
        this.fRuntimeList.refresh();
        IStructuredSelection curr = (IStructuredSelection)this.getSelection();
        IJSRuntimeInstall[] installs = this.getRuntimeInstalls();
        if (installs.length < 1) {
            this.fPrevSelection = null;
        }
        if (curr.size() == 0 && installs.length == 1) {
            this.setSelection((ISelection)new StructuredSelection((Object)installs[0]));
        } else {
            this.fireSelectionChanged();
        }
        this.fRuntimeList.refresh(true);
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    private String createUniqueId(IJSRuntimeType runtimeType) {
        String id = null;
        while (JSRuntimeManager.getJSRuntimeInstall(id = String.valueOf(System.currentTimeMillis())) != null || id.equals(fgLastUsedID)) {
        }
        fgLastUsedID = id;
        return id;
    }

    public void setCheckedRuntimeInstall(IJSRuntimeInstall runtime) {
        if (runtime == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)runtime));
        }
    }

    public IJSRuntimeInstall getCheckedRuntimeInstall() {
        Object[] objects = this.fRuntimeList.getCheckedElements();
        if (objects.length == 0) {
            return null;
        }
        return (IJSRuntimeInstall)objects[0];
    }

    public void saveColumnSettings(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            settings.put(String.valueOf(qualifier) + ".columnWidth" + i, this.fTable.getColumn(i).getWidth());
            ++i;
        }
        settings.put(String.valueOf(qualifier) + ".sortColumn", this.fSortColumn);
    }

    public void restoreColumnSettings(IDialogSettings settings, String qualifier) {
        this.fRuntimeList.getTable().layout(true);
        this.restoreColumnWidths(settings, qualifier);
        try {
            this.fSortColumn = settings.getInt(String.valueOf(qualifier) + ".sortColumn");
        }
        catch (NumberFormatException numberFormatException) {
            this.fSortColumn = 1;
        }
        switch (this.fSortColumn) {
            case 1: {
                this.sortByName();
                break;
            }
            case 2: {
                this.sortByLocation();
            }
        }
    }

    private void restoreColumnWidths(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            int width = -1;
            try {
                width = settings.getInt(String.valueOf(qualifier) + ".columnWidth" + i);
            }
            catch (NumberFormatException numberFormatException) {}
            if (width > 0) {
                this.fTable.getColumn(i).setWidth(width);
            }
            ++i;
        }
    }

    protected void fillWithManagedRuntimeInstalls() {
        ArrayList<JSRuntimeWorkingCopy> standins = new ArrayList<JSRuntimeWorkingCopy>();
        IJSRuntimeInstall[] installs = JSRuntimeManager.getJSRuntimeInstallsByType(this.currentRuntimeType.getId());
        int j = 0;
        while (j < installs.length) {
            IJSRuntimeInstall install = installs[j];
            standins.add(new JSRuntimeWorkingCopy(install));
            ++j;
        }
        this.setRuntimeInstalls(standins.toArray(new IJSRuntimeInstall[standins.size()]));
    }

    public String getTimeStamp() {
        return this.getEncodedRuntimeInstalls();
    }

    private StringBuffer appendRuntimeAttributes(IJSRuntimeInstall runtimeInstall, StringBuffer buf) {
        if (runtimeInstall != null) {
            String str = runtimeInstall.getName();
            buf.append('[').append(str.length()).append(']').append(str);
            str = runtimeInstall.getRuntimeType().getName();
            buf.append('[').append(str.length()).append(']').append(str);
            if (runtimeInstall.getJSRuntimeArguments() != null && runtimeInstall.getJSRuntimeArguments().length > 0) {
                buf.append('[').append(runtimeInstall.getJSRuntimeArguments().length).append(']');
                int i = 0;
                while (i < runtimeInstall.getJSRuntimeArguments().length) {
                    str = runtimeInstall.getJSRuntimeArguments()[i];
                    buf.append('[').append(str.length()).append(']').append(str);
                    ++i;
                }
            }
            str = runtimeInstall.getInstallLocation().getAbsolutePath();
            buf.append('[').append(str.length()).append(']').append(str).append(';');
        } else {
            buf.append('[').append(']').append(';');
        }
        return buf;
    }

    private String getEncodedRuntimeInstalls() {
        StringBuffer buf = new StringBuffer();
        IJSRuntimeInstall runtimeInstall = this.getCheckedRuntimeInstall();
        int nElements = this.fRuntimeInstalls.size();
        buf.append('[').append(nElements).append(']');
        int i = 0;
        while (i < nElements) {
            IJSRuntimeInstall elem = this.fRuntimeInstalls.get(i);
            if (elem == runtimeInstall) {
                buf.append('[').append("defaultRuntime").append(']');
            }
            this.appendRuntimeAttributes(elem, buf);
            ++i;
        }
        return buf.toString();
    }

    public void setRuntimeType(IJSRuntimeType jsRuntimeType) {
        this.currentRuntimeType = jsRuntimeType;
        this.fillWithManagedRuntimeInstalls();
    }

    public void setRuntimeType(IJSRuntimeType jsRuntimeType, IJSRuntimeInstall[] installs) {
        this.currentRuntimeType = jsRuntimeType;
        ArrayList<JSRuntimeWorkingCopy> standins = new ArrayList<JSRuntimeWorkingCopy>();
        int j = 0;
        while (j < installs.length) {
            IJSRuntimeInstall install = installs[j];
            standins.add(new JSRuntimeWorkingCopy(install));
            ++j;
        }
        this.setRuntimeInstalls(standins.toArray(new IJSRuntimeInstall[standins.size()]));
    }

    class RuntimeInstallsContentProvider
    implements IStructuredContentProvider {
        RuntimeInstallsContentProvider() {
        }

        public Object[] getElements(Object input) {
            return InstalledJSRuntimesBlock.this.fRuntimeInstalls.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class RuntimeInstallsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider,
    IColorProvider {
        Font bold = null;

        RuntimeInstallsLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IJSRuntimeInstall) {
                IJSRuntimeInstall runtime = (IJSRuntimeInstall)element;
                switch (columnIndex) {
                    case 0: {
                        if (JSRuntimeManager.isContributedRuntimeInstall(runtime.getId())) {
                            String contributedRuntimeLabel = NLS.bind((String)PreferencesMessages.InstalledJSRuntimesBlock_ContributedRuntime_Label, (Object)runtime.getName());
                            if (InstalledJSRuntimesBlock.this.fRuntimeList.getChecked(element)) {
                                contributedRuntimeLabel = NLS.bind((String)PreferencesMessages.InstalledJSRuntimesBlock_DefaultRuntime_Label, (Object)contributedRuntimeLabel);
                            }
                            return contributedRuntimeLabel;
                        }
                        if (InstalledJSRuntimesBlock.this.fRuntimeList.getChecked(element)) {
                            return NLS.bind((String)PreferencesMessages.InstalledJSRuntimesBlock_DefaultRuntime_Label, (Object)runtime.getName());
                        }
                        return runtime.getName();
                    }
                    case 1: {
                        if (runtime.getInstallLocation().exists()) {
                            return runtime.getInstallLocation().getAbsolutePath();
                        }
                        return NLS.bind((String)PreferencesMessages.JSRuntimes_MissingPath, (Object)runtime.getInstallLocation().getAbsolutePath());
                    }
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return JavaScriptUI.getSharedImages().getImage("org.eclipse.wst.jsdt.ui.library_obj.gif");
            }
            return null;
        }

        public Font getFont(Object element) {
            if (InstalledJSRuntimesBlock.this.fRuntimeList.getChecked(element)) {
                if (this.bold == null) {
                    Font dialogFont = JFaceResources.getDialogFont();
                    FontData[] fontData = dialogFont.getFontData();
                    int i = 0;
                    while (i < fontData.length) {
                        FontData data = fontData[i];
                        data.setStyle(1);
                        ++i;
                    }
                    Display display = SWTUtil.getStandardDisplay();
                    this.bold = new Font((Device)display, fontData);
                }
                return this.bold;
            }
            return null;
        }

        public void dispose() {
            if (this.bold != null) {
                this.bold.dispose();
            }
            super.dispose();
        }

        public Color getForeground(Object element) {
            if (this.isUnmodifiable(element)) {
                Display display = Display.getCurrent();
                return display.getSystemColor(28);
            }
            return null;
        }

        public Color getBackground(Object element) {
            if (this.isUnmodifiable(element)) {
                Display display = Display.getCurrent();
                return display.getSystemColor(29);
            }
            return null;
        }

        boolean isUnmodifiable(Object element) {
            if (element instanceof IJSRuntimeInstall) {
                IJSRuntimeInstall runtime = (IJSRuntimeInstall)element;
                return JSRuntimeManager.isContributedRuntimeInstall(runtime.getId());
            }
            return false;
        }
    }
}

