/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.PackageBrowseAdapter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.SourceFirstPackageSelectionDialogField;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;

public class NLSAccessorConfigurationDialog
extends StatusDialog {
    private SourceFirstPackageSelectionDialogField fResourceBundlePackage;
    private StringButtonDialogField fResourceBundleFile;
    private SourceFirstPackageSelectionDialogField fAccessorPackage;
    private StringDialogField fAccessorClassName;
    private StringDialogField fSubstitutionPattern;
    private NLSRefactoring fRefactoring;
    private IStatus[] fStati;
    private static final int IDX_ACCESSOR_CLASS = 0;
    private static final int IDX_ACCESSOR_PACKAGE = 1;
    private static final int IDX_SUBST_PATTERN = 2;
    private static final int IDX_BUNDLE_NAME = 3;
    private static final int IDX_BUNDLE_PACKAGE = 4;

    public NLSAccessorConfigurationDialog(Shell parent, NLSRefactoring refactoring) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRefactoring = refactoring;
        this.fStati = new IStatus[]{StatusInfo.OK_STATUS, StatusInfo.OK_STATUS, StatusInfo.OK_STATUS, StatusInfo.OK_STATUS, StatusInfo.OK_STATUS};
        this.setTitle(NLSUIMessages.NLSAccessorConfigurationDialog_title);
        AccessorAdapter updateListener = new AccessorAdapter();
        IJavaScriptUnit cu = refactoring.getCu();
        this.fAccessorPackage = new SourceFirstPackageSelectionDialogField(NLSUIMessages.NLSAccessorConfigurationDialog_accessor_path, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_package, NLSUIMessages.NLSAccessorConfigurationDialog_browse1, NLSUIMessages.NLSAccessorConfigurationDialog_browse2, NLSUIMessages.NLSAccessorConfigurationDialog_default_package, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_dialog_title, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_dialog_message, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_dialog_emtpyMessage, cu, updateListener, refactoring.getAccessorClassPackage());
        this.fAccessorClassName = this.createStringButtonField(NLSUIMessages.NLSAccessorConfigurationDialog_className, NLSUIMessages.NLSAccessorConfigurationDialog_browse6, updateListener);
        this.fSubstitutionPattern = this.createStringField(NLSUIMessages.NLSAccessorConfigurationDialog_substitutionPattern, updateListener);
        this.fResourceBundlePackage = new SourceFirstPackageSelectionDialogField(NLSUIMessages.NLSAccessorConfigurationDialog_property_path, NLSUIMessages.NLSAccessorConfigurationDialog_property_package, NLSUIMessages.NLSAccessorConfigurationDialog_browse3, NLSUIMessages.NLSAccessorConfigurationDialog_browse4, NLSUIMessages.NLSAccessorConfigurationDialog_default_package, NLSUIMessages.NLSAccessorConfigurationDialog_property_dialog_title, NLSUIMessages.NLSAccessorConfigurationDialog_property_dialog_message, NLSUIMessages.NLSAccessorConfigurationDialog_property_dialog_emptyMessage, cu, updateListener, this.fRefactoring.getResourceBundlePackage());
        this.fResourceBundleFile = this.createStringButtonField(NLSUIMessages.NLSAccessorConfigurationDialog_property_file_name, NLSUIMessages.NLSAccessorConfigurationDialog_browse5, updateListener);
        this.initFields();
    }

    private void initFields() {
        this.initAccessorClassFields();
        String resourceBundleName = this.fRefactoring.getResourceBundleName();
        this.fResourceBundleFile.setText(resourceBundleName != null ? resourceBundleName : "messages.properties");
    }

    private void initAccessorClassFields() {
        String accessorClassName = this.fRefactoring.getAccessorClassName();
        if (accessorClassName == null) {
            accessorClassName = "Messages";
        }
        this.fAccessorClassName.setText(accessorClassName);
        this.fSubstitutionPattern.setText(this.fRefactoring.getSubstitutionPattern());
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = (Composite)super.createDialogArea(ancestor);
        this.initializeDialogUnits((Control)ancestor);
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 4;
        parent.setLayout((Layout)layout);
        this.createAccessorPart(parent, 4, this.convertWidthInCharsToPixels(40));
        Separator s = new Separator(258);
        s.doFillIntoGrid(parent, 4);
        this.createPropertyPart(parent, 4, this.convertWidthInCharsToPixels(40));
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.jsdt.ui.externalize_wizard_properties_file_page_context");
        this.validateAll();
        return parent;
    }

    private void createAccessorPart(Composite parent, int nOfColumns, int textWidth) {
        this.createLabel(parent, NLSUIMessages.NLSAccessorConfigurationDialog_resourceBundle_title, nOfColumns);
        this.fAccessorPackage.createControl(parent, nOfColumns, textWidth);
        this.fAccessorClassName.doFillIntoGrid(parent, nOfColumns);
        Text accessorClassText = this.fAccessorClassName.getTextControl(null);
        LayoutUtil.setWidthHint((Control)accessorClassText, this.convertWidthInCharsToPixels(60));
        TextFieldNavigationHandler.install(accessorClassText);
        this.fSubstitutionPattern.doFillIntoGrid(parent, nOfColumns);
        Text substitutionPatternText = this.fSubstitutionPattern.getTextControl(null);
        LayoutUtil.setWidthHint((Control)substitutionPatternText, this.convertWidthInCharsToPixels(60));
        TextFieldNavigationHandler.install(substitutionPatternText);
        this.fSubstitutionPattern.setEnabled(!this.fRefactoring.isEclipseNLS());
    }

    private void createPropertyPart(Composite parent, int nOfColumns, int textWidth) {
        this.createLabel(parent, NLSUIMessages.NLSAccessorConfigurationDialog_property_location, nOfColumns);
        this.fResourceBundlePackage.createControl(parent, nOfColumns, textWidth);
        this.fResourceBundleFile.doFillIntoGrid(parent, nOfColumns);
        LayoutUtil.setWidthHint((Control)this.fResourceBundleFile.getTextControl(null), this.convertWidthInCharsToPixels(60));
    }

    private void createLabel(Composite parent, String text, int N_OF_COLUMNS) {
        Separator label = new Separator(0);
        ((Label)label.getSeparator(parent)).setText(text);
        GC gc = new GC((Drawable)parent);
        int height = gc.stringExtent((String)text).y;
        gc.dispose();
        label.doFillIntoGrid(parent, N_OF_COLUMNS, height);
    }

    private void browseForPropertyFile() {
        IFile selectedFile;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaScriptElementLabelProvider());
        dialog.setIgnoreCase(false);
        dialog.setTitle(NLSUIMessages.NLSAccessorConfigurationDialog_Property_File_Selection);
        dialog.setMessage(NLSUIMessages.NLSAccessorConfigurationDialog_Choose_the_property_file);
        dialog.setElements(this.createFileListInput());
        dialog.setFilter("*.properties");
        if (dialog.open() == 0 && (selectedFile = (IFile)dialog.getFirstResult()) != null) {
            this.fResourceBundleFile.setText(selectedFile.getName());
        }
    }

    protected void browseForAccessorClass() {
        IType selectedType;
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        IPackageFragmentRoot root = this.fAccessorPackage.getSelectedFragmentRoot();
        IJavaScriptSearchScope scope = root != null ? SearchEngine.createJavaSearchScope(new IJavaScriptElement[]{root}) : SearchEngine.createWorkspaceScope();
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)service, scope, 5);
        dialog.setTitle(NLSUIMessages.NLSAccessorConfigurationDialog_Accessor_Selection);
        dialog.setMessage(NLSUIMessages.NLSAccessorConfigurationDialog_Choose_the_accessor_file);
        dialog.setInitialPattern("*Messages");
        if (dialog.open() == 0 && (selectedType = (IType)dialog.getFirstResult()) != null) {
            this.fAccessorClassName.setText(selectedType.getElementName());
            this.fAccessorPackage.setSelected(selectedType.getPackageFragment());
        }
    }

    private Object[] createFileListInput() {
        try {
            IPackageFragment fPkgFragment = this.fResourceBundlePackage.getSelected();
            if (fPkgFragment == null) {
                return new Object[0];
            }
            ArrayList<Object> result = new ArrayList<Object>(1);
            Object[] nonjava = fPkgFragment.getNonJavaScriptResources();
            int i = 0;
            while (i < nonjava.length) {
                if (NLSAccessorConfigurationDialog.isPropertyFile(nonjava[i])) {
                    result.add(nonjava[i]);
                }
                ++i;
            }
            return result.toArray();
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle(e, NLSUIMessages.NLSAccessorConfigurationDialog_externalizing, NLSUIMessages.NLSAccessorConfigurationDialog_exception);
            return new Object[0];
        }
    }

    private static boolean isPropertyFile(Object o) {
        if (!(o instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)o;
        return ".properties".equals(String.valueOf('.') + file.getFileExtension());
    }

    private void validateAll() {
        this.validateSubstitutionPattern();
        this.validateAccessorClassName();
        this.checkPackageFragment();
        this.validatePropertyFilename();
        this.validatePropertyPackage();
        this.updateStatus(StatusUtil.getMostSevere(this.fStati));
    }

    private void validateAccessorClassName() {
        String className = this.fAccessorClassName.getText();
        IStatus status = JavaScriptConventions.validateJavaScriptTypeName(className);
        if (status.getSeverity() == 4) {
            this.setInvalid(0, status.getMessage());
            return;
        }
        if (className.indexOf(46) != -1) {
            this.setInvalid(0, NLSUIMessages.NLSAccessorConfigurationDialog_no_dot);
            return;
        }
        this.setValid(0);
    }

    private void validatePropertyFilename() {
        String fileName = this.fResourceBundleFile.getText();
        if (fileName == null || fileName.length() == 0) {
            this.setInvalid(3, NLSUIMessages.NLSAccessorConfigurationDialog_enter_name);
            return;
        }
        if (!fileName.endsWith(".properties")) {
            this.setInvalid(3, Messages.format(NLSUIMessages.NLSAccessorConfigurationDialog_file_name_must_end, ".properties"));
            return;
        }
        this.setValid(3);
    }

    private void validatePropertyPackage() {
        IPackageFragmentRoot root = this.fResourceBundlePackage.getSelectedFragmentRoot();
        if (root == null || !root.exists()) {
            this.setInvalid(4, NLSUIMessages.NLSAccessorConfigurationDialog_property_package_root_invalid);
            return;
        }
        IPackageFragment fragment = this.fResourceBundlePackage.getSelected();
        if (fragment == null || !fragment.exists()) {
            this.setInvalid(4, NLSUIMessages.NLSAccessorConfigurationDialog_property_package_invalid);
            return;
        }
        String pkgName = fragment.getElementName();
        IStatus status = JavaScriptConventions.validatePackageName(pkgName);
        if (pkgName.length() > 0 && status.getSeverity() == 4) {
            this.setInvalid(4, status.getMessage());
            return;
        }
        IPath pkgPath = new Path(pkgName.replace('.', '/')).makeRelative();
        IJavaScriptProject project = this.fRefactoring.getCu().getJavaScriptProject();
        try {
            IJavaScriptElement element = project.findElement(pkgPath);
            if (element == null || !element.exists()) {
                this.setInvalid(4, NLSUIMessages.NLSAccessorConfigurationDialog_must_exist);
                return;
            }
            IPackageFragment fPkgFragment = (IPackageFragment)element;
            if (!PackageBrowseAdapter.canAddPackage(fPkgFragment)) {
                this.setInvalid(4, NLSUIMessages.NLSAccessorConfigurationDialog_incorrect_package);
                return;
            }
            if (!PackageBrowseAdapter.canAddPackageRoot((IPackageFragmentRoot)fPkgFragment.getParent())) {
                this.setInvalid(4, NLSUIMessages.NLSAccessorConfigurationDialog_incorrect_package);
                return;
            }
        }
        catch (JavaScriptModelException e) {
            this.setInvalid(4, e.getStatus().getMessage());
            return;
        }
        this.setValid(4);
    }

    private void checkPackageFragment() {
        IPackageFragmentRoot root = this.fAccessorPackage.getSelectedFragmentRoot();
        if (root == null || !root.exists()) {
            this.setInvalid(1, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_package_root_invalid);
            return;
        }
        IPackageFragment fragment = this.fAccessorPackage.getSelected();
        if (fragment == null || !fragment.exists()) {
            this.setInvalid(1, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_package_invalid);
            return;
        }
        this.setValid(1);
    }

    private void validateSubstitutionPattern() {
        if (this.fSubstitutionPattern.getText() == null || this.fSubstitutionPattern.getText().length() == 0) {
            this.setInvalid(2, NLSUIMessages.NLSAccessorConfigurationDialog_substitution_pattern_missing);
        } else {
            this.setValid(2);
        }
    }

    private void setInvalid(int idx, String msg) {
        this.fStati[idx] = new StatusInfo(4, msg);
    }

    private void setValid(int idx) {
        this.fStati[idx] = StatusInfo.OK_STATUS;
    }

    protected void okPressed() {
        this.updateRefactoring();
        super.okPressed();
    }

    void updateRefactoring() {
        this.fRefactoring.setAccessorClassPackage(this.fAccessorPackage.getSelected());
        this.fRefactoring.setAccessorClassName(this.fAccessorClassName.getText());
        this.fRefactoring.setResourceBundleName(this.fResourceBundleFile.getText());
        this.fRefactoring.setResourceBundlePackage(this.fResourceBundlePackage.getSelected());
        if (!this.fRefactoring.isEclipseNLS()) {
            this.fRefactoring.setSubstitutionPattern(this.fSubstitutionPattern.getText());
        }
        this.fRefactoring.setIsEclipseNLS(this.fRefactoring.detectIsEclipseNLS());
    }

    private StringDialogField createStringField(String label, AccessorAdapter updateListener) {
        StringDialogField field = new StringDialogField();
        field.setDialogFieldListener(updateListener);
        field.setLabelText(label);
        return field;
    }

    private StringButtonDialogField createStringButtonField(String label, String button, AccessorAdapter adapter) {
        StringButtonDialogField field = new StringButtonDialogField(adapter);
        field.setDialogFieldListener(adapter);
        field.setLabelText(label);
        field.setButtonLabel(button);
        return field;
    }

    private class AccessorAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private AccessorAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NLSAccessorConfigurationDialog.this.validateAll();
        }

        @Override
        public void changeControlPressed(DialogField field) {
            if (field == NLSAccessorConfigurationDialog.this.fResourceBundleFile) {
                NLSAccessorConfigurationDialog.this.browseForPropertyFile();
            } else if (field == NLSAccessorConfigurationDialog.this.fAccessorClassName) {
                NLSAccessorConfigurationDialog.this.browseForAccessorClass();
            }
        }
    }
}

