/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.javadoc;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public class JavaDocAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private final String fPartitioning;

    public JavaDocAutoIndentStrategy(String partitioning) {
        this.fPartitioning = partitioning;
    }

    private void indentAfterNewLine(IDocument d, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            Assert.isTrue((firstNonWS >= lineOffset ? 1 : 0) != 0, (String)"indentation must not be negative");
            StringBuffer buf = new StringBuffer(c.text);
            IRegion prefix = this.findPrefixRange(d, line);
            String indentation = d.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            if (firstNonWS < offset && d.getChar(firstNonWS) == '/' && d.getChar(firstNonWS + 1) != '/') {
                buf.append(" * ");
                if (this.isPreferenceTrue("closeJavaDocs") && this.isNewComment(d, offset)) {
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + buf.length();
                    String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
                    String endTag = String.valueOf(lineDelimiter) + indentation + " */";
                    if (this.isPreferenceTrue("addJavaDocTags")) {
                        d.replace(offset, 0, endTag);
                        IJavaScriptUnit unit = JavaDocAutoIndentStrategy.getCompilationUnit();
                        if (unit != null) {
                            try {
                                JavaModelUtil.reconcile(unit);
                                String string = this.createJavaDocTags(d, c, indentation, lineDelimiter, unit);
                                if (string != null && !string.trim().equals("*")) {
                                    buf.append(string);
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                    } else {
                        buf.append(endTag);
                    }
                }
            }
            if (lengthToAdd < prefix.getLength()) {
                c.caretOffset = offset + prefix.getLength() - lengthToAdd;
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isPreferenceTrue(String preference) {
        return JavaScriptPlugin.getDefault().getPreferenceStore().getBoolean(preference);
    }

    private IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = this.findEndOfWhiteSpace(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd && document.getChar(indentEnd) == '*') {
            ++indentEnd;
            while (indentEnd < lineEnd && document.getChar(indentEnd) == ' ') {
                ++indentEnd;
            }
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }

    private String createJavaDocTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, IJavaScriptUnit unit) throws CoreException, BadLocationException {
        IJavaScriptElement element = unit.getElementAt(command.offset);
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 7: {
                return this.createTypeTags(document, command, indentation, lineDelimiter, (IType)element);
            }
            case 9: {
                return this.createMethodTags(document, command, indentation, lineDelimiter, (IFunction)element);
            }
        }
        return null;
    }

    private String prepareTemplateComment(String comment, String indentation, IJavaScriptProject project, String lineDelimiter) {
        if (comment.endsWith("*/")) {
            comment = comment.substring(0, comment.length() - 2);
        }
        if ((comment = comment.trim()).startsWith("/*")) {
            comment = comment.length() > 2 && comment.charAt(2) == '*' ? comment.substring(3) : comment.substring(2);
        }
        int nonSpace = 0;
        int len = comment.length();
        while (nonSpace < len && Character.getType(comment.charAt(nonSpace)) == 12) {
            ++nonSpace;
        }
        comment = comment.substring(nonSpace);
        return Strings.changeIndent(comment, 0, project, indentation, lineDelimiter);
    }

    private String createTypeTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, IType type) throws CoreException, BadLocationException {
        String comment = CodeGeneration.getTypeComment(type.getJavaScriptUnit(), type.getTypeQualifiedName('.'), lineDelimiter);
        if (comment != null) {
            boolean javadocComment = comment.startsWith("/**");
            if (!this.isFirstComment(document, command, type, javadocComment)) {
                return null;
            }
            return this.prepareTemplateComment(comment.trim(), indentation, type.getJavaScriptProject(), lineDelimiter);
        }
        return null;
    }

    private String createMethodTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, IFunction method) throws CoreException, BadLocationException {
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)command.offset, (boolean)false);
        IFunction inheritedMethod = JavaDocAutoIndentStrategy.getInheritedMethod(method);
        String comment = CodeGeneration.getMethodComment(method, inheritedMethod, lineDelimiter);
        if (comment != null) {
            boolean isJavaDoc;
            boolean javadocComment = (comment = comment.trim()).startsWith("/**");
            if (!this.isFirstComment(document, command, method, javadocComment)) {
                return null;
            }
            boolean bl = isJavaDoc = partition.getLength() >= 3 && document.get(partition.getOffset(), 3).equals("/**");
            if (javadocComment == isJavaDoc) {
                return this.prepareTemplateComment(comment, indentation, method.getJavaScriptProject(), lineDelimiter);
            }
        }
        return null;
    }

    private boolean isFirstComment(IDocument document, DocumentCommand command, IMember member, boolean ignoreNonJavadoc) throws BadLocationException, JavaScriptModelException {
        String token;
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)command.offset, (boolean)false);
        ISourceRange sourceRange = member.getSourceRange();
        if (sourceRange == null || sourceRange.getOffset() != partition.getOffset()) {
            return false;
        }
        int srcOffset = sourceRange.getOffset();
        int srcLength = sourceRange.getLength();
        int nameRelativeOffset = member.getNameRange().getOffset() - srcOffset;
        int partitionRelativeOffset = partition.getOffset() - srcOffset;
        String string = token = ignoreNonJavadoc ? "/**" : "/*";
        return document.get(srcOffset, srcLength).lastIndexOf(token, nameRelativeOffset) == partitionRelativeOffset;
    }

    private void indentAfterCommentEnd(IDocument d, DocumentCommand c) {
        if (c.offset < 2 || d.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(d.get(c.offset - 2, 2))) {
                ++c.length;
                --c.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isNewComment(IDocument document, int commandOffset) {
        ITypedRegion partition;
        block7: {
            int partitionEnd;
            block6: {
                int lineIndex;
                block5: {
                    try {
                        lineIndex = document.getLineOfOffset(commandOffset) + 1;
                        if (lineIndex < document.getNumberOfLines()) break block5;
                        return true;
                    }
                    catch (BadLocationException badLocationException) {
                        return false;
                    }
                }
                IRegion line = document.getLineInformation(lineIndex);
                partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)commandOffset, (boolean)false);
                partitionEnd = partition.getOffset() + partition.getLength();
                if (line.getOffset() < partitionEnd) break block6;
                return false;
            }
            if (document.getLength() != partitionEnd) break block7;
            return true;
        }
        String comment = document.get(partition.getOffset(), partition.getLength());
        return comment.indexOf("/*", 2) != -1;
    }

    private boolean isSmartMode() {
        IEditorPart part;
        IWorkbenchPage page = JavaScriptPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 extension = (ITextEditorExtension3)part;
            return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.isSmartMode()) {
            return;
        }
        if (command.text != null) {
            String[] lineDelimiters;
            int index;
            if (command.length == 0 && (index = TextUtilities.endsWith((String[])(lineDelimiters = document.getLegalLineDelimiters()), (String)command.text)) > -1) {
                if (lineDelimiters[index].equals(command.text)) {
                    this.indentAfterNewLine(document, command);
                }
                return;
            }
            if (command.text.equals("/")) {
                this.indentAfterCommentEnd(document, command);
                return;
            }
        }
    }

    private static IFunction getInheritedMethod(IFunction method) throws JavaScriptModelException {
        IType declaringType = method.getDeclaringType();
        if (declaringType == null) {
            return null;
        }
        MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(declaringType);
        return tester.findOverriddenMethod(method, true);
    }

    private static IJavaScriptUnit getCompilationUnit() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        WorkingCopyManager manager = JavaScriptPlugin.getDefault().getWorkingCopyManager();
        IJavaScriptUnit unit = manager.getWorkingCopy(editor.getEditorInput());
        if (unit == null) {
            return null;
        }
        return unit;
    }
}

