/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

class NewJSFileWizardPage
extends WizardNewFileCreationPage {
    private IContentType[] fContentTypes;
    private Set<String> fValidExtensions = null;

    public NewJSFileWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    protected void initialPopulateContainerNameField() {
        super.initialPopulateContainerNameField();
        IPath fullPath = this.getContainerFullPath();
        if (fullPath != null && fullPath.segmentCount() > 0) {
            IProject project = this.getProjectFromPath(fullPath);
            IPath sourcePath = this.getSourcePath(project);
            IPath projectPath = project.getFullPath();
            if (projectPath.equals((Object)fullPath)) {
                this.setContainerFullPath(sourcePath);
            } else {
                this.setContainerFullPath(fullPath);
            }
        }
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (!super.validatePage()) {
            return false;
        }
        String fileName = this.getFileName();
        IPath fullPath = this.getContainerFullPath();
        if (fullPath != null && !fullPath.isEmpty() && fileName != null) {
            IProject project;
            if (!this.extensionValidForContentType(fileName)) {
                this.setErrorMessage(NLS.bind((String)NewWizardMessages.Javascript_Error_Filename_Must_End_JS, (Object)this.getValidExtensions().toString()));
                return false;
            }
            if (fileName.lastIndexOf(46) == -1) {
                String newFileName = this.addDefaultExtension(fileName);
                IPath resourcePath = fullPath.append(newFileName);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus result = workspace.validatePath(resourcePath.toString(), 2);
                if (!result.isOK()) {
                    this.setErrorMessage(result.getMessage());
                    return false;
                }
                if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                    this.setErrorMessage(NewWizardMessages.Javascript_Resource_Group_Name_Exists);
                    return false;
                }
            }
            if ((project = this.getProjectFromPath(fullPath)) != null && this.isJSProject(project)) {
                IPath sourcePath = this.getSourcePath(project);
                if (sourcePath == null) {
                    this.setErrorMessage(NLS.bind((String)NewWizardMessages.Javascript_Error_Source_Folder_Is_Not_Configured, (Object)project.getName()));
                    return false;
                }
                if (!sourcePath.isPrefixOf(fullPath)) {
                    this.setMessage(NewWizardMessages.Javascript_Warning_Folder_Must_Be_Inside_Web_Content, 2);
                }
            }
        }
        return true;
    }

    private IContentType[] getContentTypes() {
        if (this.fContentTypes == null) {
            this.fContentTypes = Platform.getContentTypeManager().findContentTypesFor("filename.js");
        }
        return this.fContentTypes;
    }

    private Collection<String> getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType[] types = this.getContentTypes();
            this.fValidExtensions = new HashSet<String>();
            int i = 0;
            while (i < types.length) {
                this.fValidExtensions.addAll(Arrays.asList(types[i].getFileSpecs(8)));
                ++i;
            }
        }
        return this.fValidExtensions;
    }

    private boolean extensionValidForContentType(String fileName) {
        boolean valid = false;
        IContentType[] expectedTypes = this.getContentTypes();
        if (fileName.lastIndexOf(46) != -1) {
            IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileName);
            int i = 0;
            while (i < types.length && !valid) {
                int j = 0;
                while (j < expectedTypes.length && !valid) {
                    valid |= types[i].isKindOf(expectedTypes[j]);
                    ++j;
                }
                ++i;
            }
        } else {
            valid = true;
        }
        return valid;
    }

    String addDefaultExtension(String filename) {
        StringBuffer newFileName = new StringBuffer(filename);
        newFileName.append(".");
        newFileName.append("js");
        return newFileName.toString();
    }

    private IProject getProjectFromPath(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = null;
        if (path != null) {
            project = workspace.validatePath(path.toString(), 4).isOK() ? workspace.getRoot().getProject(path.toString()) : workspace.getRoot().getFile(path).getProject();
        }
        return project;
    }

    private boolean isJSProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.wst.jsdt.core.jsNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private IPath getSourcePath(IProject project) {
        IPath path = null;
        if (project != null && this.isJSProject(project)) {
            IJavaScriptProject p = JavaScriptCore.create(project);
            try {
                IIncludePathEntry[] includepath = p.getResolvedIncludepath(true);
                int i = 0;
                while (i < includepath.length) {
                    if (includepath[i].getEntryKind() == 3) {
                        return includepath[i].getPath();
                    }
                    ++i;
                }
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    public void addFileComment(IFile file) {
        this.addFileComment(file, true);
    }

    public void addFileComment(IFile file, boolean overwrite) {
        IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom(file);
        try {
            cu.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IBuffer buffer = cu.getBuffer();
            if (overwrite || buffer.getLength() == 0) {
                buffer.setContents(CodeGeneration.getFileComment(cu, StubUtility.getLineDelimiterUsed(cu)));
                cu.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
            }
            cu.discardWorkingCopy();
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
    }
}

