/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;

public class BuildPathSupport {
    public static final String JRE_PREF_PAGE_ID = "org.eclipse.wst.jsdt.debug.ui.preferences.VMPreferencePage";

    private BuildPathSupport() {
    }

    public static String getDeprecationMessage(String variableName) {
        String deprecationMessage = JavaScriptCore.getIncludepathVariableDeprecationMessage(variableName);
        if (deprecationMessage == null) {
            return null;
        }
        return Messages.format(NewWizardMessages.BuildPathSupport_deprecated, new Object[]{variableName, deprecationMessage});
    }

    public static IPath guessSourceAttachment(CPListElement elem) {
        if (elem.getEntryKind() == 5) {
            return null;
        }
        IJavaScriptProject currProject = elem.getJavaProject();
        try {
            IJavaScriptModel jmodel = JavaScriptCore.create(ResourcesPlugin.getWorkspace().getRoot());
            IJavaScriptProject[] jprojects = jmodel.getJavaScriptProjects();
            int i = 0;
            while (i < jprojects.length) {
                IJavaScriptProject curr = jprojects[i];
                if (!curr.equals(currProject)) {
                    IIncludePathEntry[] entries = curr.getRawIncludepath();
                    int k = 0;
                    while (k < entries.length) {
                        IPath attachPath;
                        IIncludePathEntry entry = entries[k];
                        if (entry.getEntryKind() == elem.getEntryKind() && entry.getPath().equals((Object)elem.getPath()) && (attachPath = entry.getSourceAttachmentPath()) != null && !attachPath.isEmpty()) {
                            return attachPath;
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e.getStatus());
        }
        return null;
    }

    public static String guessJavadocLocation(CPListElement elem) {
        if (elem.getEntryKind() == 5) {
            return null;
        }
        IJavaScriptProject currProject = elem.getJavaProject();
        try {
            IJavaScriptModel jmodel = JavaScriptCore.create(ResourcesPlugin.getWorkspace().getRoot());
            IJavaScriptProject[] jprojects = jmodel.getJavaScriptProjects();
            int i = 0;
            while (i < jprojects.length) {
                IJavaScriptProject curr = jprojects[i];
                if (!curr.equals(currProject)) {
                    IIncludePathEntry[] entries = curr.getRawIncludepath();
                    int k = 0;
                    while (k < entries.length) {
                        IIncludePathEntry entry = entries[k];
                        if (entry.getEntryKind() == elem.getEntryKind() && entry.getPath().equals((Object)elem.getPath())) {
                            IIncludePathAttribute[] attributes = entry.getExtraAttributes();
                            int n = 0;
                            while (n < attributes.length) {
                                IIncludePathAttribute attrib = attributes[n];
                                if ("javadoc_location".equals(attrib.getName())) {
                                    return attrib.getValue();
                                }
                                ++n;
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e.getStatus());
        }
        return null;
    }

    public static void modifyClasspathEntry(Shell shell, IIncludePathEntry newEntry, String[] changedAttributes, IJavaScriptProject jproject, IPath containerPath, IProgressMonitor monitor) throws CoreException {
        if (containerPath != null) {
            BuildPathSupport.updateContainerClasspath(jproject, containerPath, newEntry, changedAttributes, monitor);
        } else {
            BuildPathSupport.updateProjectClasspath(shell, jproject, newEntry, changedAttributes, monitor);
        }
    }

    public static void modifyClasspathEntry(Shell shell, IIncludePathEntry newEntry, IJavaScriptProject jproject, IPath containerPath, IProgressMonitor monitor) throws CoreException {
        BuildPathSupport.modifyClasspathEntry(shell, newEntry, null, jproject, containerPath, monitor);
    }

    private static void updateContainerClasspath(IJavaScriptProject jproject, IPath containerPath, IIncludePathEntry newEntry, String[] changedAttributes, IProgressMonitor monitor) throws CoreException {
        IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer(containerPath, jproject);
        if (container == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, "Container " + containerPath + " cannot be resolved", null));
        }
        IIncludePathEntry[] entries = container.getIncludepathEntries();
        IIncludePathEntry[] newEntries = new IIncludePathEntry[entries.length];
        int i = 0;
        while (i < entries.length) {
            IIncludePathEntry curr = entries[i];
            newEntries[i] = curr.getEntryKind() == newEntry.getEntryKind() && curr.getPath().equals((Object)newEntry.getPath()) ? BuildPathSupport.getUpdatedEntry(curr, newEntry, changedAttributes, jproject) : curr;
            ++i;
        }
        BuildPathSupport.requestContainerUpdate(jproject, container, newEntries);
        monitor.worked(1);
    }

    private static IIncludePathEntry getUpdatedEntry(IIncludePathEntry currEntry, IIncludePathEntry updatedEntry, String[] updatedAttributes, IJavaScriptProject jproject) {
        if (updatedAttributes == null) {
            return updatedEntry;
        }
        CPListElement currElem = CPListElement.createFromExisting(currEntry, jproject);
        CPListElement newElem = CPListElement.createFromExisting(updatedEntry, jproject);
        int i = 0;
        while (i < updatedAttributes.length) {
            String attrib = updatedAttributes[i];
            currElem.setAttribute(attrib, newElem.getAttribute(attrib));
            ++i;
        }
        return currElem.getClasspathEntry();
    }

    public static void requestContainerUpdate(IJavaScriptProject jproject, IJsGlobalScopeContainer container, IIncludePathEntry[] newEntries) throws CoreException {
        IPath containerPath = container.getPath();
        UpdatedJsGlobalScopeContainer updatedContainer = new UpdatedJsGlobalScopeContainer(container, newEntries);
        JsGlobalScopeContainerInitializer initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer(containerPath.segment(0));
        if (initializer != null) {
            initializer.requestJsGlobalScopeContainerUpdate(containerPath, jproject, updatedContainer);
        }
    }

    private static void updateProjectClasspath(Shell shell, IJavaScriptProject jproject, IIncludePathEntry newEntry, String[] changedAttributes, IProgressMonitor monitor) throws JavaScriptModelException {
        IIncludePathEntry[] oldClasspath = jproject.getRawIncludepath();
        int nEntries = oldClasspath.length;
        ArrayList<IIncludePathEntry> newEntries = new ArrayList<IIncludePathEntry>(nEntries + 1);
        int entryKind = newEntry.getEntryKind();
        IPath jarPath = newEntry.getPath();
        boolean found = false;
        int i = 0;
        while (i < nEntries) {
            IIncludePathEntry curr = oldClasspath[i];
            if (curr.getEntryKind() == entryKind && curr.getPath().equals((Object)jarPath)) {
                newEntries.add(BuildPathSupport.getUpdatedEntry(curr, newEntry, changedAttributes, jproject));
                found = true;
            } else {
                newEntries.add(curr);
            }
            ++i;
        }
        if (!found) {
            if (!BuildPathSupport.putJarOnClasspathDialog(shell)) {
                return;
            }
            newEntries.add(newEntry);
        }
        IIncludePathEntry[] newClasspath = newEntries.toArray(new IIncludePathEntry[newEntries.size()]);
        jproject.setRawIncludepath(newClasspath, monitor);
    }

    private static boolean putJarOnClasspathDialog(final Shell shell) {
        if (shell == null) {
            return false;
        }
        final boolean[] result = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String title = NewWizardMessages.BuildPathSupport_putoncpdialog_title;
                String message = NewWizardMessages.BuildPathSupport_putoncpdialog_message;
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
            }
        });
        return result[0];
    }

    private static class UpdatedJsGlobalScopeContainer
    implements IJsGlobalScopeContainer {
        private IIncludePathEntry[] fNewEntries;
        private IJsGlobalScopeContainer fOriginal;

        public UpdatedJsGlobalScopeContainer(IJsGlobalScopeContainer original, IIncludePathEntry[] newEntries) {
            this.fNewEntries = newEntries;
            this.fOriginal = original;
        }

        public IIncludePathEntry[] getClasspathEntries() {
            return this.getIncludepathEntries();
        }

        @Override
        public IIncludePathEntry[] getIncludepathEntries() {
            return this.fNewEntries;
        }

        @Override
        public String getDescription() {
            return this.fOriginal.getDescription();
        }

        @Override
        public int getKind() {
            return this.fOriginal.getKind();
        }

        @Override
        public IPath getPath() {
            return this.fOriginal.getPath();
        }

        @Override
        public String[] resolvedLibraryImport(String a) {
            return null;
        }
    }
}

