/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;

public class JavaWorkingSetUpdater
implements IWorkingSetUpdater,
IElementChangedListener {
    public static final String ID = "org.eclipse.wst.jsdt.ui.JavaWorkingSetPage";
    private List fWorkingSets = new ArrayList();

    public JavaWorkingSetUpdater() {
        JavaScriptCore.addElementChangedListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IWorkingSet workingSet) {
        this.checkElementExistence(workingSet);
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.add(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IWorkingSet workingSet) {
        boolean result;
        List list = this.fWorkingSets;
        synchronized (list) {
            result = this.fWorkingSets.remove(workingSet);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IWorkingSet workingSet) {
        List list = this.fWorkingSets;
        synchronized (list) {
            return this.fWorkingSets.contains(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.clear();
        }
        JavaScriptCore.removeElementChangedListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void elementChanged(ElementChangedEvent event) {
        IWorkingSet[] workingSets;
        List list = this.fWorkingSets;
        synchronized (list) {
            workingSets = this.fWorkingSets.toArray(new IWorkingSet[this.fWorkingSets.size()]);
        }
        int w = 0;
        while (w < workingSets.length) {
            WorkingSetDelta workingSetDelta = new WorkingSetDelta(workingSets[w]);
            this.processJavaDelta(workingSetDelta, event.getDelta());
            IResourceDelta[] resourceDeltas = event.getDelta().getResourceDeltas();
            if (resourceDeltas != null) {
                int r = 0;
                while (r < resourceDeltas.length) {
                    this.processResourceDelta(workingSetDelta, resourceDeltas[r]);
                    ++r;
                }
            }
            workingSetDelta.process();
            ++w;
        }
    }

    private void processJavaDelta(WorkingSetDelta result, IJavaScriptElementDelta delta) {
        IResourceDelta[] resourceDeltas;
        IJavaScriptElement jElement = delta.getElement();
        int index = result.indexOf(jElement);
        int type = jElement.getElementType();
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (type == 2 && kind == 4) {
            if (index != -1 && (flags & 0x400) != 0) {
                result.set(index, ((IJavaScriptProject)jElement).getProject());
            } else if ((flags & 0x200) != 0 && (index = result.indexOf(((IJavaScriptProject)jElement).getProject())) != -1) {
                result.set(index, jElement);
            }
        }
        if (index != -1 && kind == 2) {
            if ((flags & 0x20) != 0) {
                result.set(index, delta.getMovedToElement());
            } else {
                result.remove(index);
            }
        }
        if ((resourceDeltas = delta.getResourceDeltas()) != null) {
            int i = 0;
            while (i < resourceDeltas.length) {
                this.processResourceDelta(result, resourceDeltas[i]);
                ++i;
            }
        }
        IJavaScriptElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processJavaDelta(result, children[i]);
            ++i;
        }
    }

    private void processResourceDelta(WorkingSetDelta result, IResourceDelta delta) {
        IResource resource = delta.getResource();
        int type = resource.getType();
        int index = result.indexOf(resource);
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (kind == 4 && type == 4 && index != -1 && (flags & 0x4000) != 0) {
            result.set(index, resource);
        }
        if (index != -1 && kind == 2) {
            if ((flags & 0x2000) != 0) {
                result.set(index, ResourcesPlugin.getWorkspace().getRoot().findMember(delta.getMovedToPath()));
            } else {
                result.remove(index);
            }
        }
        if (this.projectGotClosedOrOpened(resource, kind, flags)) {
            return;
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processResourceDelta(result, children[i]);
            ++i;
        }
    }

    private boolean projectGotClosedOrOpened(IResource resource, int kind, int flags) {
        return resource.getType() == 4 && kind == 4 && (flags & 0x4000) != 0;
    }

    private void checkElementExistence(IWorkingSet workingSet) {
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        boolean changed = false;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IProject project;
            IAdaptable element = (IAdaptable)iter.next();
            boolean remove = false;
            if (element instanceof IJavaScriptElement) {
                IJavaScriptElement jElement = (IJavaScriptElement)element;
                remove = jElement instanceof IJavaScriptProject ? !jElement.exists() : (project = jElement.getJavaScriptProject().getProject()).isOpen() && !jElement.exists();
            } else if (element instanceof IResource) {
                IResource resource = (IResource)element;
                if (resource instanceof IProject) {
                    remove = !resource.exists();
                } else {
                    project = resource.getProject();
                    boolean bl = remove = (project == null || project.isOpen()) && !resource.exists();
                }
            }
            if (!remove) continue;
            iter.remove();
            changed = true;
        }
        if (changed) {
            workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    private static class WorkingSetDelta {
        private IWorkingSet fWorkingSet;
        private List fElements;
        private boolean fChanged;

        public WorkingSetDelta(IWorkingSet workingSet) {
            this.fWorkingSet = workingSet;
            this.fElements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        }

        public int indexOf(Object element) {
            return this.fElements.indexOf(element);
        }

        public void set(int index, Object element) {
            this.fElements.set(index, element);
            this.fChanged = true;
        }

        public void remove(int index) {
            if (this.fElements.remove(index) != null) {
                this.fChanged = true;
            }
        }

        public void process() {
            if (this.fChanged) {
                this.fWorkingSet.setElements(this.fElements.toArray(new IAdaptable[this.fElements.size()]));
            }
        }
    }
}

