/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.packageview.NamespaceGroup;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.wst.jsdt.ui.ProjectLibraryRoot;

public class JavaScriptElementComparator
extends ViewerComparator {
    private static final int PROJECTS = 1;
    private static final int PACKAGEFRAGMENTROOTS = 2;
    private static final int PACKAGEFRAGMENT = 3;
    private static final int JAVASCRIPTUNITS = 4;
    private static final int CLASSFILES = 5;
    private static final int RESOURCEFOLDERS = 7;
    private static final int RESOURCES = 8;
    private static final int IMPORT_CONTAINER = 11;
    private static final int IMPORT_DECLARATION = 12;
    private static final int EXPORT_CONTAINER = 13;
    private static final int EXPORT_DECLARATION = 14;
    private static final int MEMBERSOFFSET = 15;
    private static final int JAVAELEMENTS = 50;
    private static final int OTHERS = 51;
    private MembersOrderPreferenceCache fMemberOrderCache = JavaScriptPlugin.getDefault().getMemberOrderPreferenceCache();

    public JavaScriptElementComparator() {
        super(null);
    }

    public int category(Object element) {
        if (element instanceof IJavaScriptElement) {
            block30: {
                try {
                    IJavaScriptElement je = (IJavaScriptElement)element;
                    switch (je.getElementType()) {
                        case 9: {
                            IFunction method = (IFunction)je;
                            if (method.isConstructor()) {
                                return this.getMemberCategory(1);
                            }
                            int flags = method.getFlags();
                            if (Flags.isStatic(flags)) {
                                return this.getMemberCategory(7);
                            }
                            return this.getMemberCategory(2);
                        }
                        case 8: {
                            int flags = ((IField)je).getFlags();
                            if (Flags.isStatic(flags)) {
                                return this.getMemberCategory(5);
                            }
                            return this.getMemberCategory(3);
                        }
                        case 10: {
                            int flags = ((IInitializer)je).getFlags();
                            if (Flags.isStatic(flags)) {
                                return this.getMemberCategory(6);
                            }
                            return this.getMemberCategory(4);
                        }
                        case 7: {
                            return this.getMemberCategory(0);
                        }
                        case 12: {
                            return 11;
                        }
                        case 13: {
                            return 12;
                        }
                        case 15: {
                            return 13;
                        }
                        case 16: {
                            return 14;
                        }
                        case 4: {
                            return 3;
                        }
                        case 3: {
                            return 2;
                        }
                        case 2: {
                            return 1;
                        }
                        case 6: {
                            return 5;
                        }
                        case 5: {
                            return 8;
                        }
                    }
                }
                catch (JavaScriptModelException e) {
                    if (e.isDoesNotExist()) break block30;
                    JavaScriptPlugin.log((Throwable)((Object)e));
                }
            }
            return 50;
        }
        if (element instanceof IFile) {
            return 8;
        }
        if (element instanceof IProject) {
            return 1;
        }
        if (element instanceof IContainer) {
            return 7;
        }
        if (element instanceof IJarEntryResource) {
            if (((IJarEntryResource)element).isFile()) {
                return 8;
            }
            return 7;
        }
        if (element instanceof PackageFragmentRootContainer) {
            return 2;
        }
        if (element instanceof ProjectLibraryRoot) {
            return 1;
        }
        if (element instanceof NamespaceGroup) {
            return 1;
        }
        return 51;
    }

    private int getMemberCategory(int kind) {
        int offset = this.fMemberOrderCache.getCategoryIndex(kind);
        return offset + 15;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cmp;
        String name2;
        String name1;
        int cat2;
        int cat1 = this.category(e1);
        if (this.needsClasspathComparision(e1, cat1, e2, cat2 = this.category(e2))) {
            int p2;
            int p1;
            IPackageFragmentRoot root1 = this.getPackageFragmentRoot(e1);
            IPackageFragmentRoot root2 = this.getPackageFragmentRoot(e2);
            if (root1 == null) {
                if (root2 == null) {
                    return 0;
                }
                return 1;
            }
            if (root2 == null) {
                return -1;
            }
            if (!root1.getPath().equals((Object)root2.getPath()) && (p1 = this.getClassPathIndex(root1)) != (p2 = this.getClassPathIndex(root2))) {
                return p1 - p2;
            }
        }
        if (cat1 != cat2) {
            return cat1 - cat2;
        }
        if (cat1 == 1 || cat1 == 8 || cat1 == 7 || cat1 == 51) {
            name1 = this.getNonJavaElementLabel(viewer, e1);
            name2 = this.getNonJavaElementLabel(viewer, e2);
            if (name1 != null && name2 != null) {
                return this.getComparator().compare(name1, name2);
            }
            return 0;
        }
        if (e1 instanceof IMember && e2 instanceof IMember && this.fMemberOrderCache.isSortByVisibility()) {
            try {
                int flags1 = JdtFlags.getVisibilityCode((IMember)e1);
                int flags2 = JdtFlags.getVisibilityCode((IMember)e2);
                int vis = this.fMemberOrderCache.getVisibilityIndex(flags1) - this.fMemberOrderCache.getVisibilityIndex(flags2);
                if (vis != 0) {
                    return vis;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        name1 = this.getElementName(e1);
        name2 = this.getElementName(e2);
        if (e1 instanceof IType && e2 instanceof IType) {
            if (name1.length() == 0) {
                if (name2.length() == 0) {
                    try {
                        return this.getComparator().compare(((IType)e1).getSuperclassName(), ((IType)e2).getSuperclassName());
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        return 0;
                    }
                }
                return 1;
            }
            if (name2.length() == 0) {
                return -1;
            }
        }
        if ((cmp = this.getComparator().compare(name1, name2)) != 0) {
            return cmp;
        }
        if (e1 instanceof IFunction && e2 instanceof IFunction) {
            String[] params1 = ((IFunction)e1).getParameterTypes();
            String[] params2 = ((IFunction)e2).getParameterTypes();
            int len = Math.min(params1.length, params2.length);
            int i = 0;
            while (i < len) {
                cmp = this.getComparator().compare(Signature.toString(params1[i]), Signature.toString(params2[i]));
                if (cmp != 0) {
                    return cmp;
                }
                ++i;
            }
            return params1.length - params2.length;
        }
        return 0;
    }

    private IPackageFragmentRoot getPackageFragmentRoot(Object element) {
        if (element instanceof PackageFragmentRootContainer) {
            PackageFragmentRootContainer cp = (PackageFragmentRootContainer)element;
            IPackageFragmentRoot[] roots = cp.getPackageFragmentRoots();
            if (roots.length > 0) {
                return roots[0];
            }
            return null;
        }
        return JavaModelUtil.getPackageFragmentRoot((IJavaScriptElement)element);
    }

    private String getNonJavaElementLabel(Viewer viewer, Object element) {
        IBaseLabelProvider prov;
        IWorkbenchAdapter adapter;
        if (element instanceof IResource) {
            return ((IResource)element).getName();
        }
        if (element instanceof IStorage) {
            return ((IStorage)element).getName();
        }
        if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
            return adapter.getLabel(element);
        }
        if (viewer instanceof ContentViewer && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            return ((ILabelProvider)prov).getText(element);
        }
        return null;
    }

    private int getClassPathIndex(IPackageFragmentRoot root) {
        try {
            IPath rootPath = root.getPath();
            IPackageFragmentRoot[] roots = root.getJavaScriptProject().getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getPath().equals((Object)rootPath)) {
                    return i;
                }
                ++i;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return Integer.MAX_VALUE;
    }

    private boolean needsClasspathComparision(Object e1, int cat1, Object e2, int cat2) {
        if (cat1 == 2 && cat2 == 2 || cat1 == 3 && ((IPackageFragment)e1).getParent().getResource() instanceof IProject && cat2 == 2 || cat1 == 2 && cat2 == 3 && ((IPackageFragment)e2).getParent().getResource() instanceof IProject) {
            IJavaScriptProject p1 = this.getJavaProject(e1);
            return p1 != null && p1.equals(this.getJavaProject(e2));
        }
        return false;
    }

    private IJavaScriptProject getJavaProject(Object element) {
        if (element instanceof IJavaScriptElement) {
            return ((IJavaScriptElement)element).getJavaScriptProject();
        }
        if (element instanceof PackageFragmentRootContainer) {
            return ((PackageFragmentRootContainer)element).getJavaProject();
        }
        return null;
    }

    private String getElementName(Object element) {
        if (element instanceof IJavaScriptElement) {
            return ((IJavaScriptElement)element).getElementName();
        }
        if (element instanceof PackageFragmentRootContainer) {
            return ((PackageFragmentRootContainer)element).getLabel();
        }
        return element.toString();
    }
}

