/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.schema.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonArray;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonObject;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.wst.json.core.internal.Logger;
import org.eclipse.wst.json.core.internal.download.HttpClientProvider;
import org.eclipse.wst.json.core.schema.catalog.ICatalog;
import org.eclipse.wst.json.core.schema.catalog.ICatalogElement;
import org.eclipse.wst.json.core.schema.catalog.ICatalogEntry;
import org.osgi.framework.Bundle;

public class CatalogSchemastoreReader {
    private static final String SCHEMAS = "schemas";
    private static final String SCHEMASTORE_CATALOG = "https://raw.githubusercontent.com/SchemaStore/schemastore/master/src/api/json/catalog.json";
    protected ICatalog catalog;

    protected CatalogSchemastoreReader(ICatalog catalog) {
        this.catalog = catalog;
    }

    protected void readSchemastore() {
        File f = CatalogSchemastoreReader.getUrl();
        if (f != null) {
            JsonValue schemas;
            int type = 2;
            try {
                InputStreamReader reader = new InputStreamReader(new FileInputStream(f));
                JsonObject json = JsonObject.readFrom(reader);
                schemas = json.get(SCHEMAS);
            }
            catch (IOException e) {
                Logger.logException(e);
                return;
            }
            if (schemas != null && schemas instanceof JsonArray) {
                JsonArray elements = (JsonArray)schemas;
                for (JsonValue value : elements) {
                    if (!(value instanceof JsonObject)) continue;
                    JsonObject jsonObject = (JsonObject)value;
                    JsonValue urlJson = jsonObject.get("url");
                    JsonValue fileMatchJson = jsonObject.get("fileMatch");
                    if (urlJson == null || fileMatchJson == null || !urlJson.isString() || !fileMatchJson.isArray()) continue;
                    String url = urlJson.asString();
                    JsonArray fileMatchArray = fileMatchJson.asArray();
                    for (JsonValue fileMatchValue : fileMatchArray) {
                        if (!fileMatchValue.isString()) continue;
                        String fileMatch = fileMatchValue.asString();
                        ICatalogElement catalogElement = this.catalog.createCatalogElement(type);
                        if (catalogElement instanceof ICatalogEntry) {
                            ICatalogEntry entry = (ICatalogEntry)catalogElement;
                            entry.setKey(fileMatch);
                            entry.setURI(url);
                            entry.setId(fileMatch);
                        }
                        this.catalog.addCatalogElement(catalogElement);
                    }
                }
            }
        }
    }

    private static File getUrl() {
        try {
            File f = HttpClientProvider.getFile(new URL(SCHEMASTORE_CATALOG));
            if (f == null || !f.exists()) {
                File file;
                URL url = CatalogSchemastoreReader.getUrlFromBundle();
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    file = new File(url.getPath());
                }
                return file;
            }
            return f;
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    private static URL getUrlFromBundle() {
        URL[] urls;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.json.core");
        if (bundle != null && (urls = FileLocator.findEntries((Bundle)bundle, (IPath)new Path("/schemastore/catalog.json"))) != null && urls.length > 0) {
            try {
                return FileLocator.resolve((URL)urls[0]);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return null;
    }
}

