/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.maven.ArtifactResolver;
import com.diffplug.spotless.maven.FileLocator;
import com.diffplug.spotless.maven.FormatterConfig;
import com.diffplug.spotless.maven.FormatterFactory;
import com.diffplug.spotless.maven.FormatterStepFactory;
import com.diffplug.spotless.maven.FormattersHolder;
import com.diffplug.spotless.maven.GitRatchetMaven;
import com.diffplug.spotless.maven.MavenProvisioner;
import com.diffplug.spotless.maven.PluginException;
import com.diffplug.spotless.maven.antlr4.Antlr4;
import com.diffplug.spotless.maven.cpp.Cpp;
import com.diffplug.spotless.maven.generic.Format;
import com.diffplug.spotless.maven.generic.LicenseHeader;
import com.diffplug.spotless.maven.groovy.Groovy;
import com.diffplug.spotless.maven.incremental.UpToDateChecker;
import com.diffplug.spotless.maven.incremental.UpToDateChecking;
import com.diffplug.spotless.maven.java.Java;
import com.diffplug.spotless.maven.javascript.Javascript;
import com.diffplug.spotless.maven.json.Json;
import com.diffplug.spotless.maven.kotlin.Kotlin;
import com.diffplug.spotless.maven.markdown.Markdown;
import com.diffplug.spotless.maven.pom.Pom;
import com.diffplug.spotless.maven.python.Python;
import com.diffplug.spotless.maven.scala.Scala;
import com.diffplug.spotless.maven.sql.Sql;
import com.diffplug.spotless.maven.typescript.Typescript;
import com.diffplug.spotless.maven.yaml.Yaml;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.MatchPatterns;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractSpotlessMojo
extends AbstractMojo {
    private static final String DEFAULT_INDEX_FILE_NAME = "spotless-index";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_LINE_ENDINGS = "GIT_ATTRIBUTES";
    static final String RATCHETFROM_NONE = "NONE";
    static final String GOAL_CHECK = "check";
    static final String GOAL_APPLY = "apply";
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ResourceManager resourceManager;
    @Component
    protected BuildContext buildContext;
    @Parameter(defaultValue="${mojoExecution.goal}", required=true, readonly=true)
    private String goal;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(property="spotless.apply.skip", defaultValue="false")
    private boolean applySkip;
    @Parameter(property="spotless.check.skip", defaultValue="false")
    private boolean checkSkip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remotePluginRepositories}", required=true, readonly=true)
    private List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    private File baseDir;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File buildDir;
    @Parameter(defaultValue="UTF-8")
    private String encoding;
    @Parameter(defaultValue="GIT_ATTRIBUTES")
    private LineEnding lineEndings;
    @Parameter
    private String ratchetFrom;
    @Parameter
    private LicenseHeader licenseHeader;
    @Parameter
    private List<Format> formats = Collections.emptyList();
    @Parameter
    private Groovy groovy;
    @Parameter
    private Java java;
    @Parameter
    private Scala scala;
    @Parameter
    private Kotlin kotlin;
    @Parameter
    private Cpp cpp;
    @Parameter
    private Typescript typescript;
    @Parameter
    private Javascript javascript;
    @Parameter
    private Antlr4 antlr4;
    @Parameter
    private Pom pom;
    @Parameter
    private Sql sql;
    @Parameter
    private Python python;
    @Parameter
    private Markdown markdown;
    @Parameter
    private Json json;
    @Parameter
    private Yaml yaml;
    @Parameter(property="spotlessFiles")
    private String filePatterns;
    @Parameter(property="spotlessSetLicenseHeaderYearsFromGitHistory")
    private String setLicenseHeaderYearsFromGitHistory;
    @Parameter
    private UpToDateChecking upToDateChecking;

    protected abstract void process(Iterable<File> var1, Formatter var2, UpToDateChecker var3) throws MojoExecutionException;

    public final void execute() throws MojoExecutionException {
        if (this.shouldSkip()) {
            this.getLog().info((CharSequence)String.format("Spotless %s skipped", this.goal));
            return;
        }
        List<FormatterFactory> formatterFactories = this.getFormatterFactories();
        FormatterConfig config = this.getFormatterConfig();
        HashMap<FormatterFactory, Supplier<Iterable<File>>> formatterFactoryToFiles = new HashMap<FormatterFactory, Supplier<Iterable<File>>>();
        for (FormatterFactory formatterFactory : formatterFactories) {
            Supplier<Iterable> filesToFormat = () -> this.collectFiles(formatterFactory, config);
            formatterFactoryToFiles.put(formatterFactory, filesToFormat);
        }
        try (FormattersHolder formattersHolder = FormattersHolder.create(formatterFactoryToFiles, config);
             UpToDateChecker upToDateChecker = this.createUpToDateChecker(formattersHolder.getFormatters());){
            for (Map.Entry<Formatter, Supplier<Iterable<File>>> entry : formattersHolder.getFormattersWithFiles().entrySet()) {
                Formatter formatter = entry.getKey();
                Iterable<File> files = entry.getValue().get();
                this.process(files, formatter, upToDateChecker);
            }
        }
        catch (PluginException e) {
            throw e.asMojoExecutionException();
        }
    }

    private boolean shouldSkip() {
        if (this.skip) {
            return true;
        }
        switch (this.goal) {
            case "check": {
                return this.checkSkip;
            }
            case "apply": {
                return this.applySkip;
            }
        }
        return false;
    }

    private List<File> collectFiles(FormatterFactory formatterFactory, FormatterConfig config) {
        Optional<String> ratchetFrom = formatterFactory.ratchetFrom(config);
        try {
            List<File> files = ratchetFrom.isPresent() ? this.collectFilesFromGit(formatterFactory, ratchetFrom.get()) : this.collectFilesFromFormatterFactory(formatterFactory);
            if (this.filePatterns == null || this.filePatterns.isEmpty()) {
                return files;
            }
            String[] includePatterns = this.filePatterns.split(",");
            List compiledIncludePatterns = Arrays.stream(includePatterns).map(Pattern::compile).collect(Collectors.toList());
            Predicate<File> shouldInclude = file -> compiledIncludePatterns.stream().anyMatch(filePattern -> filePattern.matcher(file.getAbsolutePath()).matches());
            return files.stream().filter(shouldInclude).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new PluginException("Unable to scan file tree rooted at " + this.baseDir, e);
        }
    }

    private List<File> collectFilesFromGit(FormatterFactory formatterFactory, String ratchetFrom) {
        Iterable<String> dirtyFiles;
        MatchPatterns includePatterns = MatchPatterns.from(this.withNormalizedFileSeparators(this.getIncludes(formatterFactory)));
        MatchPatterns excludePatterns = MatchPatterns.from(this.withNormalizedFileSeparators(this.getExcludes(formatterFactory)));
        try {
            dirtyFiles = GitRatchetMaven.instance().getDirtyFiles(this.baseDir, ratchetFrom);
        }
        catch (IOException e) {
            throw new PluginException("Unable to scan file tree rooted at " + this.baseDir, e);
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String file : this.withNormalizedFileSeparators(dirtyFiles)) {
            if (!includePatterns.matches(file, true) || excludePatterns.matches(file, true)) continue;
            result.add(new File(this.baseDir.getPath(), file));
        }
        return result;
    }

    private List<File> collectFilesFromFormatterFactory(FormatterFactory formatterFactory) throws IOException {
        String includesString = String.join((CharSequence)",", this.getIncludes(formatterFactory));
        String excludesString = String.join((CharSequence)",", this.getExcludes(formatterFactory));
        return FileUtils.getFiles((File)this.baseDir, (String)includesString, (String)excludesString);
    }

    private Iterable<String> withNormalizedFileSeparators(Iterable<String> patterns) {
        return StreamSupport.stream(patterns.spliterator(), true).map(pattern -> pattern.replace('/', File.separatorChar)).map(pattern -> pattern.replace('\\', File.separatorChar)).collect(Collectors.toSet());
    }

    private static String withTrailingSeparator(String path) {
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    private Set<String> getIncludes(FormatterFactory formatterFactory) {
        Set<String> includes;
        Set<String> configuredIncludes = formatterFactory.includes();
        Set<String> set = includes = configuredIncludes.isEmpty() ? formatterFactory.defaultIncludes() : configuredIncludes;
        if (includes.isEmpty()) {
            throw new PluginException("You must specify some files to include, such as '<includes><include>src/**/*.blah</include></includes>'");
        }
        return includes;
    }

    private Set<String> getExcludes(FormatterFactory formatterFactory) {
        Set<String> configuredExcludes = formatterFactory.excludes();
        HashSet<String> excludes = new HashSet<String>(FileUtils.getDefaultExcludesAsList());
        excludes.add(AbstractSpotlessMojo.withTrailingSeparator(this.buildDir.toString()));
        excludes.addAll(configuredExcludes);
        return excludes;
    }

    private FormatterConfig getFormatterConfig() {
        ArtifactResolver resolver = new ArtifactResolver(this.repositorySystem, this.repositorySystemSession, this.repositories, this.getLog());
        Provisioner provisioner = MavenProvisioner.create(resolver);
        List<FormatterStepFactory> formatterStepFactories = this.getFormatterStepFactories();
        FileLocator fileLocator = this.getFileLocator();
        Optional<String> optionalRatchetFrom = Optional.ofNullable(this.ratchetFrom).filter(ratchet -> !RATCHETFROM_NONE.equals(ratchet));
        return new FormatterConfig(this.baseDir, this.encoding, this.lineEndings, optionalRatchetFrom, provisioner, fileLocator, formatterStepFactories, Optional.ofNullable(this.setLicenseHeaderYearsFromGitHistory));
    }

    private FileLocator getFileLocator() {
        this.resourceManager.addSearchPath("file", this.baseDir.getAbsolutePath());
        this.resourceManager.addSearchPath("url", "");
        this.resourceManager.setOutputDirectory(this.buildDir);
        return new FileLocator(this.resourceManager, this.baseDir, this.buildDir);
    }

    private List<FormatterFactory> getFormatterFactories() {
        return Stream.concat(this.formats.stream(), Stream.of(this.groovy, this.java, this.scala, this.kotlin, this.cpp, this.typescript, this.javascript, this.antlr4, this.pom, this.sql, this.python, this.markdown, this.json, this.yaml)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<FormatterStepFactory> getFormatterStepFactories() {
        return Stream.of(this.licenseHeader).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private UpToDateChecker createUpToDateChecker(Iterable<Formatter> formatters) {
        UpToDateChecker checker;
        Path indexFile;
        Path path = indexFile = this.upToDateChecking == null ? null : this.upToDateChecking.getIndexFile();
        if (indexFile == null) {
            Path targetDir = this.project.getBasedir().toPath().resolve(this.project.getBuild().getDirectory());
            indexFile = targetDir.resolve(DEFAULT_INDEX_FILE_NAME);
        }
        if (this.upToDateChecking != null && this.upToDateChecking.isEnabled()) {
            this.getLog().info((CharSequence)"Up-to-date checking enabled");
            checker = UpToDateChecker.forProject(this.project, indexFile, formatters, this.getLog());
        } else {
            checker = UpToDateChecker.noop(this.project, indexFile, this.getLog());
        }
        return UpToDateChecker.wrapWithBuildContext(checker, this.buildContext);
    }
}

