/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.common.base.Errors;
import com.diffplug.common.io.ByteStreams;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;

class IdeHook {
    IdeHook() {
    }

    private static void dumpIsClean() {
        System.err.println("IS CLEAN");
    }

    static void performHook(Iterable<File> projectFiles, Formatter formatter, String path, boolean spotlessIdeHookUseStdIn, boolean spotlessIdeHookUseStdOut) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            System.err.println("Argument passed to spotlessIdeHook must be an absolute path");
            return;
        }
        if (!IdeHook.projectContainsFile(projectFiles, file)) {
            return;
        }
        try {
            byte[] bytes = spotlessIdeHookUseStdIn ? ByteStreams.toByteArray((InputStream)System.in) : Files.readAllBytes(file.toPath());
            PaddedCell.DirtyState dirty = PaddedCell.calculateDirtyState((Formatter)formatter, (File)file, (byte[])bytes);
            if (dirty.isClean()) {
                IdeHook.dumpIsClean();
            } else if (dirty.didNotConverge()) {
                System.err.println("DID NOT CONVERGE");
                System.err.println("See details https://github.com/diffplug/spotless/blob/main/PADDEDCELL.md");
            } else {
                System.err.println("IS DIRTY");
                if (spotlessIdeHookUseStdOut) {
                    dirty.writeCanonicalTo((OutputStream)System.out);
                } else {
                    dirty.writeCanonicalTo(file);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw Errors.asRuntime((Throwable)e);
        }
        finally {
            System.err.close();
            System.out.close();
        }
    }

    private static boolean projectContainsFile(Iterable<File> projectFiles, File file) {
        for (File projectFile : projectFiles) {
            if (!projectFile.equals(file)) continue;
            return true;
        }
        return false;
    }
}

