/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.IdeHook;
import com.diffplug.gradle.spotless.SpotlessApply;
import com.diffplug.gradle.spotless.SpotlessCheck;
import com.diffplug.gradle.spotless.SpotlessDiagnoseTask;
import com.diffplug.gradle.spotless.SpotlessExtensionBase;
import com.diffplug.gradle.spotless.SpotlessPlugin;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SpotlessTaskBase;
import com.diffplug.gradle.spotless.SpotlessTaskModern;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class SpotlessExtensionModern
extends SpotlessExtensionBase {
    final TaskProvider<?> rootCheckTask;
    final TaskProvider<?> rootApplyTask;
    final TaskProvider<?> rootDiagnoseTask;

    public SpotlessExtensionModern(Project project) {
        super(project);
        this.rootCheckTask = project.getTasks().register("spotlessCheck", task -> {
            task.setGroup("Verification");
            task.setDescription("Checks that sourcecode satisfies formatting steps.");
        });
        this.rootApplyTask = project.getTasks().register("spotlessApply", task -> {
            task.setGroup("Verification");
            task.setDescription("Applies code formatting steps to sourcecode in-place.");
        });
        this.rootDiagnoseTask = project.getTasks().register("spotlessDiagnose", task -> task.setGroup("Verification"));
        project.afterEvaluate(unused -> {
            if (this.enforceCheck) {
                project.getTasks().named("check").configure(task -> task.dependsOn(new Object[]{this.rootCheckTask}));
            }
        });
    }

    @Override
    public <T extends FormatExtension> void format(String name, Class<T> clazz, Action<T> configure) {
        ((FormatExtension)this.maybeCreate((String)name, clazz)).modernLazyActions.add(configure);
    }

    @Override
    protected void createFormatTasks(String name, FormatExtension formatExtension) {
        boolean isIdeHook = this.project.hasProperty("spotlessIdeHook");
        TaskContainer tasks = this.project.getTasks();
        TaskProvider cleanTask = tasks.named("clean");
        String taskName = "spotless" + SpotlessPlugin.capitalize(name);
        TaskProvider spotlessTask = tasks.register(taskName, SpotlessTaskModern.class, task -> {
            task.setEnabled(!isIdeHook);
            task.mustRunAfter(new Object[]{cleanTask});
        });
        this.project.afterEvaluate(unused -> spotlessTask.configure(task -> {
            for (Action<FormatExtension> lazyAction : formatExtension.modernLazyActions) {
                lazyAction.execute((Object)formatExtension);
            }
            formatExtension.setupTask((SpotlessTask)((Object)((Object)task)));
        }));
        TaskProvider applyTask = tasks.register(taskName + "Apply", SpotlessApply.class, task -> {
            task.setEnabled(!isIdeHook);
            task.dependsOn(new Object[]{spotlessTask});
            task.setSpotlessOutDirectory(((SpotlessTaskModern)((Object)((Object)spotlessTask.get()))).getOutputDirectory());
            task.linkSource((SpotlessTaskBase)((Object)((Object)spotlessTask.get())));
        });
        this.rootApplyTask.configure(task -> {
            task.dependsOn(new Object[]{applyTask});
            if (isIdeHook) {
                task.doLast(unused -> IdeHook.performHook((SpotlessTask)((Object)((Object)((Object)spotlessTask.get())))));
            }
        });
        TaskProvider checkTask = tasks.register(taskName + "Check", SpotlessCheck.class, task -> {
            task.setEnabled(!isIdeHook);
            task.dependsOn(new Object[]{spotlessTask});
            task.setSpotlessOutDirectory(((SpotlessTaskModern)((Object)((Object)spotlessTask.get()))).getOutputDirectory());
            task.source = (SpotlessTaskBase)((Object)((Object)spotlessTask.get()));
            task.mustRunAfter(new Object[]{applyTask});
        });
        this.rootCheckTask.configure(task -> task.dependsOn(new Object[]{checkTask}));
        TaskProvider diagnoseTask = tasks.register(taskName + "Diagnose", SpotlessDiagnoseTask.class, task -> {
            task.source = (SpotlessTask)((Object)((Object)spotlessTask.get()));
            task.mustRunAfter(new Object[]{cleanTask});
        });
        this.rootDiagnoseTask.configure(task -> task.dependsOn(new Object[]{diagnoseTask}));
    }
}

