/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.GitRatchet;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessApply;
import com.diffplug.spotless.FormatExceptionPolicy;
import com.diffplug.spotless.FormatExceptionPolicyStrict;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.ObjectId;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public class SpotlessTaskBase
extends DefaultTask {
    SpotlessApply applyTask;
    protected String encoding = "UTF-8";
    protected LineEnding.Policy lineEndingsPolicy = LineEnding.UNIX.createPolicy();
    @Nullable
    GitRatchet ratchet;
    ObjectId rootTreeSha;
    private ObjectId subtreeSha = ObjectId.zeroId();
    protected FormatExceptionPolicy exceptionPolicy = new FormatExceptionPolicyStrict();
    protected FileCollection target;
    protected File outputDirectory = new File(this.getProject().getBuildDir(), "spotless/" + this.getName());
    protected List<FormatterStep> steps = new ArrayList<FormatterStep>();

    @Internal
    @Deprecated
    public SpotlessApply getApplyTask() {
        return this.applyTask;
    }

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = Objects.requireNonNull(encoding);
    }

    @Input
    public LineEnding.Policy getLineEndingsPolicy() {
        return this.lineEndingsPolicy;
    }

    public void setLineEndingsPolicy(LineEnding.Policy lineEndingsPolicy) {
        this.lineEndingsPolicy = Objects.requireNonNull(lineEndingsPolicy);
    }

    public void setupRatchet(GitRatchet gitRatchet, String ratchetFrom) {
        this.ratchet = gitRatchet;
        this.rootTreeSha = gitRatchet.rootTreeShaOf(this.getProject(), ratchetFrom);
        this.subtreeSha = gitRatchet.subtreeShaOf(this.getProject(), this.rootTreeSha);
    }

    @Internal
    GitRatchet getRatchet() {
        return this.ratchet;
    }

    @Internal
    ObjectId getRootTreeSha() {
        return this.rootTreeSha;
    }

    @Input
    public ObjectId getRatchetSha() {
        return this.subtreeSha;
    }

    public void setExceptionPolicy(FormatExceptionPolicy exceptionPolicy) {
        this.exceptionPolicy = Objects.requireNonNull(exceptionPolicy);
    }

    @Input
    public FormatExceptionPolicy getExceptionPolicy() {
        return this.exceptionPolicy;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileCollection getTarget() {
        return this.target;
    }

    public void setTarget(Iterable<File> target) {
        this.target = target instanceof FileCollection ? (FileCollection)target : this.getProject().files(new Object[]{target});
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public List<FormatterStep> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public void setSteps(List<FormatterStep> steps) {
        this.steps = PluginGradlePreconditions.requireElementsNonNull(steps);
    }

    public boolean addStep(FormatterStep step) {
        return this.steps.add(Objects.requireNonNull(step));
    }

    String formatName() {
        String name = this.getName();
        if (name.startsWith("spotless")) {
            return name.substring("spotless".length()).toLowerCase(Locale.ROOT);
        }
        return name;
    }

    Formatter buildFormatter() {
        return Formatter.builder().lineEndingsPolicy(this.lineEndingsPolicy).encoding(Charset.forName(this.encoding)).rootDir(this.getProject().getRootDir().toPath()).steps(this.steps).exceptionPolicy(this.exceptionPolicy).build();
    }
}

