/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.HasBuiltinDelimiterForLicense;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import com.diffplug.spotless.extra.java.EclipseJdtFormatterStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.java.GoogleJavaFormatStep;
import com.diffplug.spotless.java.ImportOrderStep;
import com.diffplug.spotless.java.RemoveUnusedImportsStep;
import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class JavaExtension
extends FormatExtension
implements HasBuiltinDelimiterForLicense {
    static final String NAME = "java";
    static final String LICENSE_HEADER_DELIMITER = "package ";

    @Inject
    public JavaExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeader(String licenseHeader) {
        return this.licenseHeader(licenseHeader, LICENSE_HEADER_DELIMITER);
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile) {
        return this.licenseHeaderFile(licenseHeaderFile, LICENSE_HEADER_DELIMITER);
    }

    public void importOrder(String ... importOrder) {
        this.addStep(ImportOrderStep.forJava().createFrom(importOrder));
    }

    public void importOrderFile(Object importOrderFile) {
        Objects.requireNonNull(importOrderFile);
        this.addStep(ImportOrderStep.forJava().createFrom(this.getProject().file(importOrderFile)));
    }

    public void removeUnusedImports() {
        this.addStep(RemoveUnusedImportsStep.create((Provisioner)this.provisioner()));
    }

    public GoogleJavaFormatConfig googleJavaFormat() {
        return this.googleJavaFormat(GoogleJavaFormatStep.defaultVersion());
    }

    public GoogleJavaFormatConfig googleJavaFormat(String version) {
        Objects.requireNonNull(version);
        return new GoogleJavaFormatConfig(version);
    }

    public EclipseConfig eclipse() {
        return new EclipseConfig(EclipseJdtFormatterStep.defaultVersion());
    }

    public EclipseConfig eclipse(String version) {
        return new EclipseConfig(version);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            JavaPluginConvention javaPlugin = (JavaPluginConvention)this.getProject().getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPlugin == null) {
                throw new GradleException("You must either specify 'target' manually or apply the 'java' plugin.");
            }
            ConfigurableFileCollection union = this.getProject().files(new Object[0]);
            for (SourceSet sourceSet : javaPlugin.getSourceSets()) {
                union = union.plus((FileCollection)sourceSet.getAllJava());
            }
            this.target = union;
        }
        this.steps.replaceAll(step -> {
            if (LicenseHeaderStep.name().equals(step.getName())) {
                return step.filterByFile(LicenseHeaderStep.unsupportedJvmFilesFilter());
            }
            return step;
        });
        super.setupTask(task);
    }

    public class EclipseConfig {
        private final EclipseBasedStepBuilder builder;

        EclipseConfig(String version) {
            this.builder = EclipseJdtFormatterStep.createBuilder((Provisioner)JavaExtension.this.provisioner());
            this.builder.setVersion(version);
            JavaExtension.this.addStep(this.builder.build());
        }

        public void configFile(Object ... configFiles) {
            PluginGradlePreconditions.requireElementsNonNull(configFiles);
            Project project = JavaExtension.this.getProject();
            this.builder.setPreferences((Iterable)project.files(configFiles).getFiles());
            JavaExtension.this.replaceStep(this.builder.build());
        }
    }

    public class GoogleJavaFormatConfig {
        final String version;
        String style;

        GoogleJavaFormatConfig(String version) {
            this.version = Objects.requireNonNull(version);
            this.style = GoogleJavaFormatStep.defaultStyle();
            JavaExtension.this.addStep(this.createStep());
        }

        public void style(String style) {
            this.style = Objects.requireNonNull(style);
            JavaExtension.this.replaceStep(this.createStep());
        }

        public void aosp() {
            this.style("AOSP");
        }

        private FormatterStep createStep() {
            return GoogleJavaFormatStep.create((String)this.version, (String)this.style, (Provisioner)JavaExtension.this.provisioner());
        }
    }
}

