/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform;

import com.emc.vipr.transform.InputTransform;
import com.emc.vipr.transform.OutputTransform;
import com.emc.vipr.transform.TransformException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public abstract class TransformFactory<T extends OutputTransform, U extends InputTransform>
implements Comparable<TransformFactory<OutputTransform, InputTransform>> {
    private int priority;

    public abstract T getOutputTransform(OutputStream var1, Map<String, String> var2) throws IOException, TransformException;

    public abstract T getOutputTransform(InputStream var1, Map<String, String> var2) throws IOException, TransformException;

    public abstract U getInputTransform(String var1, InputStream var2, Map<String, String> var3) throws IOException, TransformException;

    public abstract String getTransformClass();

    public boolean canDecode(String transformConfig, Map<String, String> metadata) {
        return this.getTransformClass().equals(this.splitTransformConfig(transformConfig)[0]);
    }

    protected String[] splitTransformConfig(String transformConfig) {
        String[] configTuple = transformConfig.split(":", 2);
        if (configTuple.length != 2) {
            throw new IllegalArgumentException("Invalid transform config string: " + transformConfig);
        }
        return configTuple;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(TransformFactory<OutputTransform, InputTransform> other) {
        return this.getPriority() - other.getPriority();
    }
}

