/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.compression;

import SevenZip.Compression.LZMA.Encoder;
import com.emc.vipr.transform.compression.CompressionStream;
import com.emc.vipr.transform.compression.CompressionTransformFactory;
import com.emc.vipr.transform.compression.LZMAOutputStream;
import com.emc.vipr.transform.encryption.KeyUtils;
import com.emc.vipr.transform.util.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LZMACompressionFilter
extends InputStream
implements CompressionStream,
Runnable {
    private static Logger log = LoggerFactory.getLogger(LZMACompressionFilter.class);
    private boolean closed = false;
    private Thread compressionThread;
    private PipedInputStream inputPipe;
    private PipedOutputStream outputPipe;
    private Encoder lzma;
    private CountingInputStream uncompressedSize;
    private CountingInputStream compressedSize;
    private DigestInputStream uncompressedDigest;
    private byte[] digest = new byte[0];
    private Exception compressionFailure;

    public LZMACompressionFilter(InputStream in, int compressionLevel) throws IOException {
        this(in, CompressionTransformFactory.LZMA_COMPRESSION_PROFILE[compressionLevel]);
    }

    public LZMACompressionFilter(InputStream in, CompressionTransformFactory.LzmaProfile compressionProfile) throws IOException {
        this.uncompressedSize = new CountingInputStream(in);
        try {
            this.uncompressedDigest = new DigestInputStream(this.uncompressedSize, MessageDigest.getInstance("SHA1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Could not create LZMACompessionFilter", e);
        }
        this.inputPipe = new PipedInputStream();
        this.outputPipe = new PipedOutputStream(this.inputPipe);
        this.compressedSize = new CountingInputStream(this.inputPipe);
        this.lzma = new Encoder();
        this.lzma.SetDictionarySize(compressionProfile.dictionarySize);
        this.lzma.SetNumFastBytes(compressionProfile.fastBytes);
        this.lzma.SetMatchFinder(compressionProfile.matchFinder);
        this.lzma.SetLcLpPb(compressionProfile.lc, compressionProfile.lp, compressionProfile.pb);
        this.lzma.SetEndMarkerMode(true);
        this.lzma.WriteCoderProperties((OutputStream)this.outputPipe);
        this.compressionThread = new Thread(LZMAOutputStream.LZ_COMP_TG, this);
        this.compressionThread.start();
    }

    @Override
    public int read() throws IOException {
        this.readCheck();
        return this.compressedSize.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.readCheck();
        return this.compressedSize.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.readCheck();
        return this.compressedSize.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        this.readCheck();
        return this.compressedSize.available();
    }

    @Override
    public long skip(long n) throws IOException {
        this.readCheck();
        return this.compressedSize.skip(n);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.compressedSize.close();
        try {
            this.compressionThread.join();
        }
        catch (InterruptedException e) {
            throw new IOException("Error waiting for compression thread to exit", e);
        }
        this.digest = this.uncompressedDigest.getMessageDigest().digest();
        this.lzma = null;
    }

    @Override
    public void run() {
        try {
            this.lzma.Code((InputStream)this.uncompressedDigest, (OutputStream)this.outputPipe, -1L, -1L, null);
        }
        catch (Exception e) {
            this.compressionFailure(e);
        }
        try {
            this.outputPipe.close();
        }
        catch (IOException e) {
            this.compressionFailure(e);
        }
    }

    private synchronized void compressionFailure(Exception e) {
        this.compressionFailure = e;
        log.error("Error compressing data", (Throwable)e);
    }

    private synchronized void readCheck() throws IOException {
        if (this.compressionFailure != null) {
            throw new IOException("Error during stream compression", this.compressionFailure);
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public Map<String, String> getStreamMetadata() {
        if (!this.closed) {
            throw new IllegalStateException("Stream must be closed before getting metadata");
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        long compSize = this.compressedSize.getByteCount();
        long uncompSize = this.uncompressedSize.getByteCount();
        String compRatioString = String.format("%.1f%%", 100.0 - (double)compSize * 100.0 / (double)uncompSize);
        metadata.put("x-emc-comp-uncompressed-size", "" + uncompSize);
        metadata.put("x-emc-comp-compressed-size", "" + compSize);
        metadata.put("x-emc-comp-compression-ratio", "" + compRatioString);
        metadata.put("x-emc-comp-uncompressed-sha1", KeyUtils.toHexPadded(this.digest));
        return metadata;
    }
}

