/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.compression;

import SevenZip.Compression.LZMA.Encoder;
import com.emc.vipr.transform.compression.CompressionStream;
import com.emc.vipr.transform.compression.CompressionTransformFactory;
import com.emc.vipr.transform.encryption.KeyUtils;
import com.emc.vipr.transform.util.CountingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LZMAOutputStream
extends OutputStream
implements CompressionStream,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(LZMAOutputStream.class);
    private CountingOutputStream compressedOutput;
    private Thread compressionThread;
    private InputStream inputPipe;
    private CountingOutputStream uncompressedSize;
    private DigestOutputStream outputPipe;
    private boolean closed;
    private Encoder lzma;
    private Exception compressionFailure;
    private byte[] uncompressedDigest;
    static ThreadGroup LZ_COMP_TG = new ThreadGroup("LZMACompress");

    public LZMAOutputStream(OutputStream out, CompressionTransformFactory.LzmaProfile compressionProfile) throws IOException {
        this.compressedOutput = new CountingOutputStream(out);
        this.closed = false;
        this.uncompressedDigest = new byte[0];
        this.inputPipe = new PipedInputStream();
        this.uncompressedSize = new CountingOutputStream(new PipedOutputStream((PipedInputStream)this.inputPipe));
        try {
            this.outputPipe = new DigestOutputStream(this.uncompressedSize, MessageDigest.getInstance("SHA1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Could not create LZMAOutputStream", e);
        }
        this.lzma = new Encoder();
        this.lzma.SetDictionarySize(compressionProfile.dictionarySize);
        this.lzma.SetNumFastBytes(compressionProfile.fastBytes);
        this.lzma.SetMatchFinder(compressionProfile.matchFinder);
        this.lzma.SetLcLpPb(compressionProfile.lc, compressionProfile.lp, compressionProfile.pb);
        this.lzma.SetEndMarkerMode(true);
        this.lzma.WriteCoderProperties((OutputStream)this.compressedOutput);
        this.compressionThread = new Thread(LZ_COMP_TG, this);
        this.compressionThread.start();
    }

    public LZMAOutputStream(OutputStream out, int compressionLevel) throws IOException {
        this(out, CompressionTransformFactory.LZMA_COMPRESSION_PROFILE[compressionLevel]);
    }

    @Override
    public Map<String, String> getStreamMetadata() {
        if (!this.closed) {
            throw new IllegalStateException("Stream must be closed before getting metadata");
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        long compSize = this.compressedOutput.getByteCount();
        long uncompSize = this.uncompressedSize.getByteCount();
        String compRatioString = String.format("%.1f%%", 100.0 - (double)compSize * 100.0 / (double)uncompSize);
        metadata.put("x-emc-comp-uncompressed-size", "" + uncompSize);
        metadata.put("x-emc-comp-compressed-size", "" + compSize);
        metadata.put("x-emc-comp-compression-ratio", "" + compRatioString);
        metadata.put("x-emc-comp-uncompressed-sha1", KeyUtils.toHexPadded(this.uncompressedDigest));
        return metadata;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputPipe.write(b);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.outputPipe.flush();
        this.outputPipe.close();
        this.closed = true;
        try {
            this.compressionThread.join();
        }
        catch (InterruptedException e) {
            throw new IOException("Error waiting for compression thread to exit", e);
        }
        this.compressedOutput.close();
        this.uncompressedDigest = this.outputPipe.getMessageDigest().digest();
        this.lzma = null;
    }

    @Override
    public void flush() throws IOException {
        this.writeCheck();
        this.outputPipe.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeCheck();
        this.outputPipe.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeCheck();
        this.write(b, 0, b.length);
    }

    @Override
    public void run() {
        try {
            this.lzma.Code(this.inputPipe, (OutputStream)this.compressedOutput, -1L, -1L, null);
        }
        catch (Exception e) {
            this.compressionFailure(e);
        }
    }

    private synchronized void compressionFailure(Exception e) {
        this.compressionFailure = e;
        log.error("Error compressing data", (Throwable)e);
    }

    private synchronized void writeCheck() throws IOException {
        if (this.compressionFailure != null) {
            throw new IOException("Error during stream compression", this.compressionFailure);
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }
}

