/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.encryption;

import com.emc.vipr.transform.TransformException;
import com.emc.vipr.transform.encryption.BasicEncryptionInputTransform;
import com.emc.vipr.transform.encryption.BasicEncryptionOutputTransform;
import com.emc.vipr.transform.encryption.DoesNotNeedRekeyException;
import com.emc.vipr.transform.encryption.EncryptionTransformFactory;
import com.emc.vipr.transform.encryption.KeyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreEncryptionFactory
extends EncryptionTransformFactory<BasicEncryptionOutputTransform, BasicEncryptionInputTransform> {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreEncryptionFactory.class);
    private KeyStore keyStore;
    private String masterEncryptionKeyAlias;
    private String masterEncryptionKeyFingerprint;
    private char[] masterKeyPassword;
    private Map<String, String> idToAliasMap;

    public KeyStoreEncryptionFactory(KeyStore keyStore, String masterEncryptionKeyAlias, char[] keyStorePassword) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, TransformException {
        this(keyStore, masterEncryptionKeyAlias, keyStorePassword, null);
    }

    public KeyStoreEncryptionFactory(KeyStore keyStore, String masterEncryptionKeyAlias, char[] masterKeyPassword, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, TransformException {
        this.keyStore = keyStore;
        this.masterEncryptionKeyAlias = masterEncryptionKeyAlias;
        this.masterKeyPassword = masterKeyPassword;
        this.idToAliasMap = new HashMap<String, String>();
        this.provider = provider;
        try {
            if (!keyStore.containsAlias(masterEncryptionKeyAlias)) {
                throw new InvalidKeyException("No certificate found in keystore for alias " + masterEncryptionKeyAlias);
            }
        }
        catch (KeyStoreException e) {
            throw new TransformException("Could not access KeyStore", e);
        }
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                String fingerprint = this.getFingerprint(alias);
                this.idToAliasMap.put(fingerprint, alias);
                if (!alias.equals(masterEncryptionKeyAlias)) continue;
                this.masterEncryptionKeyFingerprint = fingerprint;
            }
        }
        catch (KeyStoreException e) {
            throw new TransformException("Could not init factory from KeyStore", e);
        }
    }

    private String getFingerprint(String alias) throws KeyStoreException, NoSuchAlgorithmException {
        Certificate cert = this.keyStore.getCertificate(alias);
        if (cert instanceof X509Certificate) {
            byte[] ski = ((X509Certificate)cert).getExtensionValue("2.5.29.14");
            if (ski == null) {
                logger.debug("Certificate does not have SKI.  Computing fingerprint.");
                return KeyUtils.getRsaPublicKeyFingerprint((RSAPublicKey)cert.getPublicKey(), this.provider);
            }
            String fingerprint = KeyUtils.toHexPadded(KeyUtils.extractSubjectKeyIdentifier(ski));
            logger.debug("Alias %s Subject Key Identifier: %s", (Object)alias, (Object)fingerprint);
            return fingerprint;
        }
        return KeyUtils.getRsaPublicKeyFingerprint((RSAPublicKey)cert.getPublicKey(), this.provider);
    }

    @Override
    public Map<String, String> rekey(Map<String, String> metadata) throws TransformException, DoesNotNeedRekeyException {
        String newKey;
        String oldKeyId = metadata.get("x-emc-enc-key-id");
        if (oldKeyId == null) {
            throw new TransformException("Metadata does not contain a master key ID");
        }
        if (oldKeyId.equals(this.masterEncryptionKeyFingerprint)) {
            logger.info("Object is already using the current master key");
            throw new DoesNotNeedRekeyException("Object is already using the current master key");
        }
        if (!this.idToAliasMap.containsKey(oldKeyId)) {
            throw new TransformException("Master key with fingerprint " + oldKeyId + " not found");
        }
        String oldAlias = this.idToAliasMap.get(oldKeyId);
        KeyPair oldMasterKey = this.getKeyPair(oldAlias);
        String encodedKey = metadata.get("x-emc-enc-object-key");
        if (encodedKey == null) {
            throw new TransformException("Encrypted object key not found");
        }
        String algorithm = this.getEncryptionAlgorithm();
        SecretKey objectKey = KeyUtils.decryptKey(encodedKey, algorithm, this.provider, oldMasterKey.getPrivate());
        KeyPair newMasterKey = this.getKeyPair(this.masterEncryptionKeyAlias);
        try {
            newKey = KeyUtils.encryptKey(objectKey, this.provider, newMasterKey.getPublic());
        }
        catch (GeneralSecurityException e) {
            throw new TransformException("Error encrypting key: " + e, e);
        }
        HashMap<String, String> newMetadata = new HashMap<String, String>();
        newMetadata.putAll(metadata);
        newMetadata.remove("x-emc-enc-metadata-signature");
        newMetadata.put("x-emc-enc-object-key", newKey);
        newMetadata.put("x-emc-enc-key-id", this.masterEncryptionKeyFingerprint);
        String signature = KeyUtils.signMetadata(newMetadata, (RSAPrivateKey)newMasterKey.getPrivate(), this.provider);
        newMetadata.put("x-emc-enc-metadata-signature", signature);
        return newMetadata;
    }

    private KeyPair getKeyPair(String alias) throws TransformException {
        PrivateKey privateKey;
        Certificate keyCert;
        try {
            keyCert = this.keyStore.getCertificate(alias);
            privateKey = (PrivateKey)this.keyStore.getKey(alias, this.masterKeyPassword);
            if (keyCert == null) {
                throw new TransformException("Certificate for alias " + this.masterEncryptionKeyAlias + " not found");
            }
            if (privateKey == null) {
                throw new TransformException("Private key for alias " + this.masterEncryptionKeyAlias + " not found");
            }
        }
        catch (KeyStoreException e) {
            throw new TransformException("Could not access keystore", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new TransformException("Error loading private key from keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransformException("Error loading private key from keystore", e);
        }
        return new KeyPair(keyCert.getPublicKey(), privateKey);
    }

    @Override
    public BasicEncryptionOutputTransform getOutputTransform(OutputStream streamToEncodeTo, Map<String, String> metadataToEncode) throws IOException, TransformException {
        KeyPair asymmetricKey = this.getKeyPair(this.masterEncryptionKeyAlias);
        return new BasicEncryptionOutputTransform(streamToEncodeTo, metadataToEncode, this.masterEncryptionKeyFingerprint, asymmetricKey, this.encryptionTransform, this.keySize, this.provider);
    }

    @Override
    public BasicEncryptionOutputTransform getOutputTransform(InputStream streamToEncode, Map<String, String> metadataToEncode) throws IOException, TransformException {
        KeyPair asymmetricKey = this.getKeyPair(this.masterEncryptionKeyAlias);
        return new BasicEncryptionOutputTransform(streamToEncode, metadataToEncode, this.masterEncryptionKeyFingerprint, asymmetricKey, this.encryptionTransform, this.keySize, this.provider);
    }

    @Override
    public BasicEncryptionInputTransform getInputTransform(String transformConfig, InputStream streamToDecode, Map<String, String> metadata) throws IOException, TransformException {
        String[] transformTuple = this.splitTransformConfig(transformConfig);
        if (transformTuple.length != 2) {
            throw new TransformException("Invalid transform configuration: " + transformConfig);
        }
        if (!"ENC".equals(transformTuple[0])) {
            throw new TransformException("Unsupported transform class: " + transformTuple[0]);
        }
        String masterKeyId = metadata.get("x-emc-enc-key-id");
        if (masterKeyId == null) {
            throw new TransformException("Could not decrypt object. No master key ID set on object.");
        }
        String masterKeyAlias = this.idToAliasMap.get(masterKeyId);
        if (masterKeyAlias == null) {
            throw new TransformException("Could not find master key for ID " + masterKeyId);
        }
        KeyPair asymmetricKey = this.getKeyPair(masterKeyAlias);
        return new BasicEncryptionInputTransform(transformTuple[1], streamToDecode, metadata, asymmetricKey, this.provider);
    }

    public String getMasterEncryptionKeyAlias() {
        return this.masterEncryptionKeyAlias;
    }

    public void setMasterEncryptionKeyAlias(String alias) throws TransformException {
        try {
            String fingerprint;
            if (!this.keyStore.containsAlias(alias)) {
                throw new TransformException("Certificate with alias " + alias + " not found in keystore");
            }
            this.masterEncryptionKeyFingerprint = fingerprint = this.getFingerprint(alias);
            this.masterEncryptionKeyAlias = alias;
        }
        catch (KeyStoreException e) {
            throw new TransformException("Could not access keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransformException("Could not load certificate for alias " + alias);
        }
    }
}

