/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.io;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.Output;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferOutput
extends Output {
    private static final ByteOrder nativeOrder = ByteOrder.nativeOrder();
    protected ByteBuffer byteBuffer;

    public ByteBufferOutput() {
    }

    public ByteBufferOutput(int bufferSize) {
        this(bufferSize, bufferSize);
    }

    public ByteBufferOutput(int bufferSize, int maxBufferSize) {
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.capacity = bufferSize;
        this.maxCapacity = maxBufferSize == -1 ? 0x7FFFFFF7 : maxBufferSize;
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    public ByteBufferOutput(ByteBuffer buffer) {
        this.setBuffer(buffer);
    }

    public ByteBufferOutput(ByteBuffer buffer, int maxBufferSize) {
        this.setBuffer(buffer, maxBufferSize);
    }

    public ByteBufferOutput(OutputStream outputStream) {
        this(4096, 4096);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public ByteBufferOutput(OutputStream outputStream, int bufferSize) {
        this(bufferSize, bufferSize);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public byte[] getBuffer() {
        throw new UnsupportedOperationException("This buffer does not used a byte[], see #getByteBuffer().");
    }

    @Override
    public void setBuffer(byte[] buffer) {
        throw new UnsupportedOperationException("This buffer does not used a byte[], see #setByteBuffer(ByteBuffer).");
    }

    @Override
    public void setBuffer(byte[] buffer, int maxBufferSize) {
        throw new UnsupportedOperationException("This buffer does not used a byte[], see #setByteBuffer(ByteBuffer).");
    }

    public void setBuffer(byte[] bytes, int offset, int count) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length);
        buffer.put(bytes, offset, count);
        buffer.position(0);
        buffer.limit(bytes.length);
        this.setBuffer(buffer);
    }

    public void setBuffer(ByteBuffer buffer) {
        this.setBuffer(buffer, buffer.capacity());
    }

    public void setBuffer(ByteBuffer buffer, int maxBufferSize) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.byteBuffer = buffer;
        this.maxCapacity = maxBufferSize == -1 ? 0x7FFFFFF7 : maxBufferSize;
        this.capacity = buffer.capacity();
        this.position = buffer.position();
        this.total = 0L;
        this.outputStream = null;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public byte[] toBytes() {
        byte[] newBuffer = new byte[this.position];
        this.byteBuffer.position(0);
        this.byteBuffer.get(newBuffer, 0, this.position);
        return newBuffer;
    }

    @Override
    public void setPosition(int position) {
        this.position = position;
        this.byteBuffer.position(position);
    }

    @Override
    public void reset() {
        super.reset();
        this.byteBuffer.position(0);
    }

    @Override
    protected boolean require(int required) throws KryoException {
        if (this.capacity - this.position >= required) {
            return false;
        }
        this.flush();
        if (this.capacity - this.position >= required) {
            return true;
        }
        if (required > this.maxCapacity - this.position) {
            if (required > this.maxCapacity) {
                throw new KryoException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + required);
            }
            throw new KryoException("Buffer overflow. Available: " + (this.maxCapacity - this.position) + ", required: " + required);
        }
        if (this.capacity == 0) {
            this.capacity = 16;
        }
        do {
            this.capacity = Math.min(this.capacity * 2, this.maxCapacity);
        } while (this.capacity - this.position < required);
        ByteBuffer newBuffer = !this.byteBuffer.isDirect() ? ByteBuffer.allocate(this.capacity) : ByteBuffer.allocateDirect(this.capacity);
        this.byteBuffer.position(0);
        this.byteBuffer.limit(this.position);
        newBuffer.put(this.byteBuffer);
        newBuffer.order(this.byteBuffer.order());
        this.byteBuffer = newBuffer;
        return true;
    }

    @Override
    public void flush() throws KryoException {
        if (this.outputStream == null) {
            return;
        }
        try {
            byte[] tmp = new byte[this.position];
            this.byteBuffer.position(0);
            this.byteBuffer.get(tmp);
            this.byteBuffer.position(0);
            this.outputStream.write(tmp, 0, this.position);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
        this.total += (long)this.position;
        this.position = 0;
    }

    @Override
    public void close() throws KryoException {
        this.flush();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void write(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.byteBuffer.put((byte)value);
        ++this.position;
    }

    @Override
    public void write(byte[] bytes) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws KryoException {
        this.writeBytes(bytes, offset, length);
    }

    @Override
    public void writeByte(byte value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.byteBuffer.put(value);
        ++this.position;
    }

    @Override
    public void writeByte(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.byteBuffer.put((byte)value);
        ++this.position;
    }

    @Override
    public void writeBytes(byte[] bytes) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.capacity - this.position, count);
        while (true) {
            this.byteBuffer.put(bytes, offset, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) {
                return;
            }
            offset += copyCount;
            copyCount = Math.min(this.capacity, count);
            this.require(copyCount);
        }
    }

    @Override
    public void writeInt(int value) throws KryoException {
        this.require(4);
        this.position += 4;
        ByteBuffer byteBuffer = this.byteBuffer;
        byteBuffer.put((byte)value);
        byteBuffer.put((byte)(value >> 8));
        byteBuffer.put((byte)(value >> 16));
        byteBuffer.put((byte)(value >> 24));
    }

    @Override
    public int writeVarInt(int value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            if (this.position == this.capacity) {
                this.require(1);
            }
            ++this.position;
            this.byteBuffer.put((byte)value);
            return 1;
        }
        if (value >>> 14 == 0) {
            this.require(2);
            this.position += 2;
            this.byteBuffer.put((byte)(value & 0x7F | 0x80));
            this.byteBuffer.put((byte)(value >>> 7));
            return 2;
        }
        if (value >>> 21 == 0) {
            this.require(3);
            this.position += 3;
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.put((byte)(value & 0x7F | 0x80));
            byteBuffer.put((byte)(value >>> 7 | 0x80));
            byteBuffer.put((byte)(value >>> 14));
            return 3;
        }
        if (value >>> 28 == 0) {
            this.require(4);
            this.position += 4;
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.put((byte)(value & 0x7F | 0x80));
            byteBuffer.put((byte)(value >>> 7 | 0x80));
            byteBuffer.put((byte)(value >>> 14 | 0x80));
            byteBuffer.put((byte)(value >>> 21));
            return 4;
        }
        this.require(5);
        this.position += 5;
        ByteBuffer byteBuffer = this.byteBuffer;
        byteBuffer.put((byte)(value & 0x7F | 0x80));
        byteBuffer.put((byte)(value >>> 7 | 0x80));
        byteBuffer.put((byte)(value >>> 14 | 0x80));
        byteBuffer.put((byte)(value >>> 21 | 0x80));
        byteBuffer.put((byte)(value >>> 28));
        return 5;
    }

    @Override
    public int writeVarIntFlag(boolean flag, int value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        int first = value & 0x3F | (flag ? 128 : 0);
        if (value >>> 6 == 0) {
            if (this.position == this.capacity) {
                this.require(1);
            }
            this.byteBuffer.put((byte)first);
            ++this.position;
            return 1;
        }
        if (value >>> 13 == 0) {
            this.require(2);
            this.position += 2;
            this.byteBuffer.put((byte)(first | 0x40));
            this.byteBuffer.put((byte)(value >>> 6));
            return 2;
        }
        if (value >>> 20 == 0) {
            this.require(3);
            this.position += 3;
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.put((byte)(first | 0x40));
            byteBuffer.put((byte)(value >>> 6 | 0x80));
            byteBuffer.put((byte)(value >>> 13));
            return 3;
        }
        if (value >>> 27 == 0) {
            this.require(4);
            this.position += 4;
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.put((byte)(first | 0x40));
            byteBuffer.put((byte)(value >>> 6 | 0x80));
            byteBuffer.put((byte)(value >>> 13 | 0x80));
            byteBuffer.put((byte)(value >>> 20));
            return 4;
        }
        this.require(5);
        this.position += 5;
        ByteBuffer byteBuffer = this.byteBuffer;
        byteBuffer.put((byte)(first | 0x40));
        byteBuffer.put((byte)(value >>> 6 | 0x80));
        byteBuffer.put((byte)(value >>> 13 | 0x80));
        byteBuffer.put((byte)(value >>> 20 | 0x80));
        byteBuffer.put((byte)(value >>> 27));
        return 5;
    }

    @Override
    public void writeLong(long value) throws KryoException {
        this.require(8);
        this.position += 8;
        ByteBuffer byteBuffer = this.byteBuffer;
        byteBuffer.put((byte)value);
        byteBuffer.put((byte)(value >>> 8));
        byteBuffer.put((byte)(value >>> 16));
        byteBuffer.put((byte)(value >>> 24));
        byteBuffer.put((byte)(value >>> 32));
        byteBuffer.put((byte)(value >>> 40));
        byteBuffer.put((byte)(value >>> 48));
        byteBuffer.put((byte)(value >>> 56));
    }

    @Override
    public int writeVarLong(long value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            if (this.position == this.capacity) {
                this.require(1);
            }
            ++this.position;
            this.byteBuffer.put((byte)value);
            return 1;
        }
        if (value >>> 14 == 0L) {
            this.require(2);
            this.position += 2;
            this.byteBuffer.put((byte)(value & 0x7FL | 0x80L));
            this.byteBuffer.put((byte)(value >>> 7));
            return 2;
        }
        if (value >>> 21 == 0L) {
            this.require(3);
            this.position += 3;
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.put((byte)(value & 0x7FL | 0x80L));
            byteBuffer.put((byte)(value >>> 7 | 0x80L));
            byteBuffer.put((byte)(value >>> 14));
            return 3;
        }
        if (value >>> 28 == 0L) {
            this.require(4);
            this.position += 4;
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.put((byte)(value & 0x7FL | 0x80L));
            byteBuffer.put((byte)(value >>> 7 | 0x80L));
            byteBuffer.put((byte)(value >>> 14 | 0x80L));
            byteBuffer.put((byte)(value >>> 21));
            return 4;
        }
        if (value >>> 35 == 0L) {
            this.require(5);
            this.position += 5;
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.put((byte)(value & 0x7FL | 0x80L));
            byteBuffer.put((byte)(value >>> 7 | 0x80L));
            byteBuffer.put((byte)(value >>> 14 | 0x80L));
            byteBuffer.put((byte)(value >>> 21 | 0x80L));
            byteBuffer.put((byte)(value >>> 28));
            return 5;
        }
        if (value >>> 42 == 0L) {
            this.require(6);
            this.position += 6;
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.put((byte)(value & 0x7FL | 0x80L));
            byteBuffer.put((byte)(value >>> 7 | 0x80L));
            byteBuffer.put((byte)(value >>> 14 | 0x80L));
            byteBuffer.put((byte)(value >>> 21 | 0x80L));
            byteBuffer.put((byte)(value >>> 28 | 0x80L));
            byteBuffer.put((byte)(value >>> 35));
            return 6;
        }
        if (value >>> 49 == 0L) {
            this.require(7);
            this.position += 7;
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.put((byte)(value & 0x7FL | 0x80L));
            byteBuffer.put((byte)(value >>> 7 | 0x80L));
            byteBuffer.put((byte)(value >>> 14 | 0x80L));
            byteBuffer.put((byte)(value >>> 21 | 0x80L));
            byteBuffer.put((byte)(value >>> 28 | 0x80L));
            byteBuffer.put((byte)(value >>> 35 | 0x80L));
            byteBuffer.put((byte)(value >>> 42));
            return 7;
        }
        if (value >>> 56 == 0L) {
            this.require(8);
            this.position += 8;
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.put((byte)(value & 0x7FL | 0x80L));
            byteBuffer.put((byte)(value >>> 7 | 0x80L));
            byteBuffer.put((byte)(value >>> 14 | 0x80L));
            byteBuffer.put((byte)(value >>> 21 | 0x80L));
            byteBuffer.put((byte)(value >>> 28 | 0x80L));
            byteBuffer.put((byte)(value >>> 35 | 0x80L));
            byteBuffer.put((byte)(value >>> 42 | 0x80L));
            byteBuffer.put((byte)(value >>> 49));
            return 8;
        }
        this.require(9);
        this.position += 9;
        ByteBuffer byteBuffer = this.byteBuffer;
        byteBuffer.put((byte)(value & 0x7FL | 0x80L));
        byteBuffer.put((byte)(value >>> 7 | 0x80L));
        byteBuffer.put((byte)(value >>> 14 | 0x80L));
        byteBuffer.put((byte)(value >>> 21 | 0x80L));
        byteBuffer.put((byte)(value >>> 28 | 0x80L));
        byteBuffer.put((byte)(value >>> 35 | 0x80L));
        byteBuffer.put((byte)(value >>> 42 | 0x80L));
        byteBuffer.put((byte)(value >>> 49 | 0x80L));
        byteBuffer.put((byte)(value >>> 56));
        return 9;
    }

    @Override
    public void writeFloat(float value) throws KryoException {
        this.require(4);
        ByteBuffer byteBuffer = this.byteBuffer;
        this.position += 4;
        int intValue = Float.floatToIntBits(value);
        byteBuffer.put((byte)intValue);
        byteBuffer.put((byte)(intValue >> 8));
        byteBuffer.put((byte)(intValue >> 16));
        byteBuffer.put((byte)(intValue >> 24));
    }

    @Override
    public void writeDouble(double value) throws KryoException {
        this.require(8);
        this.position += 8;
        ByteBuffer byteBuffer = this.byteBuffer;
        long longValue = Double.doubleToLongBits(value);
        byteBuffer.put((byte)longValue);
        byteBuffer.put((byte)(longValue >>> 8));
        byteBuffer.put((byte)(longValue >>> 16));
        byteBuffer.put((byte)(longValue >>> 24));
        byteBuffer.put((byte)(longValue >>> 32));
        byteBuffer.put((byte)(longValue >>> 40));
        byteBuffer.put((byte)(longValue >>> 48));
        byteBuffer.put((byte)(longValue >>> 56));
    }

    @Override
    public void writeShort(int value) throws KryoException {
        this.require(2);
        this.position += 2;
        this.byteBuffer.put((byte)value);
        this.byteBuffer.put((byte)(value >>> 8));
    }

    @Override
    public void writeChar(char value) throws KryoException {
        this.require(2);
        this.position += 2;
        this.byteBuffer.put((byte)value);
        this.byteBuffer.put((byte)(value >>> 8));
    }

    @Override
    public void writeBoolean(boolean value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.byteBuffer.put((byte)(value ? 1 : 0));
        ++this.position;
    }

    @Override
    public void writeString(String value) throws KryoException {
        int charCount;
        block11: {
            if (value == null) {
                this.writeByte(128);
                return;
            }
            charCount = value.length();
            if (charCount == 0) {
                this.writeByte(129);
                return;
            }
            if (charCount > 1 && charCount <= 32) {
                int i;
                for (i = 0; i < charCount; ++i) {
                    if (value.charAt(i) <= '\u007f') {
                        continue;
                    }
                    break block11;
                }
                if (this.capacity - this.position < charCount) {
                    this.writeAscii_slow(value, charCount);
                } else {
                    int n = value.length();
                    for (i = 0; i < n; ++i) {
                        this.byteBuffer.put((byte)value.charAt(i));
                    }
                    this.position += charCount;
                }
                this.byteBuffer.put(this.position - 1, (byte)(this.byteBuffer.get(this.position - 1) | 0x80));
                return;
            }
        }
        this.writeVarIntFlag(true, charCount + 1, true);
        int charIndex = 0;
        if (this.capacity - this.position >= charCount) {
            char c;
            ByteBuffer byteBuffer = this.byteBuffer;
            while ((c = value.charAt(charIndex)) <= '\u007f') {
                byteBuffer.put((byte)c);
                if (++charIndex != charCount) continue;
                this.position = byteBuffer.position();
                return;
            }
            this.position = byteBuffer.position();
        }
        if (charIndex < charCount) {
            this.writeUtf8_slow(value, charCount, charIndex);
        }
    }

    @Override
    public void writeAscii(String value) throws KryoException {
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        if (this.capacity - this.position < charCount) {
            this.writeAscii_slow(value, charCount);
        } else {
            ByteBuffer byteBuffer = this.byteBuffer;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                byteBuffer.put((byte)value.charAt(i));
            }
            this.position += charCount;
        }
        this.byteBuffer.put(this.position - 1, (byte)(this.byteBuffer.get(this.position - 1) | 0x80));
    }

    private void writeUtf8_slow(String value, int charCount, int charIndex) {
        while (charIndex < charCount) {
            if (this.position == this.capacity) {
                this.require(Math.min(this.capacity, charCount - charIndex));
            }
            ++this.position;
            char c = value.charAt(charIndex);
            if (c <= '\u007f') {
                this.byteBuffer.put((byte)c);
            } else if (c > '\u07ff') {
                this.byteBuffer.put((byte)(0xE0 | c >> 12 & 0xF));
                this.require(2);
                this.position += 2;
                this.byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                this.byteBuffer.put((byte)(0x80 | c & 0x3F));
            } else {
                this.byteBuffer.put((byte)(0xC0 | c >> 6 & 0x1F));
                if (this.position == this.capacity) {
                    this.require(1);
                }
                ++this.position;
                this.byteBuffer.put((byte)(0x80 | c & 0x3F));
            }
            ++charIndex;
        }
    }

    private void writeAscii_slow(String value, int charCount) throws KryoException {
        ByteBuffer buffer = this.byteBuffer;
        int charIndex = 0;
        int charsToWrite = Math.min(charCount, this.capacity - this.position);
        while (charIndex < charCount) {
            byte[] tmp = new byte[charCount];
            value.getBytes(charIndex, charIndex + charsToWrite, tmp, 0);
            buffer.put(tmp, 0, charsToWrite);
            this.position += charsToWrite;
            if (!this.require(charsToWrite = Math.min(charCount - (charIndex += charsToWrite), this.capacity))) continue;
            buffer = this.byteBuffer;
        }
    }

    @Override
    public void writeInts(int[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 2) {
            this.require(count << 2);
            ByteBuffer byteBuffer = this.byteBuffer;
            int n = offset + count;
            while (offset < n) {
                int value = array[offset];
                byteBuffer.put((byte)value);
                byteBuffer.put((byte)(value >> 8));
                byteBuffer.put((byte)(value >> 16));
                byteBuffer.put((byte)(value >> 24));
                ++offset;
            }
            this.position = byteBuffer.position();
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeInt(array[offset]);
                ++offset;
            }
        }
    }

    @Override
    public void writeLongs(long[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 3) {
            this.require(count << 3);
            ByteBuffer byteBuffer = this.byteBuffer;
            int n = offset + count;
            while (offset < n) {
                long value = array[offset];
                byteBuffer.put((byte)value);
                byteBuffer.put((byte)(value >>> 8));
                byteBuffer.put((byte)(value >>> 16));
                byteBuffer.put((byte)(value >>> 24));
                byteBuffer.put((byte)(value >>> 32));
                byteBuffer.put((byte)(value >>> 40));
                byteBuffer.put((byte)(value >>> 48));
                byteBuffer.put((byte)(value >>> 56));
                ++offset;
            }
            this.position = byteBuffer.position();
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeLong(array[offset]);
                ++offset;
            }
        }
    }

    @Override
    public void writeFloats(float[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 2) {
            this.require(count << 2);
            ByteBuffer byteBuffer = this.byteBuffer;
            int n = offset + count;
            while (offset < n) {
                int value = Float.floatToIntBits(array[offset]);
                byteBuffer.put((byte)value);
                byteBuffer.put((byte)(value >> 8));
                byteBuffer.put((byte)(value >> 16));
                byteBuffer.put((byte)(value >> 24));
                ++offset;
            }
            this.position = byteBuffer.position();
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeFloat(array[offset]);
                ++offset;
            }
        }
    }

    @Override
    public void writeDoubles(double[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 3) {
            this.require(count << 3);
            ByteBuffer byteBuffer = this.byteBuffer;
            int n = offset + count;
            while (offset < n) {
                long value = Double.doubleToLongBits(array[offset]);
                byteBuffer.put((byte)value);
                byteBuffer.put((byte)(value >>> 8));
                byteBuffer.put((byte)(value >>> 16));
                byteBuffer.put((byte)(value >>> 24));
                byteBuffer.put((byte)(value >>> 32));
                byteBuffer.put((byte)(value >>> 40));
                byteBuffer.put((byte)(value >>> 48));
                byteBuffer.put((byte)(value >>> 56));
                ++offset;
            }
            this.position = byteBuffer.position();
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeDouble(array[offset]);
                ++offset;
            }
        }
    }

    @Override
    public void writeShorts(short[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 1) {
            this.require(count << 1);
            int n = offset + count;
            while (offset < n) {
                short value = array[offset];
                this.byteBuffer.put((byte)value);
                this.byteBuffer.put((byte)(value >>> 8));
                ++offset;
            }
            this.position = this.byteBuffer.position();
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeShort(array[offset]);
                ++offset;
            }
        }
    }

    @Override
    public void writeChars(char[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 1) {
            this.require(count << 1);
            int n = offset + count;
            while (offset < n) {
                char value = array[offset];
                this.byteBuffer.put((byte)value);
                this.byteBuffer.put((byte)(value >>> 8));
                ++offset;
            }
            this.position = this.byteBuffer.position();
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeChar(array[offset]);
                ++offset;
            }
        }
    }

    @Override
    public void writeBooleans(boolean[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count) {
            this.require(count);
            int n = offset + count;
            while (offset < n) {
                this.byteBuffer.put(array[offset] ? (byte)1 : 0);
                ++offset;
            }
            this.position = this.byteBuffer.position();
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeBoolean(array[offset]);
                ++offset;
            }
        }
    }
}

