/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nailgun;

import com.facebook.nailgun.Alias;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class AliasManager {
    private Map aliases = new HashMap();

    public AliasManager() {
        Properties props = new Properties();
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try (InputStream is = cl.getResourceAsStream("com/facebook/nailgun/builtins/builtins.properties");){
            props.load(is);
            this.loadFromProperties(props);
        }
        catch (IOException e) {
            System.err.println("Unable to load builtins.properties: " + e.getMessage());
        }
    }

    public void loadFromProperties(Properties properties) {
        for (String string : properties.keySet()) {
            if (string.endsWith(".desc")) continue;
            try {
                Class<?> clazz = Class.forName(properties.getProperty(string));
                String desc = properties.getProperty(string + ".desc", "");
                this.addAlias(new Alias(string, desc, clazz));
            }
            catch (ClassNotFoundException e) {
                System.err.println("Unable to locate class " + properties.getProperty(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlias(Alias alias) {
        Map map = this.aliases;
        synchronized (map) {
            this.aliases.put(alias.getName(), alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAliases() {
        TreeSet result = new TreeSet();
        Map map = this.aliases;
        synchronized (map) {
            result.addAll(this.aliases.values());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String aliasName) {
        Map map = this.aliases;
        synchronized (map) {
            this.aliases.remove(aliasName);
        }
    }

    public Alias getAlias(String aliasName) {
        return (Alias)this.aliases.get(aliasName);
    }
}

