/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nailgun;

import com.facebook.nailgun.NGServer;
import com.facebook.nailgun.NGSession;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class NGSessionPool {
    final Queue<NGSession> idlePool;
    final Set<NGSession> workingPool;
    final int maxIdleSessions;
    final NGServer server;
    final Supplier<NGSession> instanceCreator;
    boolean done = false;
    private final Object lock = new Object();

    NGSessionPool(NGServer server, int maxIdleSessions) {
        this(server, maxIdleSessions, null);
    }

    NGSessionPool(NGServer server, int maxIdleSessions, Supplier<NGSession> instanceCreator) {
        this.server = server;
        this.maxIdleSessions = Math.max(0, maxIdleSessions);
        this.idlePool = new LinkedList<NGSession>();
        this.workingPool = new HashSet<NGSession>();
        this.instanceCreator = instanceCreator != null ? instanceCreator : () -> new NGSession(this, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NGSession take() {
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                throw new UnsupportedOperationException("NGSession pool is shutting down");
            }
            NGSession session = this.idlePool.poll();
            if (session == null) {
                session = this.instanceCreator.get();
                session.start();
            }
            this.workingPool.add(session);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void give(NGSession session) {
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                return;
            }
            this.workingPool.remove(session);
            if (this.idlePool.size() < this.maxIdleSessions) {
                this.idlePool.add(session);
                return;
            }
        }
        session.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() throws InterruptedException {
        List allSessions;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            this.done = true;
            allSessions = Stream.concat(this.workingPool.stream(), this.idlePool.stream()).collect(Collectors.toList());
            this.idlePool.clear();
            this.workingPool.clear();
        }
        for (NGSession session : allSessions) {
            session.shutdown();
        }
        long start = System.nanoTime();
        for (NGSession session : allSessions) {
            long timeout = 30000L - TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            if (timeout < 1L) {
                timeout = 1L;
            }
            session.join(timeout);
            if (!session.isAlive()) continue;
            throw new IllegalStateException("NGSession has not completed in 30000 ms");
        }
    }
}

