/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nailgun;

import com.facebook.nailgun.NGWin32NamedPipeLibrary;
import com.facebook.nailgun.NGWin32NamedPipeSocket;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;

public class NGWin32NamedPipeServerSocket
extends ServerSocket {
    private static final NGWin32NamedPipeLibrary API = NGWin32NamedPipeLibrary.INSTANCE;
    private static final String WIN32_PIPE_PREFIX = "\\\\.\\pipe\\";
    private static final int BUFFER_SIZE = 65535;
    private final LinkedBlockingQueue<WinNT.HANDLE> openHandles = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<WinNT.HANDLE> connectedHandles = new LinkedBlockingQueue();
    private final NGWin32NamedPipeSocket.CloseCallback closeCallback = handle -> {
        if (this.connectedHandles.remove(handle)) {
            this.closeConnectedPipe(handle, false);
        }
        if (this.openHandles.remove(handle)) {
            this.closeOpenPipe(handle);
        }
    };
    private final String path;
    private final int maxInstances;
    private final WinNT.HANDLE lockHandle;
    private final boolean requireStrictLength;

    public NGWin32NamedPipeServerSocket(String path) throws IOException {
        this(255, path);
    }

    public NGWin32NamedPipeServerSocket(String path, boolean requireStrictLength) throws IOException {
        this(255, path, requireStrictLength);
    }

    public NGWin32NamedPipeServerSocket(int maxInstances, String path) throws IOException {
        this(maxInstances, path, false);
    }

    public NGWin32NamedPipeServerSocket(int maxInstances, String path, boolean requireStrictLength) throws IOException {
        this.maxInstances = maxInstances;
        this.requireStrictLength = requireStrictLength;
        this.path = !path.startsWith(WIN32_PIPE_PREFIX) ? WIN32_PIPE_PREFIX + path : path;
        String lockPath = this.path + "_lock";
        this.lockHandle = API.CreateNamedPipe(lockPath, 524291, 0, 1, 65535, 65535, 0, null);
        if (this.lockHandle == NGWin32NamedPipeLibrary.INVALID_HANDLE_VALUE) {
            throw new IOException(String.format("Could not create lock for %s, error %d", lockPath, API.GetLastError()));
        }
        if (!API.DisconnectNamedPipe(this.lockHandle)) {
            throw new IOException(String.format("Could not disconnect lock %d", API.GetLastError()));
        }
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        throw new IOException("Win32 named pipes do not support bind(), pass path to constructor");
    }

    @Override
    public Socket accept() throws IOException {
        WinNT.HANDLE handle = API.CreateNamedPipe(this.path, 0x40000003, 0, this.maxInstances, 65535, 65535, 0, null);
        if (handle == NGWin32NamedPipeLibrary.INVALID_HANDLE_VALUE) {
            throw new IOException(String.format("Could not create named pipe, error %d", API.GetLastError()));
        }
        this.openHandles.add(handle);
        WinNT.HANDLE connWaitable = API.CreateEvent(null, true, false, null);
        WinBase.OVERLAPPED olap = new WinBase.OVERLAPPED();
        olap.hEvent = connWaitable;
        olap.write();
        boolean immediate = API.ConnectNamedPipe(handle, olap.getPointer());
        if (immediate) {
            this.openHandles.remove(handle);
            this.connectedHandles.add(handle);
            return new NGWin32NamedPipeSocket(handle, this.closeCallback, this.requireStrictLength);
        }
        int connectError = API.GetLastError();
        if (connectError == 535) {
            this.openHandles.remove(handle);
            this.connectedHandles.add(handle);
            return new NGWin32NamedPipeSocket(handle, this.closeCallback, this.requireStrictLength);
        }
        if (connectError == 232) {
            return new NGWin32NamedPipeSocket(handle, this.closeCallback, this.requireStrictLength);
        }
        if (connectError == 997) {
            if (!API.GetOverlappedResult(handle, olap.getPointer(), new IntByReference(), true)) {
                this.openHandles.remove(handle);
                this.closeOpenPipe(handle);
                throw new IOException("GetOverlappedResult() failed for connect operation: " + API.GetLastError());
            }
            this.openHandles.remove(handle);
            this.connectedHandles.add(handle);
            return new NGWin32NamedPipeSocket(handle, this.closeCallback, this.requireStrictLength);
        }
        throw new IOException("ConnectNamedPipe() failed with: " + connectError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            ArrayList handlesToClose = new ArrayList();
            this.openHandles.drainTo(handlesToClose);
            for (WinNT.HANDLE handle : handlesToClose) {
                this.closeOpenPipe(handle);
            }
            ArrayList handlesToDisconnect = new ArrayList();
            this.connectedHandles.drainTo(handlesToDisconnect);
            for (WinNT.HANDLE handle : handlesToDisconnect) {
                this.closeConnectedPipe(handle, true);
            }
        }
        finally {
            API.CloseHandle(this.lockHandle);
        }
    }

    private void closeOpenPipe(WinNT.HANDLE handle) throws IOException {
        API.CancelIoEx(handle, null);
        API.CloseHandle(handle);
    }

    private void closeConnectedPipe(WinNT.HANDLE handle, boolean shutdown) throws IOException {
        if (!shutdown) {
            API.WaitForSingleObject(handle, 10000);
        }
        API.DisconnectNamedPipe(handle);
        API.CloseHandle(handle);
    }
}

