/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.winium;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class WiniumDriverService
extends DriverService {
    public static final String WINIUM_DRIVER_VERBOSE_LOG = "webdriver.winium.verbose";
    public static final String WINIUM_DRIVER_SILENT = "webdriver.winium.silent";
    public static final String WINIUM_DRIVER_LOG_PATH_PROPERTY = "webdriver.winium.logpath";

    public static WiniumDriverService createDesktopService() {
        return ((Builder)new Builder().usingAnyFreePort()).buildDesktopService();
    }

    public static WiniumDriverService createSilverlightService() {
        return ((Builder)new Builder().usingAnyFreePort()).buildSilverlightService();
    }

    public static WiniumDriverService createStoreAppsService() {
        return ((Builder)new Builder().usingAnyFreePort()).buildStoreAppsService();
    }

    protected WiniumDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static class Builder
    extends DriverService.Builder<WiniumDriverService, Builder> {
        private static final String DESKTOP_DRIVER_SERVICE_FILENAME = "Winium.Desktop.Driver.exe";
        private static final String SILVERLIGHT_DRIVER_SERVICE_FILENAME = "WindowsPhoneDriver.OuterDriver.exe";
        private static final String STORE_APPS_DRIVER_SERVICE_FILENAME = "Winium.StoreApps.Driver.exe";
        private static final String DESKTOP_DRIVER_EXE_PROPERTY = "webdriver.winium.driver.desktop";
        private static final String SILVERLIGHT_DRIVER_EXE_PROPERTY = "webdriver.winium.driver.silverlight";
        private static final String STORE_APPS_DRIVER_EXE_PROPERTY = "webdriver.winium.driver.storeaps";
        private static final String DESKTOP_DRIVER_DOCS_URL = "https://github.com/2gis/Winium.Desktop";
        private static final String SILVERLIGHT_DRIVER_DOCS_URL = "https://github.com/2gis/winphonedriver";
        private static final String STORE_APPS_DRIVER_DOCS_URL = "https://github.com/2gis/Winium.StoreApps";
        private static final String DESKTOP_DRIVER_DOWNLOAD_URL = "https://github.com/2gis/Winium.Desktop/releases";
        private static final String SILVERLIGHT_DRIVER_DOWNLOAD_URL = "https://github.com/2gis/winphonedriver/releases";
        private static final String STORE_APPS_DRIVER_DOWNLOAD_URL = "https://github.com/2gis/Winium.StoreApps/releases";
        private File exe = null;
        private boolean verbose = Boolean.getBoolean("webdriver.winium.verbose");
        private boolean silent = Boolean.getBoolean("webdriver.winium.silent");

        public Builder usingDriverExecutable(File file) {
            Preconditions.checkNotNull((Object)file);
            WiniumDriverService.checkExecutable((File)file);
            this.exe = file;
            return this;
        }

        public Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder withSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public WiniumDriverService buildDesktopService() {
            int port = this.getPort();
            if (port == 0) {
                port = PortProber.findFreePort();
            }
            if (this.exe == null) {
                this.exe = this.findDesktopDriverExecutable();
            }
            try {
                return new WiniumDriverService(this.exe, port, this.createArgs(), (ImmutableMap<String, String>)ImmutableMap.of());
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }

        public WiniumDriverService buildSilverlightService() {
            int port = this.getPort();
            if (port == 0) {
                port = PortProber.findFreePort();
            }
            if (this.exe == null) {
                this.exe = this.findSilverlightDriverExecutable();
            }
            try {
                return new WiniumDriverService(this.exe, port, this.createArgs(), (ImmutableMap<String, String>)ImmutableMap.of());
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }

        public WiniumDriverService buildStoreAppsService() {
            int port = this.getPort();
            if (port == 0) {
                port = PortProber.findFreePort();
            }
            if (this.exe == null) {
                this.exe = this.findStoreAppsDriverExecutable();
            }
            try {
                return new WiniumDriverService(this.exe, port, this.createArgs(), (ImmutableMap<String, String>)ImmutableMap.of());
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }

        protected File findDefaultExecutable() {
            return this.findDesktopDriverExecutable();
        }

        protected ImmutableList<String> createArgs() {
            String logFilePath;
            if (this.getLogFile() == null && (logFilePath = System.getProperty(WiniumDriverService.WINIUM_DRIVER_LOG_PATH_PROPERTY)) != null) {
                this.withLogFile(new File(logFilePath));
            }
            ImmutableList.Builder argsBuidler = new ImmutableList.Builder();
            if (this.silent) {
                argsBuidler.add((Object)"--silent");
            }
            if (this.verbose) {
                argsBuidler.add((Object)"--verbose");
            }
            if (this.getLogFile() != null) {
                argsBuidler.add((Object)String.format("--log-path=%s", this.getLogFile().getAbsolutePath()));
            }
            return argsBuidler.build();
        }

        protected WiniumDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new WiniumDriverService(exe, port, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }

        private File findDesktopDriverExecutable() {
            return WiniumDriverService.findExecutable((String)DESKTOP_DRIVER_SERVICE_FILENAME, (String)DESKTOP_DRIVER_EXE_PROPERTY, (String)DESKTOP_DRIVER_DOCS_URL, (String)DESKTOP_DRIVER_DOWNLOAD_URL);
        }

        private File findSilverlightDriverExecutable() {
            return WiniumDriverService.findExecutable((String)SILVERLIGHT_DRIVER_SERVICE_FILENAME, (String)SILVERLIGHT_DRIVER_EXE_PROPERTY, (String)SILVERLIGHT_DRIVER_DOCS_URL, (String)SILVERLIGHT_DRIVER_DOWNLOAD_URL);
        }

        private File findStoreAppsDriverExecutable() {
            return WiniumDriverService.findExecutable((String)STORE_APPS_DRIVER_SERVICE_FILENAME, (String)STORE_APPS_DRIVER_EXE_PROPERTY, (String)STORE_APPS_DRIVER_DOCS_URL, (String)STORE_APPS_DRIVER_DOWNLOAD_URL);
        }
    }
}

