/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.plexus.util.DirectoryScanner;

public class FileHelper {
    private FileHelper() {
    }

    public static String relativizePath(File base, File target) {
        Path targetPath = FileHelper.absoluteFileToCanonicalFile(target.getAbsoluteFile()).toPath();
        if (base == null) {
            return targetPath.toString();
        }
        Path basePath = FileHelper.absoluteFileToCanonicalFile(base.getAbsoluteFile()).toPath();
        return basePath.relativize(targetPath).toString().replace(File.separatorChar, '/');
    }

    public static String relativizeRelativePath(File base, File target) {
        Path targetPath = target.toPath();
        if (base == null) {
            return targetPath.toString();
        }
        Path basePath = base.toPath();
        return basePath.relativize(targetPath).toString().replace(File.separatorChar, '/');
    }

    public static File getFile(File directory, String ... names) {
        return FileUtils.getFile((File)directory, (String[])((String[])Arrays.stream(names).filter(StringUtils::isNotEmpty).toArray(String[]::new)));
    }

    public static File getAbsoluteFile(File basedir, File ... files) {
        if (files == null) {
            return basedir;
        }
        File result = basedir;
        for (File file : files) {
            if (file == null) continue;
            result = file.isAbsolute() ? file : new File(result, file.getPath());
        }
        return result;
    }

    public static File getAbsoluteFile(File basedir, String ... files) {
        if (files == null) {
            return basedir;
        }
        File[] fileObjects = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            fileObjects[i] = files[i] != null ? new File(files[i]) : null;
        }
        return FileHelper.getAbsoluteFile(basedir, fileObjects);
    }

    public static List<File> getIncludedFiles(File baseDir, List<String> includes, List<String> excludes) {
        if (CollectionUtils.isEmpty(includes)) {
            return new ArrayList<File>();
        }
        if (!baseDir.exists()) {
            return new ArrayList<File>();
        }
        String[] excludesArray = excludes.toArray(new String[0]);
        return IntStream.range(0, includes.size()).mapToObj(i -> Pair.of((Object)i, (Object)((String)includes.get(i)))).flatMap(include -> {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(new String[]{(String)include.getRight()});
            scanner.setExcludes(excludesArray);
            scanner.addDefaultExcludes();
            scanner.setBasedir(baseDir);
            scanner.scan();
            return Arrays.stream(scanner.getIncludedFiles()).map(includedFilename -> {
                File includedFile = new File(baseDir, (String)includedFilename);
                return Pair.of((Object)((Integer)include.getLeft()), (Object)FileHelper.absoluteFileToCanonicalFile(includedFile));
            });
        }).sorted().map(Pair::getRight).filter(FileHelper.distinctByKey(File::getAbsolutePath)).collect(Collectors.toList());
    }

    public static File absoluteFileToCanonicalFile(File file) {
        try {
            return file != null && file.isAbsolute() ? file.getCanonicalFile() : file;
        }
        catch (IOException e) {
            return file;
        }
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        HashSet seen = new HashSet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static boolean startsWithBom(File file, Charset encoding) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            boolean bl;
            try (InputStreamReader reader = new InputStreamReader((InputStream)input, encoding);){
                int firstChar = reader.read();
                bl = firstChar == 65279;
            }
            return bl;
        }
    }
}

