/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import com.github.blutorange.maven.plugin.closurecompiler.common.FileHelper;
import com.google.javascript.jscomp.SourceMap;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

final class FileSystemLocationMapping
implements SourceMap.LocationMapping {
    private final File baseDirForSourceFiles;
    private final File sourceMapDir;
    private final Log log;
    private boolean transpilationDone;

    public FileSystemLocationMapping(Log log, File baseDirForSourceFiles, File sourceMapFile) {
        this.log = log;
        this.baseDirForSourceFiles = baseDirForSourceFiles;
        this.sourceMapDir = sourceMapFile.getParentFile();
    }

    public String map(String location) {
        String mapped;
        if (this.transpilationDone) {
            mapped = location;
        } else if (StringUtils.startsWith((CharSequence)StringUtils.trim((String)location), (CharSequence)"[")) {
            mapped = location;
        } else {
            File file = new File(this.baseDirForSourceFiles, location);
            mapped = FilenameUtils.separatorsToUnix((String)FileHelper.relativizePath(this.sourceMapDir, file));
        }
        this.log.debug((CharSequence)("Source map: mapping location [" + location + "] to [" + mapped + "]"));
        return mapped;
    }

    public void setTranspilationDone(boolean transpilationDone) {
        this.transpilationDone = transpilationDone;
    }
}

