/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.apache.maven.plugin.logging.Log;

final class SourceFilesEnumeration
implements Enumeration<InputStream> {
    private final List<InputStreamSupplier> suppliers = new ArrayList<InputStreamSupplier>();
    private int current = 0;

    public SourceFilesEnumeration(Log log, List<File> files, Charset charset, String lineSeparator) {
        int j = files.size();
        for (int i = 0; i < j; ++i) {
            File file = files.get(i);
            log.info((CharSequence)("Processing source file [" + file.getName() + "]."));
            log.debug((CharSequence)("Full path is [" + file.getPath() + "]."));
            this.suppliers.add(new FileInputStreamSupplier(file));
            if (i >= j - 1) continue;
            this.suppliers.add(new NewlineInputStreamSupplier(charset, lineSeparator));
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.current < this.suppliers.size();
    }

    @Override
    public InputStream nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException("No more files!");
        }
        InputStreamSupplier nextElement = this.suppliers.get(this.current);
        ++this.current;
        return (InputStream)nextElement.get();
    }

    private static class FileInputStreamSupplier
    implements InputStreamSupplier {
        private final File file;

        public FileInputStreamSupplier(File file) {
            this.file = file;
        }

        @Override
        public InputStream get() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new NoSuchElementException("The path [" + this.file.getPath() + "] cannot be found.");
            }
        }
    }

    private static class NewlineInputStreamSupplier
    implements InputStreamSupplier {
        private final Charset charset;
        private final String lineSeparator;

        public NewlineInputStreamSupplier(Charset charset, String lineSeparator) {
            this.charset = charset;
            this.lineSeparator = lineSeparator;
        }

        @Override
        public InputStream get() {
            return new ByteArrayInputStream(this.lineSeparator.getBytes(this.charset));
        }
    }

    private static interface InputStreamSupplier
    extends Supplier<InputStream> {
    }
}

