/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import com.github.blutorange.maven.plugin.closurecompiler.common.TextFileModification;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

final class TextFileModifications {
    TextFileModifications() {
    }

    public static boolean applyAndWrite(File file, Charset encoding, List<TextFileModification> modifications) throws IOException {
        String modifiedContent;
        boolean hasChanges;
        String textContent = FileUtils.readFileToString((File)file, (Charset)encoding);
        boolean bl = hasChanges = !Objects.equals(textContent, modifiedContent = TextFileModifications.apply(textContent, modifications));
        if (hasChanges) {
            FileUtils.writeStringToFile((File)file, (String)modifiedContent, (Charset)encoding);
        }
        return hasChanges;
    }

    public static String apply(String textContent, List<TextFileModification> modifications) {
        List sortedModifications = modifications.stream().sorted(Comparator.comparing(TextFileModification::getStartPosition).reversed()).collect(Collectors.toList());
        for (TextFileModification modification : sortedModifications) {
            textContent = TextFileModifications.applyModification(textContent, modification);
        }
        return textContent;
    }

    private static String applyModification(String content, TextFileModification modification) {
        return StringUtils.substring((String)content, (int)0, (int)modification.getStartPosition()) + modification.getReplacement() + StringUtils.substring((String)content, (int)modification.getEndPosition());
    }
}

