/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.FileUtils;
import com.github.danielflower.mavenplugins.release.GitHelper;
import com.github.danielflower.mavenplugins.release.GitOperations;
import com.github.danielflower.mavenplugins.release.LocalTagFetcher;
import com.github.danielflower.mavenplugins.release.LocalTagPusher;
import com.github.danielflower.mavenplugins.release.RemoteTagFetcher;
import com.github.danielflower.mavenplugins.release.RemoteTagPusher;
import com.github.danielflower.mavenplugins.release.TagFetcher;
import com.github.danielflower.mavenplugins.release.TagPusher;
import com.github.danielflower.mavenplugins.release.ValidationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;

public class LocalGitRepo {
    public final Git git;
    private boolean hasReverted = false;
    private Collection<Ref> tags;
    private final TagFetcher tagFetcher;
    private final TagPusher tagPusher;

    LocalGitRepo(Git git, TagFetcher tagFetcher, TagPusher tagPusher) {
        this.git = git;
        this.tagFetcher = tagFetcher;
        this.tagPusher = tagPusher;
    }

    public void errorIfNotClean(Set<String> ignoredUntrackedPaths) throws ValidationException {
        boolean isClean;
        Status status = this.currentStatus();
        HashSet untracked = new HashSet(status.getUntracked());
        untracked.removeAll(ignoredUntrackedPaths);
        boolean bl = isClean = !status.hasUncommittedChanges() && untracked.isEmpty();
        if (!isClean) {
            String summary = "Cannot release with uncommitted changes. Please check the following files:";
            ArrayList<String> message = new ArrayList<String>();
            message.add(summary);
            Set uncommittedChanges = status.getUncommittedChanges();
            if (!uncommittedChanges.isEmpty()) {
                message.add("Uncommitted:");
                for (String path : uncommittedChanges) {
                    message.add(" * " + path);
                }
            }
            if (!untracked.isEmpty()) {
                message.add("Untracked:");
                for (String path : untracked) {
                    message.add(" * " + path);
                }
            }
            message.add("Please commit or revert these changes before releasing.");
            throw new ValidationException(summary, message);
        }
    }

    private Status currentStatus() throws ValidationException {
        Status status;
        try {
            status = this.git.status().call();
        }
        catch (GitAPIException e) {
            throw new ValidationException("Error while checking if the Git repo is clean", e);
        }
        return status;
    }

    public boolean revertChanges(Log log, List<File> changedFiles) throws MojoExecutionException {
        if (this.hasReverted) {
            return true;
        }
        boolean hasErrors = false;
        File workTree = this.workingDir();
        for (File changedFile : changedFiles) {
            try {
                String pathRelativeToWorkingTree = Repository.stripWorkDir((File)workTree, (File)changedFile);
                this.git.checkout().addPath(pathRelativeToWorkingTree).call();
            }
            catch (Exception e) {
                hasErrors = true;
                log.error((CharSequence)("Unable to revert changes to " + changedFile + " - you may need to manually revert this file. Error was: " + e.getMessage()));
            }
        }
        this.hasReverted = true;
        return !hasErrors;
    }

    private File workingDir() throws MojoExecutionException {
        try {
            return this.git.getRepository().getWorkTree().getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not locate the working directory of the Git repo", (Exception)e);
        }
    }

    public boolean hasLocalTag(String tagName) throws GitAPIException {
        return GitHelper.hasLocalTag(this.git, tagName);
    }

    public void tagAndPushRepo(Collection<AnnotatedTag> tags) throws GitAPIException {
        this.tagPusher.pushTags(tags);
    }

    private static File getGitRootIfItExistsInOneOfTheParentDirectories(File candidateDir) {
        while (candidateDir != null && !candidateDir.getName().equals("target")) {
            if (new File(candidateDir, ".git").isDirectory()) {
                return candidateDir;
            }
            candidateDir = candidateDir.getParentFile();
        }
        return null;
    }

    public List<String> tagsFrom(List<AnnotatedTag> annotatedTags) throws GitAPIException {
        ArrayList<String> tagNames = new ArrayList<String>();
        for (AnnotatedTag annotatedTag : annotatedTags) {
            tagNames.add(annotatedTag.name());
        }
        return this.getTags(tagNames);
    }

    public List<String> getTags(List<String> tagNamesToSearchFor) throws GitAPIException {
        ArrayList<String> results = new ArrayList<String>();
        Collection<Ref> remoteTags = this.allTags();
        for (Ref remoteTag : remoteTags) {
            for (String proposedTag : tagNamesToSearchFor) {
                if (!remoteTag.getName().equals("refs/tags/" + proposedTag)) continue;
                results.add(proposedTag);
            }
        }
        return results;
    }

    public Collection<Ref> allTags() throws GitAPIException {
        if (this.tags == null) {
            this.tags = this.tagFetcher.getTags();
        }
        return this.tags;
    }

    public static class Builder {
        private Set<GitOperations> operationsAllowed = EnumSet.allOf(GitOperations.class);
        private String remoteGitUrl;
        private CredentialsProvider credentialsProvider;

        public Builder remoteGitOperationsAllowed(Set<GitOperations> operationsAllowed) {
            this.operationsAllowed = EnumSet.copyOf(operationsAllowed);
            return this;
        }

        public Builder remoteGitUrl(String remoteUrl) {
            this.remoteGitUrl = remoteUrl;
            return this;
        }

        public Builder credentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public LocalGitRepo buildFromCurrentDir() throws ValidationException {
            Git git;
            File gitDir = new File(".");
            try {
                git = Git.open((File)gitDir);
            }
            catch (RepositoryNotFoundException rnfe) {
                String summary;
                String fullPathOfCurrentDir = FileUtils.pathOf(gitDir);
                File gitRoot = LocalGitRepo.getGitRootIfItExistsInOneOfTheParentDirectories(new File(fullPathOfCurrentDir));
                ArrayList<String> messages = new ArrayList<String>();
                if (gitRoot == null) {
                    summary = "Releases can only be performed from Git repositories.";
                    messages.add(summary);
                    messages.add(fullPathOfCurrentDir + " is not a Git repository.");
                } else {
                    summary = "The release plugin can only be run from the root folder of your Git repository";
                    messages.add(summary);
                    messages.add(fullPathOfCurrentDir + " is not the root of a Git repository");
                    messages.add("Try running the release plugin from " + FileUtils.pathOf(gitRoot));
                }
                throw new ValidationException(summary, messages);
            }
            catch (Exception e) {
                throw new ValidationException("Could not open git repository. Is " + FileUtils.pathOf(gitDir) + " a git repository?", Arrays.asList("Exception returned when accessing the git repo:", e.toString()));
            }
            TagFetcher tagFetcher = this.operationsAllowed.contains((Object)GitOperations.PULL_TAGS) ? new RemoteTagFetcher(git, this.remoteGitUrl, this.credentialsProvider) : new LocalTagFetcher(git);
            TagPusher tagPusher = this.operationsAllowed.contains((Object)GitOperations.PUSH_TAGS) ? new RemoteTagPusher(git, this.remoteGitUrl, this.credentialsProvider) : new LocalTagPusher(git);
            return new LocalGitRepo(git, tagFetcher, tagPusher);
        }
    }
}

