/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import java.util.List;
import java.util.Properties;
import org.apache.maven.project.MavenProject;

class MavenVersionResolver {
    MavenVersionResolver() {
    }

    static void resolveVersionsDefinedThroughProperties(List<MavenProject> projects) {
        for (MavenProject project : projects) {
            if (!MavenVersionResolver.isVersionDefinedWithProperty(project.getVersion())) continue;
            project.setVersion(MavenVersionResolver.resolveVersion(project.getVersion(), project.getProperties()));
        }
    }

    static String resolveVersion(String version, Properties projectProperties) {
        if (MavenVersionResolver.isVersionDefinedWithProperty(version)) {
            return projectProperties.getProperty(version.replace("${", "").replace("}", ""), version);
        }
        return version;
    }

    static boolean isSnapshot(String version) {
        return version != null && version.endsWith("-SNAPSHOT");
    }

    private static boolean isVersionDefinedWithProperty(String version) {
        return version != null && version.startsWith("${");
    }
}

