/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.TagFetcher;
import java.util.Collection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;

class RemoteTagFetcher
implements TagFetcher {
    private final Git git;
    private final String remoteUrl;
    private final CredentialsProvider credentialsProvider;

    public RemoteTagFetcher(Git git, String remoteUrl, CredentialsProvider credentialsProvider) {
        this.git = git;
        this.remoteUrl = remoteUrl;
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public Collection<Ref> getTags() throws GitAPIException {
        LsRemoteCommand lsRemoteCommand = (LsRemoteCommand)this.git.lsRemote().setTags(true).setHeads(false).setCredentialsProvider(this.credentialsProvider);
        if (this.remoteUrl != null) {
            lsRemoteCommand.setRemote(this.remoteUrl);
        }
        return lsRemoteCommand.call();
    }
}

