/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.internal.server.Command;
import org.subethamail.smtp.internal.server.HelpMessage;
import org.subethamail.smtp.server.Session;

public abstract class BaseCommand
implements Command {
    private static final Logger log = LoggerFactory.getLogger(BaseCommand.class);
    private final String name;
    private final HelpMessage helpMsg;

    protected BaseCommand(String name, String help) {
        this.name = name;
        this.helpMsg = new HelpMessage(name, help);
    }

    protected BaseCommand(String name, String help, String argumentDescription) {
        this.name = name;
        this.helpMsg = new HelpMessage(name, help, argumentDescription);
    }

    @Override
    public abstract void execute(String var1, Session var2) throws IOException, DropConnectionException;

    @Override
    public HelpMessage getHelp() {
        return this.helpMsg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String getArgPredicate(String commandString) {
        if (commandString == null || commandString.length() < 4) {
            return "";
        }
        return commandString.substring(4).trim();
    }

    public static String[] getArgs(String commandString) {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(commandString);
        while (stringTokenizer.hasMoreTokens()) {
            strings.add(stringTokenizer.nextToken());
        }
        return strings.toArray(new String[0]);
    }
}

