/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.wiser;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import org.subethamail.smtp.internal.Constants;

public final class WiserMessage {
    private final byte[] messageData;
    private final Session session;
    private final String envelopeSender;
    private final String envelopeReceiver;

    WiserMessage(Session session, String envelopeSender, String envelopeReceiver, byte[] messageData) {
        this.session = session;
        this.envelopeSender = envelopeSender;
        this.envelopeReceiver = envelopeReceiver;
        this.messageData = messageData;
    }

    public MimeMessage getMimeMessage() throws MessagingException {
        return new MimeMessage(this.session, (InputStream)new ByteArrayInputStream(this.messageData));
    }

    public byte[] getData() {
        return this.messageData;
    }

    public String getEnvelopeReceiver() {
        return this.envelopeReceiver;
    }

    public String getEnvelopeSender() {
        return this.envelopeSender;
    }

    public void dumpMessage(PrintStream out) throws MessagingException {
        out.println("===== Dumping message =====");
        out.println("Envelope sender: " + this.getEnvelopeSender());
        out.println("Envelope recipient: " + this.getEnvelopeReceiver());
        String content = new String(this.getData(), Constants.SMTP_CHARSET);
        out.println(content);
        out.println("===== End message dump =====");
    }

    public String toString() {
        if (this.getData() == null) {
            return "";
        }
        return new String(this.getData(), Constants.SMTP_CHARSET);
    }
}

