/*
 * Decompiled with CFR 0.152.
 */
package waffle.spring;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import waffle.spring.NegotiateSecurityFilter;

public class DelegatingNegotiateSecurityFilter
extends NegotiateSecurityFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NegotiateSecurityFilter.class);
    private AuthenticationManager authenticationManager;
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    private AuthenticationFailureHandler authenticationFailureHandler;
    private AccessDeniedHandler accessDeniedHandler;

    public DelegatingNegotiateSecurityFilter() {
        LOGGER.debug("[waffle.spring.NegotiateSecurityFilter] loaded");
    }

    public AccessDeniedHandler getAccessDeniedHandler() {
        return this.accessDeniedHandler;
    }

    public void setAccessDeniedHandler(AccessDeniedHandler value) {
        this.accessDeniedHandler = value;
    }

    public AuthenticationFailureHandler getAuthenticationFailureHandler() {
        return this.authenticationFailureHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler value) {
        this.authenticationFailureHandler = value;
    }

    @Override
    protected boolean setAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        block6: {
            try {
                if (this.authenticationManager != null) {
                    LOGGER.debug("Delegating to custom authenticationmanager");
                    Authentication customAuthentication = this.authenticationManager.authenticate(authentication);
                    SecurityContextHolder.getContext().setAuthentication(customAuthentication);
                }
                if (this.authenticationSuccessHandler == null) break block6;
                try {
                    this.authenticationSuccessHandler.onAuthenticationSuccess(request, response, authentication);
                }
                catch (IOException | ServletException e) {
                    LOGGER.warn("Error calling authenticationSuccessHandler: {}", (Object)e.getMessage());
                    LOGGER.trace("", e);
                    return false;
                }
            }
            catch (AuthenticationException e) {
                LOGGER.warn("Error authenticating user in custom authenticationmanager: {}", (Object)e.getMessage());
                this.sendAuthenticationFailed(request, response, e);
                return false;
            }
            catch (AccessDeniedException e) {
                LOGGER.warn("Error authorizing user in custom authenticationmanager: {}", (Object)e.getMessage());
                this.sendAccessDenied(request, response, e);
                return false;
            }
        }
        return true;
    }

    @Override
    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        if (this.getProvider() == null) {
            throw new ServletException("Missing NegotiateSecurityFilter.Provider");
        }
    }

    private void sendAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, AuthenticationException ae) {
        if (this.authenticationFailureHandler != null) {
            try {
                this.authenticationFailureHandler.onAuthenticationFailure(request, response, ae);
                return;
            }
            catch (IOException e) {
                LOGGER.warn("IOException invoking authenticationFailureHandler: {}", (Object)e.getMessage());
                LOGGER.trace("", (Throwable)e);
            }
            catch (ServletException e) {
                LOGGER.warn("ServletException invoking authenticationFailureHandler: {}", (Object)e.getMessage());
                LOGGER.trace("", (Throwable)e);
            }
        }
        super.sendUnauthorized(response, true);
    }

    private void sendAccessDenied(HttpServletRequest request, HttpServletResponse response, AccessDeniedException ae) {
        if (this.accessDeniedHandler != null) {
            try {
                this.accessDeniedHandler.handle(request, response, ae);
                return;
            }
            catch (IOException e) {
                LOGGER.warn("IOException invoking accessDeniedHandler: {}", (Object)e.getMessage());
                LOGGER.trace("", (Throwable)e);
            }
            catch (ServletException e) {
                LOGGER.warn("ServletException invoking accessDeniedHandler: {}", (Object)e.getMessage());
                LOGGER.trace("", (Throwable)e);
            }
        }
        this.sendUnauthorized(response, true);
    }

    public AuthenticationSuccessHandler getAuthenticationSuccessHandler() {
        return this.authenticationSuccessHandler;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler value) {
        this.authenticationSuccessHandler = value;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager value) {
        this.authenticationManager = value;
    }
}

