/*
 * Decompiled with CFR 0.152.
 */
package waffle.spring;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import waffle.servlet.WindowsPrincipal;
import waffle.spring.GrantedAuthorityFactory;
import waffle.spring.GuestLoginDisabledAuthenticationException;
import waffle.spring.WindowsAuthenticationToken;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;

public class WindowsAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsAuthenticationProvider.class);
    private PrincipalFormat principalFormat = PrincipalFormat.FQN;
    private PrincipalFormat roleFormat = PrincipalFormat.FQN;
    private boolean allowGuestLogin = true;
    private IWindowsAuthProvider authProvider;
    private GrantedAuthorityFactory grantedAuthorityFactory = WindowsAuthenticationToken.DEFAULT_GRANTED_AUTHORITY_FACTORY;
    private GrantedAuthority defaultGrantedAuthority = WindowsAuthenticationToken.DEFAULT_GRANTED_AUTHORITY;

    public WindowsAuthenticationProvider() {
        LOGGER.debug("[waffle.spring.WindowsAuthenticationProvider] loaded");
    }

    public Authentication authenticate(Authentication authentication) {
        UsernamePasswordAuthenticationToken auth = (UsernamePasswordAuthenticationToken)authentication;
        IWindowsIdentity windowsIdentity = this.authProvider.logonUser(auth.getName(), auth.getCredentials().toString());
        LOGGER.debug("logged in user: {} ({})", (Object)windowsIdentity.getFqn(), (Object)windowsIdentity.getSidString());
        if (!this.allowGuestLogin && windowsIdentity.isGuest()) {
            LOGGER.warn("guest login disabled: {}", (Object)windowsIdentity.getFqn());
            throw new GuestLoginDisabledAuthenticationException(windowsIdentity.getFqn());
        }
        WindowsPrincipal windowsPrincipal = new WindowsPrincipal(windowsIdentity, this.principalFormat, this.roleFormat);
        LOGGER.debug("roles: {}", (Object)windowsPrincipal.getRolesString());
        WindowsAuthenticationToken token = new WindowsAuthenticationToken(windowsPrincipal, this.grantedAuthorityFactory, this.defaultGrantedAuthority);
        LOGGER.info("successfully logged in user: {}", (Object)windowsIdentity.getFqn());
        return token;
    }

    public boolean supports(Class<? extends Object> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public PrincipalFormat getPrincipalFormat() {
        return this.principalFormat;
    }

    public void setPrincipalFormatEnum(PrincipalFormat value) {
        this.principalFormat = value;
    }

    public void setPrincipalFormat(String value) {
        this.setPrincipalFormatEnum(PrincipalFormat.valueOf((String)value.toUpperCase(Locale.ENGLISH)));
    }

    public PrincipalFormat getRoleFormat() {
        return this.roleFormat;
    }

    public void setRoleFormatEnum(PrincipalFormat value) {
        this.roleFormat = value;
    }

    public void setRoleFormat(String value) {
        this.setRoleFormatEnum(PrincipalFormat.valueOf((String)value.toUpperCase(Locale.ENGLISH)));
    }

    public boolean isAllowGuestLogin() {
        return this.allowGuestLogin;
    }

    public void setAllowGuestLogin(boolean value) {
        this.allowGuestLogin = value;
    }

    public IWindowsAuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public void setAuthProvider(IWindowsAuthProvider value) {
        this.authProvider = value;
    }

    public GrantedAuthorityFactory getGrantedAuthorityFactory() {
        return this.grantedAuthorityFactory;
    }

    public void setGrantedAuthorityFactory(GrantedAuthorityFactory value) {
        this.grantedAuthorityFactory = value;
    }

    public GrantedAuthority getDefaultGrantedAuthority() {
        return this.defaultGrantedAuthority;
    }

    public void setDefaultGrantedAuthority(GrantedAuthority value) {
        this.defaultGrantedAuthority = value;
    }
}

